/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei.world_transmute;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import moze_intel.projecte.integration.jei.world_transmute.WorldTransmuteRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class WorldTransmuteRecipeCategory
implements IRecipeCategory {
    public static final String UID = "pe.worldtransmute";
    private final IDrawable background;
    private final IDrawable arrow;
    private final String localizedName;

    public WorldTransmuteRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(175, 48);
        this.arrow = guiHelper.createDrawable(new ResourceLocation("projecte:textures/gui/arrow.png"), 0, 0, 32, 32);
        this.localizedName = I18n.func_135052_a((String)"pe.nei.worldtransmute", (Object[])new Object[0]);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, -30, 0);
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        if (!(recipeWrapper instanceof WorldTransmuteRecipeWrapper)) {
            return;
        }
        WorldTransmuteRecipeWrapper wrapper = (WorldTransmuteRecipeWrapper)recipeWrapper;
        boolean inputFluid = wrapper.getInputs().isEmpty();
        int itemSlots = 0;
        int fluidSlots = 0;
        if (inputFluid) {
            recipeLayout.getFluidStacks().init(fluidSlots, true, 16, 16, 16, 16, 1000, false, null);
            recipeLayout.getFluidStacks().set(fluidSlots, wrapper.getFluidInputs().get(0));
            ++fluidSlots;
        } else {
            recipeLayout.getItemStacks().init(itemSlots, true, 16, 16);
            recipeLayout.getItemStacks().set(itemSlots, wrapper.getInputs().get(0));
            ++itemSlots;
        }
        int xPos = 128;
        for (ItemStack itemStack : wrapper.getOutputs()) {
            recipeLayout.getItemStacks().init(itemSlots, false, xPos, 16);
            recipeLayout.getItemStacks().set(itemSlots, itemStack);
            ++itemSlots;
            xPos += 16;
        }
        xPos = 128;
        for (FluidStack fluidStack : wrapper.getFluidOutputs()) {
            recipeLayout.getFluidStacks().init(fluidSlots, false, xPos, 32, 16, 16, 1000, false, null);
            recipeLayout.getFluidStacks().set(fluidSlots, fluidStack);
            ++fluidSlots;
            xPos += 16;
        }
    }
}

