/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.utils.CollectionHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.NovaExplosion;
import moze_intel.projecte.utils.PELogger;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.ReflectionHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.passive.HorseType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.items.IItemHandler;

public final class WorldHelper {
    private static final ImmutableList<Class<? extends EntityLiving>> peacefuls = ImmutableList.of(EntitySheep.class, EntityPig.class, EntityCow.class, EntityMooshroom.class, EntityChicken.class, EntityBat.class, EntityVillager.class, EntitySquid.class, EntityOcelot.class, EntityWolf.class, EntityHorse.class, EntityRabbit.class, (Object[])new Class[0]);
    private static final ImmutableList<Class<? extends EntityLiving>> mobs = ImmutableList.of(EntityZombie.class, EntitySkeleton.class, EntityCreeper.class, EntitySpider.class, EntityEnderman.class, EntitySilverfish.class, EntityPigZombie.class, EntityGhast.class, EntityBlaze.class, EntitySlime.class, EntityWitch.class, EntityRabbit.class, (Object[])new Class[]{EntityEndermite.class});
    private static final Set<Class<? extends Entity>> interdictionBlacklist = Sets.newHashSet();
    private static final Set<Class<? extends Entity>> swrgBlacklist = Sets.newHashSet();

    public static boolean blacklistInterdiction(Class<? extends Entity> clazz) {
        if (!interdictionBlacklist.contains(clazz)) {
            interdictionBlacklist.add(clazz);
            return true;
        }
        return false;
    }

    public static boolean blacklistSwrg(Class<? extends Entity> clazz) {
        if (!interdictionBlacklist.contains(clazz)) {
            interdictionBlacklist.add(clazz);
            return true;
        }
        return false;
    }

    public static void createLootDrop(List<ItemStack> drops, World world, BlockPos pos) {
        WorldHelper.createLootDrop(drops, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void createLootDrop(List<ItemStack> drops, World world, double x, double y, double z) {
        if (drops.isEmpty()) {
            return;
        }
        ItemHelper.compactItemList(drops);
        for (ItemStack drop : drops) {
            WorldHelper.spawnEntityItem(world, drop, x, y, z);
        }
    }

    public static void createNovaExplosion(World world, Entity exploder, double x, double y, double z, float power) {
        NovaExplosion explosion = new NovaExplosion(world, exploder, x, y, z, power, true, true);
        if (!MinecraftForge.EVENT_BUS.post((Event)new ExplosionEvent.Start(world, (Explosion)explosion))) {
            explosion.func_77278_a();
            explosion.func_77279_a(true);
        }
    }

    public static void dropInventory(IItemHandler inv, World world, BlockPos pos) {
        if (inv == null) {
            return;
        }
        for (int i = 1; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null) continue;
            WorldHelper.spawnEntityItem(world, stack, pos);
        }
    }

    public static void extinguishNearby(World world, EntityPlayer player) {
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)new BlockPos((Entity)player).func_177982_a(-1, -1, -1), (BlockPos)new BlockPos((Entity)player).func_177982_a(1, 1, 1))) {
            if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150480_ab || !PlayerHelper.hasBreakPermission((EntityPlayerMP)player, pos)) continue;
            world.func_175698_g(pos);
        }
    }

    public static void freezeInBoundingBox(World world, AxisAlignedBB box, EntityPlayer player, boolean random) {
        for (BlockPos pos : WorldHelper.getPositionsFromBox(box)) {
            Block b2;
            Block b = world.func_180495_p(pos).func_177230_c();
            if (!(b != Blocks.field_150355_j && b != Blocks.field_150358_i || random && world.field_73012_v.nextInt(128) != 0)) {
                if (player != null) {
                    PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, pos, Blocks.field_150432_aD.func_176223_P());
                    continue;
                }
                world.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
                continue;
            }
            if (!b.isSideSolid(world.func_180495_p(pos), (IBlockAccess)world, pos, EnumFacing.UP) || (b2 = world.func_180495_p(pos.func_177984_a()).func_177230_c()) != Blocks.field_150350_a || random && world.field_73012_v.nextInt(128) != 0) continue;
            if (player != null) {
                PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, pos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                continue;
            }
            world.func_175656_a(pos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
        }
    }

    public static List<TileEntity> getAdjacentTileEntities(World world, TileEntity tile) {
        return ImmutableList.copyOf(WorldHelper.getAdjacentTileEntitiesMapped(world, tile).values());
    }

    public static Map<EnumFacing, TileEntity> getAdjacentTileEntitiesMapped(World world, TileEntity tile) {
        EnumMap<EnumFacing, TileEntity> ret = new EnumMap<EnumFacing, TileEntity>(EnumFacing.class);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity candidate = world.func_175625_s(tile.func_174877_v().func_177972_a(dir));
            if (candidate == null) continue;
            ret.put(dir, candidate);
        }
        return ret;
    }

    public static List<ItemStack> getBlockDrops(World world, EntityPlayer player, IBlockState state, ItemStack stack, BlockPos pos) {
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0 && state.func_177230_c().canSilkHarvest(world, pos, state, player)) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state))});
        }
        return state.func_177230_c().getDrops((IBlockAccess)world, pos, state, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
    }

    public static AxisAlignedBB getBroadDeepBox(BlockPos pos, EnumFacing direction, int offset) {
        switch (direction) {
            case EAST: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - offset), (double)(pos.func_177956_o() - offset), (double)(pos.func_177952_p() - offset), (double)pos.func_177958_n(), (double)(pos.func_177956_o() + offset), (double)(pos.func_177952_p() + offset));
            }
            case WEST: {
                return new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() - offset), (double)(pos.func_177952_p() - offset), (double)(pos.func_177958_n() + offset), (double)(pos.func_177956_o() + offset), (double)(pos.func_177952_p() + offset));
            }
            case UP: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - offset), (double)(pos.func_177956_o() - offset), (double)(pos.func_177952_p() - offset), (double)(pos.func_177958_n() + offset), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + offset));
            }
            case DOWN: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - offset), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - offset), (double)(pos.func_177958_n() + offset), (double)(pos.func_177956_o() + offset), (double)(pos.func_177952_p() + offset));
            }
            case SOUTH: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - offset), (double)(pos.func_177956_o() - offset), (double)(pos.func_177952_p() - offset), (double)(pos.func_177958_n() + offset), (double)(pos.func_177956_o() + offset), (double)pos.func_177952_p());
            }
            case NORTH: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - offset), (double)(pos.func_177956_o() - offset), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + offset), (double)(pos.func_177956_o() + offset), (double)(pos.func_177952_p() + offset));
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static AxisAlignedBB getDeepBox(BlockPos pos, EnumFacing direction, int depth) {
        switch (direction) {
            case EAST: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - depth), (double)(pos.func_177956_o() - 1), (double)(pos.func_177952_p() - 1), (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
            }
            case WEST: {
                return new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() - 1), (double)(pos.func_177952_p() - 1), (double)(pos.func_177958_n() + depth), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
            }
            case UP: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)(pos.func_177956_o() - depth), (double)(pos.func_177952_p() - 1), (double)(pos.func_177958_n() + 1), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 1));
            }
            case DOWN: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - 1), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + depth), (double)(pos.func_177952_p() + 1));
            }
            case SOUTH: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)(pos.func_177956_o() - 1), (double)(pos.func_177952_p() - depth), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            }
            case NORTH: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)(pos.func_177956_o() - 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + depth));
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static AxisAlignedBB getFlatYBox(BlockPos pos, int offset) {
        return new AxisAlignedBB((double)(pos.func_177958_n() - offset), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - offset), (double)(pos.func_177958_n() + offset), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + offset));
    }

    public static <T extends Entity> T getNewEntityInstance(Class<T> c, World world) {
        try {
            Constructor<T> constr = c.getConstructor(World.class);
            Entity ent = (Entity)constr.newInstance(world);
            if (ent instanceof EntitySkeleton) {
                if (world.field_73012_v.nextInt(2) == 0) {
                    ((EntitySkeleton)ent).func_82201_a(1);
                    ent.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
                } else {
                    ent.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                }
            } else if (ent instanceof EntityPigZombie) {
                ent.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151010_B));
            } else if (ent instanceof EntitySheep) {
                ((EntitySheep)ent).func_175512_b(EnumDyeColor.func_176764_b((int)MathUtils.randomIntInRange(0, 15)));
            } else if (ent instanceof EntityVillager) {
                VillagerRegistry.setRandomProfession((EntityVillager)((EntityVillager)ent), (Random)world.field_73012_v);
            } else if (ent instanceof EntityRabbit) {
                ((EntityRabbit)ent).func_175529_r(world.field_73012_v.nextInt(6));
            } else if (ent instanceof EntityHorse) {
                ((EntityHorse)ent).func_184778_a(HorseType.values()[MathUtils.randomIntInRange(0, 2)]);
                if (((EntityHorse)ent).func_184781_cZ() == HorseType.HORSE) {
                    ((EntityHorse)ent).func_110235_q(MathUtils.randomIntInRange(0, 6));
                }
            }
            return (T)ent;
        }
        catch (Exception e) {
            PELogger.logFatal("Could not create new entity instance for: " + c.getCanonicalName());
            e.printStackTrace();
            return null;
        }
    }

    public static Iterable<BlockPos> getPositionsFromBox(AxisAlignedBB box) {
        return BlockPos.func_177980_a((BlockPos)new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c), (BlockPos)new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f));
    }

    public static EntityLiving getRandomEntity(World world, EntityLiving toRandomize) {
        Class<?> entClass = toRandomize.getClass();
        if (peacefuls.contains(entClass)) {
            return (EntityLiving)WorldHelper.getNewEntityInstance(CollectionHelper.getRandomListEntry(peacefuls, entClass), world);
        }
        if (mobs.contains(entClass)) {
            EntityLiving ent = (EntityLiving)WorldHelper.getNewEntityInstance(CollectionHelper.getRandomListEntry(mobs, entClass), world);
            if (ent instanceof EntityRabbit) {
                ((EntityRabbit)ent).func_175529_r(99);
            }
            return ent;
        }
        if (world.field_73012_v.nextInt(2) == 0) {
            return (EntityLiving)WorldHelper.getNewEntityInstance(EntitySlime.class, world);
        }
        return (EntityLiving)WorldHelper.getNewEntityInstance(EntitySheep.class, world);
    }

    public static List<TileEntity> getTileEntitiesWithinAABB(World world, AxisAlignedBB bBox) {
        ArrayList list = Lists.newArrayList();
        for (BlockPos pos : WorldHelper.getPositionsFromBox(bBox)) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile == null) continue;
            list.add(tile);
        }
        return list;
    }

    public static void gravitateEntityTowards(Entity ent, double x, double y, double z) {
        double dX = x - ent.field_70165_t;
        double dY = y - ent.field_70163_u;
        double dZ = z - ent.field_70161_v;
        double dist = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        double vel = 1.0 - dist / 15.0;
        if (vel > 0.0) {
            vel *= vel;
            ent.field_70159_w += dX / dist * vel * 0.05;
            ent.field_70181_x += dY / dist * vel * 0.1;
            ent.field_70179_y += dZ / dist * vel * 0.05;
            ent.func_70091_d(ent.field_70159_w, ent.field_70181_x, ent.field_70179_y);
        }
    }

    public static void growNearbyRandomly(boolean harvest, World world, BlockPos pos, EntityPlayer player) {
        int chance = harvest ? 16 : 32;
        for (BlockPos currentPos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-5, -3, -5), (BlockPos)pos.func_177982_a(5, 3, 5))) {
            int age;
            IBlockState state = world.func_180495_p(currentPos);
            Block crop = state.func_177230_c();
            if (crop instanceof IShearable) {
                if (!harvest) continue;
                world.func_175655_b(currentPos, true);
                continue;
            }
            if (crop instanceof IGrowable) {
                IGrowable growable = (IGrowable)crop;
                if (!growable.func_176473_a(world, currentPos, state, false)) {
                    if (!harvest || player != null && !PlayerHelper.hasBreakPermission((EntityPlayerMP)player, currentPos)) continue;
                    world.func_175655_b(currentPos, true);
                    continue;
                }
                if (world.field_73012_v.nextInt(chance) != 0 || !ProjectEConfig.harvBandGrass && crop.func_149739_a().toLowerCase(Locale.ROOT).contains("grass")) continue;
                growable.func_176474_b(world, world.field_73012_v, currentPos, state);
                continue;
            }
            if (!(crop instanceof IPlantable)) continue;
            if (world.field_73012_v.nextInt(chance / 4) == 0) {
                for (int i = 0; i < (harvest ? 8 : 4); ++i) {
                    crop.func_180650_b(world, currentPos, state, world.field_73012_v);
                }
            }
            if (!harvest) continue;
            if (crop instanceof BlockFlower && (player == null || PlayerHelper.hasBreakPermission((EntityPlayerMP)player, pos))) {
                world.func_175655_b(currentPos, true);
            }
            if (crop == Blocks.field_150436_aH || crop == Blocks.field_150434_aF) {
                int i;
                boolean shouldHarvest = true;
                for (i = 1; i < 3; ++i) {
                    if (world.func_180495_p(currentPos.func_177981_b(i)).func_177230_c() == crop) continue;
                    shouldHarvest = false;
                    break;
                }
                if (shouldHarvest) {
                    int n = i = crop == Blocks.field_150436_aH ? 1 : 0;
                    while (i < 3) {
                        if (player != null && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, currentPos.func_177981_b(i))) {
                            world.func_175655_b(currentPos.func_177981_b(i), true);
                        } else if (player == null) {
                            world.func_175655_b(currentPos.func_177981_b(i), true);
                        }
                        ++i;
                    }
                }
            }
            if (crop != Blocks.field_150388_bm || (age = ((Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a)).intValue()) != 3 || player != null && (player == null || !PlayerHelper.hasBreakPermission((EntityPlayerMP)player, currentPos))) continue;
            world.func_175655_b(currentPos, true);
        }
    }

    public static void harvestVein(World world, EntityPlayer player, ItemStack stack, BlockPos pos, IBlockState target, List<ItemStack> currentDrops, int numMined) {
        if (numMined >= 250) {
            return;
        }
        AxisAlignedBB b = new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)(pos.func_177956_o() - 1), (double)(pos.func_177952_p() - 1), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
        for (BlockPos currentPos : WorldHelper.getPositionsFromBox(b)) {
            IBlockState currentState = world.func_180495_p(currentPos);
            Block block = currentState.func_177230_c();
            if (currentState != target && (target != Blocks.field_150439_ay || block != Blocks.field_150450_ax)) continue;
            ++numMined;
            if (!PlayerHelper.hasBreakPermission((EntityPlayerMP)player, pos)) continue;
            currentDrops.addAll(WorldHelper.getBlockDrops(world, player, currentState, stack, pos));
            world.func_175698_g(pos);
            WorldHelper.harvestVein(world, player, stack, pos, target, currentDrops, numMined);
        }
    }

    public static void igniteNearby(World world, EntityPlayer player) {
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)new BlockPos((Entity)player).func_177982_a(-8, -5, -8), (BlockPos)new BlockPos((Entity)player).func_177982_a(8, 5, 8))) {
            if (world.field_73012_v.nextInt(128) != 0 || !world.func_175623_d(pos)) continue;
            PlayerHelper.checkedPlaceBlock((EntityPlayerMP)player, pos, Blocks.field_150480_ab.func_176223_P());
            world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    public static boolean isArrowInGround(EntityArrow arrow) {
        return ReflectionHelper.getArrowInGround(arrow);
    }

    public static void repelEntitiesInAABBFromPoint(World world, AxisAlignedBB effectBounds, double x, double y, double z, boolean isSWRG) {
        List list = world.func_72872_a(Entity.class, effectBounds);
        for (Entity ent : list) {
            if ((!isSWRG || swrgBlacklist.contains(ent.getClass())) && (isSWRG || interdictionBlacklist.contains(ent.getClass())) || !(ent instanceof EntityLiving) && !(ent instanceof IProjectile) || !isSWRG && ProjectEConfig.interdictionMode && !(ent instanceof IMob) && !(ent instanceof IProjectile) || ent instanceof EntityArrow && ((EntityArrow)ent).field_70122_E) continue;
            Vec3d p = new Vec3d(x, y, z);
            Vec3d t = new Vec3d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
            double distance = p.func_72438_d(t) + 0.1;
            Vec3d r = new Vec3d(t.field_72450_a - p.field_72450_a, t.field_72448_b - p.field_72448_b, t.field_72449_c - p.field_72449_c);
            ent.field_70159_w += r.field_72450_a / 1.5 / distance;
            ent.field_70181_x += r.field_72448_b / 1.5 / distance;
            ent.field_70179_y += r.field_72449_c / 1.5 / distance;
        }
    }

    public static void spawnEntityItem(World world, ItemStack stack, BlockPos pos) {
        WorldHelper.spawnEntityItem(world, stack, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void spawnEntityItem(World world, ItemStack stack, double x, double y, double z) {
        float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        EntityItem entityitem = new EntityItem(world, x + (double)f, y + (double)f1, z + (double)f2, stack.func_77946_l());
        entityitem.field_70159_w = world.field_73012_v.nextGaussian() * 0.05;
        entityitem.field_70181_x = world.field_73012_v.nextGaussian() * 0.05 + 0.2;
        entityitem.field_70179_y = world.field_73012_v.nextGaussian() * 0.05;
        world.func_72838_d((Entity)entityitem);
    }
}

