/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.ai.misc;

import com.p1ut0nium.roughmobsrevamped.util.Constants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RoughAIBreakBlocks
extends EntityAIBase {
    public static final String BANS = Constants.unique("breakbans");
    public static final String LONG_POS = Constants.unique("breakpos");
    protected EntityLiving breaker;
    protected int range;
    protected World world;
    protected List<Block> allowedBlocks;
    protected BlockPos target;
    protected int breakingTime;
    protected int previousBreakProgress = -1;
    protected Block block;
    protected int neededTime;
    protected int idleTime;
    protected int curDistance;

    public RoughAIBreakBlocks(EntityLiving breaker, int range, List<Block> allowedBlocks) {
        this.breaker = breaker;
        this.range = range;
        this.world = breaker.field_70170_p;
        this.allowedBlocks = allowedBlocks;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!this.world.func_82736_K().func_82766_b("mobGriefing") || this.breaker.func_70638_az() != null) {
            return false;
        }
        BlockPos target = this.getFirstTarget();
        if (target != null) {
            this.target = target;
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.breakingTime = 0;
        this.idleTime = 0;
        this.block = this.world.func_180495_p(this.target).func_177230_c();
        this.neededTime = this.getBreakSpeed();
    }

    private int getBreakSpeed() {
        float multiplier = 100.0f;
        ItemStack held = this.breaker.func_184614_ca();
        IBlockState state = this.world.func_180495_p(this.target);
        if (held != null && held.func_77973_b() instanceof ItemTool) {
            multiplier -= ((ItemTool)held.func_77973_b()).func_150893_a(held, state) * 10.0f;
        }
        return (int)(state.func_185887_b(this.world, this.target) * Math.max(0.0f, multiplier) + 10.0f);
    }

    public void func_75246_d() {
        this.breaker.func_70661_as().func_75484_a(this.breaker.func_70661_as().func_179680_a(this.target), 1.0);
        EntityLiving breakerEntity = this.breaker;
        while (breakerEntity.func_184218_aH()) {
            breakerEntity = breakerEntity.func_184187_bx();
        }
        ++this.idleTime;
        double distance = this.target.func_177954_c(breakerEntity.field_70165_t, breakerEntity.field_70163_u, breakerEntity.field_70161_v);
        this.idleTime = (int)Math.round(distance) == this.curDistance ? ++this.idleTime : 0;
        if (this.idleTime >= 160) {
            this.banishTarget();
        }
        this.curDistance = (int)Math.round(distance);
        if (distance <= 2.0 && this.target != null) {
            ++this.breakingTime;
            int i = (int)((float)this.breakingTime / (float)this.neededTime * 10.0f);
            if (i != this.previousBreakProgress) {
                this.world.func_175715_c(this.breaker.func_145782_y(), this.target, i);
                this.previousBreakProgress = i;
            }
            if (this.breakingTime >= this.neededTime) {
                this.world.func_175698_g(this.target);
                this.world.func_175718_b(2001, this.target, Block.func_149682_b((Block)this.block));
                this.breakingTime = 0;
            }
        }
    }

    public boolean func_75253_b() {
        return this.target != null && (!(this.breaker instanceof EntityCreature) || ((EntityCreature)this.breaker).func_180485_d(this.target)) && this.world.func_180495_p(this.target).func_177230_c() == this.block && this.breaker.func_70638_az() == null;
    }

    public void func_75251_c() {
        this.breaker.func_70661_as().func_75499_g();
    }

    private BlockPos getFirstTarget() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockPos target = null;
        double bestDistance = Double.MAX_VALUE;
        EntityLiving breakerEntity = this.breaker;
        while (breakerEntity.func_184218_aH()) {
            breakerEntity = breakerEntity.func_184187_bx();
        }
        for (int i = -this.range; i <= this.range; ++i) {
            for (int j = -this.range; j <= this.range; ++j) {
                for (int k = -this.range; k <= this.range; ++k) {
                    BlockPos curPos = new BlockPos(breakerEntity.field_70165_t + (double)i, breakerEntity.field_70163_u + (double)j, breakerEntity.field_70161_v + (double)k);
                    Block block = this.world.func_180495_p(curPos).func_177230_c();
                    if (block instanceof BlockMobSpawner) {
                        return null;
                    }
                    if (!this.allowedBlocks.contains(block) || this.isBanned(curPos)) continue;
                    positions.add(curPos);
                }
            }
        }
        for (BlockPos pos : positions) {
            double distance = pos.func_177954_c(breakerEntity.field_70165_t, breakerEntity.field_70163_u, breakerEntity.field_70161_v);
            if (!(distance < bestDistance)) continue;
            target = pos;
            bestDistance = distance;
        }
        return target;
    }

    private void banishTarget() {
        if (this.breaker.getEntityData().func_74781_a(BANS) == null) {
            this.breaker.getEntityData().func_74782_a(BANS, (NBTBase)new NBTTagList());
        }
        NBTTagCompound comp = new NBTTagCompound();
        comp.func_74772_a(LONG_POS, this.target.func_177986_g());
        ((NBTTagList)this.breaker.getEntityData().func_74781_a(BANS)).func_74742_a((NBTBase)comp);
        this.target = null;
        this.func_75251_c();
    }

    private boolean isBanned(BlockPos pos) {
        long l = pos.func_177986_g();
        NBTTagList list = (NBTTagList)this.breaker.getEntityData().func_74781_a(BANS);
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            if (list.func_150305_b(i).func_74763_f(LONG_POS) != l) continue;
            return true;
        }
        return false;
    }
}

