/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.ai.combat.RoughAIInvisibleTarget;
import com.p1ut0nium.roughmobsrevamped.ai.misc.RoughAIBurnExplosion;
import com.p1ut0nium.roughmobsrevamped.ai.misc.RoughAISunlightBurn;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class CreeperFeatures
extends EntityFeatures {
    private float invisibleRange;
    private int fuseTime;
    private int explosionRadius;
    private boolean creeperBurn;
    private boolean creeperBurnExplosion;

    public CreeperFeatures() {
        super("creeper", EntityCreeper.class);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.invisibleRange = RoughConfig.getFloat(this.name, "InvisibleRange", 6.0f, 0.0f, 32767.0f, "Block range to the target in which %ss become invisible\nSet to 0 to prevent %ss from becoming invisible");
        this.fuseTime = RoughConfig.getInteger(this.name, "FuseTime", 20, 0, Short.MAX_VALUE, "Creeper fuse time (In ticks, 20 ticks = 1 second)\nThe vanilla default is 30");
        this.explosionRadius = RoughConfig.getInteger(this.name, "ExplosionRadius", 4, 0, Short.MAX_VALUE, "Creeper explosion radius\nThe vanilla default is 3");
        this.creeperBurn = RoughConfig.getBoolean(this.name, "CreeperBurn", false, "If true %ss burn in sunlight");
        this.creeperBurnExplosion = RoughConfig.getBoolean(this.name, "CreeperBurnExplosion", false, "If true %ss explode if they catch fire");
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, Entity entity, EntityAITasks tasks, EntityAITasks targetTasks) {
        if (!(entity instanceof EntityLiving)) {
            return;
        }
        if (this.invisibleRange > 0.0f) {
            tasks.func_75776_a(2, (EntityAIBase)new RoughAIInvisibleTarget((EntityLiving)entity, this.invisibleRange));
        }
        if (entity instanceof EntityCreeper) {
            if (this.fuseTime != 30) {
                ReflectionHelper.setPrivateValue(EntityCreeper.class, (Object)((EntityCreeper)entity), (Object)this.fuseTime, (int)5);
            }
            if (this.explosionRadius != 3) {
                ReflectionHelper.setPrivateValue(EntityCreeper.class, (Object)((EntityCreeper)entity), (Object)this.explosionRadius, (int)6);
            }
            if (this.creeperBurnExplosion) {
                tasks.func_75776_a(0, (EntityAIBase)new RoughAIBurnExplosion((EntityCreeper)entity));
            }
        }
        if (this.creeperBurn) {
            tasks.func_75776_a(0, (EntityAIBase)new RoughAISunlightBurn((EntityLiving)entity, false));
        }
    }
}

