/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.RoughMobs;
import com.p1ut0nium.roughmobsrevamped.ai.misc.RoughAIDespawn;
import com.p1ut0nium.roughmobsrevamped.ai.misc.RoughAISearchForRider;
import com.p1ut0nium.roughmobsrevamped.ai.misc.RoughAISunlightBurn;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.util.Constants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class HostileHorseFeatures
extends EntityFeatures {
    public static final String ROUGH_HORSE = Constants.unique("roughhorse");
    private boolean horseBurn;
    private int randomRiderChance;
    private boolean canDespawn;

    public HostileHorseFeatures() {
        super("hostileHorse", EntityZombieHorse.class, EntitySkeletonHorse.class);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.horseBurn = RoughConfig.getBoolean(this.name, "Burn", true, "Set this to false to prevent undead horses from burning in sunlight (as long as they have no rider)");
        this.randomRiderChance = RoughConfig.getInteger(this.name, "RandomRiderChance", 3, 0, Short.MAX_VALUE, "Chance (1 in X) that a random skeleton or zombie starts riding unmounted hostile horses around it");
        this.canDespawn = RoughConfig.getBoolean(this.name, "CanDespawn", true, "Set to false to prevent undead horses summoned through this mod from despawning");
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, Entity entity, EntityAITasks tasks, EntityAITasks targetTasks) {
        if (this.horseBurn && !entity.func_70045_F() && entity instanceof EntityLiving) {
            tasks.func_75776_a(0, (EntityAIBase)new RoughAISunlightBurn((EntityLiving)entity, false){

                @Override
                public boolean func_75250_a() {
                    return super.func_75250_a() && !this.entity.func_184207_aI();
                }
            });
        }
        if (entity instanceof EntityLiving && this.randomRiderChance > 0) {
            tasks.func_75776_a(1, (EntityAIBase)new RoughAISearchForRider((EntityLiving)entity, this.getRiders(entity), 32, this.randomRiderChance));
        }
        if (entity instanceof EntityLivingBase && this.shouldDespawn(entity)) {
            tasks.func_75776_a(1, (EntityAIBase)new RoughAIDespawn((EntityLivingBase)entity));
        }
    }

    @Override
    public void addFeatures(EntityJoinWorldEvent event, Entity entity) {
        if (entity instanceof EntityPlayer) {
            RoughMobs.logger.debug("Entity is player...skipping addFeatures");
            return;
        }
        if (entity instanceof EntityLiving && this.shouldDespawn(entity)) {
            ReflectionHelper.setPrivateValue(EntityLiving.class, (Object)((EntityLiving)entity), (Object)false, (int)17);
        }
    }

    private boolean shouldDespawn(Entity entity) {
        return this.canDespawn && entity.getEntityData().func_74767_n(ROUGH_HORSE);
    }

    private List<Class<? extends Entity>> getRiders(Entity entity) {
        ArrayList<Class<? extends Entity>> riders = new ArrayList<Class<? extends Entity>>();
        if (entity instanceof EntitySkeletonHorse) {
            riders.add(AbstractSkeleton.class);
        } else {
            riders.add(EntityZombie.class);
        }
        return riders;
    }
}

