/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.misc;

import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.entities.BossSkeleton;
import com.p1ut0nium.roughmobsrevamped.entities.BossZombie;
import com.p1ut0nium.roughmobsrevamped.entities.IBoss;
import com.p1ut0nium.roughmobsrevamped.misc.AttributeHelper;
import com.p1ut0nium.roughmobsrevamped.misc.EquipHelper;
import com.p1ut0nium.roughmobsrevamped.util.Constants;
import com.p1ut0nium.roughmobsrevamped.util.handlers.SoundHandler;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class BossHelper {
    public static final Random RND = new Random();
    public static final String BOSS = Constants.unique("isBoss");
    private static boolean bossWarning;
    private static boolean bossWarningSound;
    private static int bossWarningDist;
    public static boolean bossFogEnabled;
    public static String[] bossFogColor;
    public static int bossFogMaxDistance;
    public static int bossFogFarPlane;
    public static float bossFogFarPlaneScale;
    public static int bossFogStartDistance;
    public static boolean bossFogPlayerCough;
    public static boolean bossFogDoTEnabled;
    public static int bossFogDoTDelay;
    public static boolean bossFogDoTWarning;
    public static int bossFogDoTWarningTime;
    public static int bossFogDoTDamage;
    public static boolean bossBatSwarmEnabled;
    public static int bossBatSwarmCount;
    public static int bossBatSwarmDelay;
    public static int bossBatSwarmRange;
    public static int bossBatSwarmDamage;
    public static int bossBatSwarmHealth;
    public static int bossBatSwarmAttackRange;

    public static void initGlobalBossConfig() {
        if (!BossHelper.hasDefaultConfig()) {
            return;
        }
        RoughConfig.getConfig().addCustomCategoryComment("BossGlobal", "Miscellaneous config options which affect all bosses");
        bossWarning = RoughConfig.getBoolean("BossGlobal", "_SpawnWarning", true, "Enable this to have a chat message warning of a boss spawn.");
        bossWarningDist = RoughConfig.getInteger("BossGlobal", "_SpawnWarningDistance", 50, 0, Short.MAX_VALUE, "Max bos spawn distance from a player that will trigger a warning.\nUsed for both chat messages and sounds.");
        bossWarningSound = RoughConfig.getBoolean("BossGlobal", "_SpawnWarningSound", true, "Play a warning sound when a boss spawns.");
        RoughConfig.getConfig().addCustomCategoryComment("BossFog", "Configuration options for adjusting the poisonous fog that shrouds all bosses.");
        bossFogEnabled = RoughConfig.getBoolean("BossFog", "_Enabled", true, "Enable this to have thick colored fog around bosses.", true);
        bossFogColor = RoughConfig.getStringArray("BossFog", "_FogColor", Constants.FOG_COLORS, "Change these three values between 0.0 and 1.0 to change the fog color.\nRed, Green, Blue\n");
        bossFogMaxDistance = RoughConfig.getInteger("BossFog", "_FogMaxDist", 20, 0, 100, "Max distance from boss for fog to render.\nFog will only occur if you are within this distance");
        bossFogStartDistance = RoughConfig.getInteger("BossFog", "_FogStartDist", 1, 0, 50, "How far away from boss before fog begins to fade from maximum density.\nMust be a value lower than BossFogMaxDist");
        bossFogFarPlane = RoughConfig.getInteger("BossFog", "_FogFarPlane", 10, 0, 192, "This effects how far away from you before the fog is at maximum thickness.");
        bossFogFarPlaneScale = RoughConfig.getFloat("BossFog", "_FogFarPlaneScale", 0.2f, 0.0f, 0.8f, "This controls how thick/strong the fog is.");
        bossFogDoTEnabled = RoughConfig.getBoolean("BossFog", "_DoTEnabled", true, "If enabled, boss fog will cause poison damage over time.", true);
        bossFogDoTDelay = RoughConfig.getInteger("BossFog", "_DoTCoolDown", 10, 0, Short.MAX_VALUE, "The cooldown (in seconds) between each damage event while inside the fog.");
        bossFogDoTWarning = RoughConfig.getBoolean("BossFog", "_DoTWarning", true, "Should the player recieve a chat warning message when entering the poisonous fog?");
        bossFogDoTWarningTime = RoughConfig.getInteger("BossFog", "_DoTWarningTime", 60, 1, Short.MAX_VALUE, "Controls how frequent (in seconds) a player can be warned when entering boss fog.");
        bossFogDoTDamage = RoughConfig.getInteger("BossFog", "_DoTDamage", 1, 1, 127, "How many half hearts the fog DoT does per hit.");
        bossFogPlayerCough = RoughConfig.getBoolean("BossFog", "_PlayerCough", true, "Disable this if you find the player cough sound annoying.\nOnly happens in poisonous fog.");
        RoughConfig.getConfig().addCustomCategoryComment("BatSwarm", "Configuration options for the Bat Swarm attack.");
        bossBatSwarmEnabled = RoughConfig.getBoolean("BatSwarm", "_Enabled", true, "Disable this if you don't want bosses to use Bat Swarm attacks.", true);
        bossBatSwarmCount = RoughConfig.getInteger("BatSwarm", "_BatCount", 3, 0, Short.MAX_VALUE, "The number of bats that attack when a boss fires his Bat Swarm ability.");
        bossBatSwarmDelay = RoughConfig.getInteger("BatSwarm", "_CoolDown", 3, 0, Short.MAX_VALUE, "The cooldown (in seconds) before the boss can fire Bat Swarm again.");
        bossBatSwarmRange = RoughConfig.getInteger("BatSwarm", "_UseRange", 20, 0, Short.MAX_VALUE, "How close a player must be to the boss before it will fire off a Bat Swarm attack.");
        bossBatSwarmAttackRange = RoughConfig.getInteger("BatSwarm", "_BatAttackRange", 20, 0, Short.MAX_VALUE, "How close a player must be before the bat swarm attacks.");
        bossBatSwarmDamage = RoughConfig.getInteger("BatSwarm", "_Damage", 1, 0, Short.MAX_VALUE, "How many half hearts (minus damage immunity) each bat does on attack.");
        bossBatSwarmHealth = RoughConfig.getInteger("BatSwarm", "_Health", 6, 1, Short.MAX_VALUE, "How much health each bat in the swarm has.");
    }

    public static boolean hasDefaultConfig() {
        return true;
    }

    public static boolean isBoss(Entity entity) {
        return entity.getEntityData() != null && entity.getEntityData().func_74767_n(BOSS);
    }

    public static abstract class BossApplier {
        private EquipHelper.EquipmentApplier equipApplier;
        private final String name;
        private final int defaultBossChance;
        private final float defaultEnchMultiplier;
        private final float defaultDropChance;
        private final String[] defaultBossNames;
        private int bossChance;
        private String[] bossNames;

        public BossApplier(String name, int defaultBossChance, float defaultEnchMultiplier, float defaultDropChance, String[] defaultBossNames) {
            this.name = name;
            this.defaultBossChance = defaultBossChance;
            this.defaultEnchMultiplier = defaultEnchMultiplier;
            this.defaultDropChance = defaultDropChance;
            this.defaultBossNames = defaultBossNames;
            this.equipApplier = new EquipHelper.EquipmentApplier(name + " boss", 1, 1, 1, this.defaultEnchMultiplier, this.defaultDropChance);
        }

        public void initConfig() {
            this.equipApplier.initConfig(Constants.DEFAULT_BOSS_MAINHAND, Constants.DEFAULT_BOSS_OFFHAND, Constants.DEFAULT_BOSS_HELMETS, Constants.DEFAULT_BOSS_CHESTPLATES, Constants.DEFAULT_BOSS_LEGGINGS, Constants.DEFAULT_BOSS_BOOTS, Constants.DEFAULT_WEAPON_ENCHANTS, Constants.DEFAULT_ARMOR_ENCHANTS, true);
            this.bossChance = RoughConfig.getInteger(this.name, "_BossChance", this.defaultBossChance, 0, Short.MAX_VALUE, "Chance (1 in X) for a newly spawned " + this.name + " to become a boss " + this.name);
            this.bossNames = RoughConfig.getStringArray(this.name, "_BossNames", this.defaultBossNames, this.name + " boss names. Please be more creative than I am... :P");
        }

        public void postInit() {
            this.equipApplier.createPools();
        }

        public EntityLiving trySetBoss(Entity entity) {
            String entityTypeName;
            if (this.bossChance <= 0 || RND.nextInt(this.bossChance) != 0 || entity instanceof EntityZombie && ((EntityZombie)entity).func_70631_g_()) {
                return null;
            }
            IBoss boss = null;
            switch (entityTypeName = entity.func_70005_c_()) {
                case "Zombie": {
                    boss = new BossZombie(entity.field_70170_p);
                    ((EntityLiving)boss).func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    entity.field_70170_p.func_72838_d((Entity)boss);
                    break;
                }
                case "Skeleton": {
                    boss = new BossSkeleton(entity.field_70170_p);
                    ((EntityLiving)boss).func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    entity.field_70170_p.func_72838_d((Entity)((BossSkeleton)boss));
                }
            }
            entity.func_70106_y();
            if (boss != null) {
                AttributeHelper.applyAttributeModifier((EntityLivingBase)((EntityLiving)boss), SharedMonsterAttributes.field_111267_a, this.name + "BossHealth", 0, ((EntityLiving)boss).func_110138_aP() * 2.0f);
                AttributeHelper.applyAttributeModifier((EntityLivingBase)((EntityLiving)boss), SharedMonsterAttributes.field_111266_c, this.name + "BossKnock", 1, 1.0);
                boolean isBoss = true;
                this.equipApplier.equipEntity((EntityLiving)boss, isBoss);
                String bossName = this.bossNames[RND.nextInt(this.bossNames.length)];
                ((EntityLiving)boss).func_96094_a(bossName);
                if (bossWarning) {
                    TextComponentString bossWarningMsg = new TextComponentString(bossName + ", a powerful " + entityTypeName + " warlord, has joined the battlefield.");
                    bossWarningMsg.func_150256_b().func_150238_a(TextFormatting.RED);
                    bossWarningMsg.func_150256_b().func_150227_a(Boolean.valueOf(true));
                    List players = ((EntityLiving)boss).field_70170_p.func_72872_a(EntityPlayer.class, ((EntityLiving)boss).func_174813_aQ().func_186662_g((double)bossWarningDist));
                    if (players != null) {
                        for (EntityPlayer player : players) {
                            player.func_145747_a((ITextComponent)bossWarningMsg);
                        }
                    }
                }
                if (bossWarningSound) {
                    ((EntityLiving)boss).func_184185_a(SoundHandler.ENTITY_BOSS_SPAWN, (float)(bossWarningDist / 16), 0.5f);
                }
                ((EntityLiving)boss).getEntityData().func_74757_a(BOSS, true);
                this.addBossFeatures((Entity)((EntityLiving)boss));
                return (EntityLiving)boss;
            }
            return null;
        }

        public abstract void addBossFeatures(Entity var1);
    }
}

