/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.config;

import com.p1ut0nium.roughmobsrevamped.config.ConfigHolder;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import java.util.List;
import net.minecraft.world.Explosion;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigHelper {
    private static ModConfig modCompatConfig;
    private static ModConfig spawnConditionsConfig;
    private static ModConfig equipmentConfig;
    private static ModConfig featuresConfig;
    private static ModConfig attributesConfig;
    private static ModConfig fogConfig;

    public static void bakeModCompat(ModConfig config) {
        modCompatConfig = config;
        RoughConfig.useAllStages = (Boolean)ConfigHolder.MODCOMPAT.useAllStages.get();
        RoughConfig.useAbilitiesStage = (Boolean)ConfigHolder.MODCOMPAT.useAbilitiesStage.get();
        RoughConfig.useBossStage = (Boolean)ConfigHolder.MODCOMPAT.useBossStage.get();
        RoughConfig.useEnchantStage = (Boolean)ConfigHolder.MODCOMPAT.useEnchantStage.get();
        RoughConfig.useEquipmentStage = (Boolean)ConfigHolder.MODCOMPAT.useEquipmentStage.get();
        RoughConfig.seasonWhiteList = (List)ConfigHolder.MODCOMPAT.seasonWhiteList.get();
    }

    public static void bakeSpawnConditions(ModConfig config) {
        spawnConditionsConfig = config;
        RoughConfig.minPlayerLevel = (Integer)ConfigHolder.SPAWNCONDITIONS.minPlayerLevel.get();
        RoughConfig.mustBeUnderground = (Boolean)ConfigHolder.SPAWNCONDITIONS.mustBeUnderground.get();
        RoughConfig.maxSpawnHeight = (Integer)ConfigHolder.SPAWNCONDITIONS.maxSpawnHeight.get();
        RoughConfig.minDistFromSpawn = (Integer)ConfigHolder.SPAWNCONDITIONS.minDistFromSpawn.get();
    }

    public static void bakeEquipment(ModConfig config) {
        equipmentConfig = config;
        RoughConfig.chancePerWeapon = (Integer)ConfigHolder.EQUIPMENT.chancePerWeapon.get();
        RoughConfig.chancePerArmor = (Integer)ConfigHolder.EQUIPMENT.chancePerArmor.get();
        RoughConfig.chancePerEnchantment = (Integer)ConfigHolder.EQUIPMENT.chancePerEnchantment.get();
        RoughConfig.enchantMultiplier = ((Double)ConfigHolder.EQUIPMENT.enchantMultiplier.get()).floatValue();
        RoughConfig.dropChance = ((Double)ConfigHolder.EQUIPMENT.dropChance.get()).floatValue();
        RoughConfig.chanceTimeMultiplier = (Boolean)ConfigHolder.EQUIPMENT.chanceTimeMultiplier.get();
        RoughConfig.chanceDistMultiplier = (Boolean)ConfigHolder.EQUIPMENT.chanceDistMultiplier.get();
        RoughConfig.distThreshold = (Integer)ConfigHolder.EQUIPMENT.distThreshold.get();
        RoughConfig.disableBabyZombieEquipment = (Boolean)ConfigHolder.EQUIPMENT.disableBabyZombieEquipment.get();
        RoughConfig.equipMainhand = (List)ConfigHolder.EQUIPMENT.equipMainhand.get();
        RoughConfig.equipOffhand = (List)ConfigHolder.EQUIPMENT.equipOffhand.get();
        RoughConfig.equipHelmet = (List)ConfigHolder.EQUIPMENT.equipHelmet.get();
        RoughConfig.equipChestplate = (List)ConfigHolder.EQUIPMENT.equipChestplate.get();
        RoughConfig.equipLeggings = (List)ConfigHolder.EQUIPMENT.equipLeggings.get();
        RoughConfig.equipBoots = (List)ConfigHolder.EQUIPMENT.equipBoots.get();
        RoughConfig.equipWeaponEnchants = (List)ConfigHolder.EQUIPMENT.equipWeaponEnchants.get();
        RoughConfig.equipArmorEnchants = (List)ConfigHolder.EQUIPMENT.equipArmorEnchants.get();
    }

    public static void bakeFeatures(ModConfig config) {
        featuresConfig = config;
        RoughConfig.blazeFeaturesEnabled = (Boolean)ConfigHolder.FEATURES.blazeFeaturesEnabled.get();
        RoughConfig.blazePushAttackersAway = (Boolean)ConfigHolder.FEATURES.blazePushAttackersAway.get();
        RoughConfig.blazeFlameTouch = (Boolean)ConfigHolder.FEATURES.blazeFlameTouch.get();
        RoughConfig.blazePushDamage = ((Double)ConfigHolder.FEATURES.blazePushDamage.get()).floatValue();
        RoughConfig.blazeDeathExplosionStrength = ((Double)ConfigHolder.FEATURES.blazeDeathExplosionStrength.get()).floatValue();
        RoughConfig.blazeDeathExplosionType = (Explosion.Mode)ConfigHolder.FEATURES.blazeDeathExplosionType.get();
        RoughConfig.blazeEntities = (List)ConfigHolder.FEATURES.blazeEntities.get();
        RoughConfig.featuresEnabled.put("blaze", (Boolean)ConfigHolder.FEATURES.blazeFeaturesEnabled.get());
        RoughConfig.entities.put("blaze", (List<String>)ConfigHolder.FEATURES.blazeEntities.get());
        RoughConfig.hostileHorseFeaturesEnabled = (Boolean)ConfigHolder.FEATURES.hostileHorseFeaturesEnabled.get();
        RoughConfig.hostileHorseEntities = (List)ConfigHolder.FEATURES.hostileHorseEntities.get();
        RoughConfig.hostileHorseBurn = (Boolean)ConfigHolder.FEATURES.hostileHorseBurn.get();
        RoughConfig.hostileHorseCanDespawn = (Boolean)ConfigHolder.FEATURES.hostileHorseCanDespawn.get();
        RoughConfig.hostileHorseRiderChance = (Integer)ConfigHolder.FEATURES.hostileHorseRiderChance.get();
        RoughConfig.featuresEnabled.put("hostileHorse", (Boolean)ConfigHolder.FEATURES.hostileHorseFeaturesEnabled.get());
        RoughConfig.entities.put("hostileHorse", (List<String>)ConfigHolder.FEATURES.hostileHorseEntities.get());
        RoughConfig.spiderFeaturesEnabled = (Boolean)ConfigHolder.FEATURES.spiderFeaturesEnabled.get();
        RoughConfig.spiderEntities = (List)ConfigHolder.FEATURES.spiderEntities.get();
        RoughConfig.spiderIgnoreFallDamage = ((Double)ConfigHolder.FEATURES.spiderIgnoreFallDamage.get()).floatValue();
        RoughConfig.spiderRiderChance = (Integer)ConfigHolder.FEATURES.spiderRiderChance.get();
        RoughConfig.spiderRiderChanceRandom = (Integer)ConfigHolder.FEATURES.spiderRiderChanceRandom.get();
        RoughConfig.spiderRiderEntities = (List)ConfigHolder.FEATURES.spiderRiderEntities.get();
        RoughConfig.spiderSlownessChance = (Integer)ConfigHolder.FEATURES.spiderSlownessChance.get();
        RoughConfig.spiderSlownessCreateWeb = (Boolean)ConfigHolder.FEATURES.spiderSlownessCreateWeb.get();
        RoughConfig.spiderSlownessDuration = (Integer)ConfigHolder.FEATURES.spiderSlownessDuration.get();
        RoughConfig.featuresEnabled.put("spider", (Boolean)ConfigHolder.FEATURES.spiderFeaturesEnabled.get());
        RoughConfig.entities.put("spider", (List<String>)ConfigHolder.FEATURES.spiderEntities.get());
        RoughConfig.zombieFeaturesEnabled = (Boolean)ConfigHolder.FEATURES.zombieFeaturesEnabled.get();
        RoughConfig.zombieEntities = (List)ConfigHolder.FEATURES.zombieEntities.get();
        RoughConfig.zombieBabyBurn = (Boolean)ConfigHolder.FEATURES.zombieBabyBurn.get();
        RoughConfig.zombieHelmetBurn = (Boolean)ConfigHolder.FEATURES.zombieHelmetBurn.get();
        RoughConfig.zombieHorseChance = (Integer)ConfigHolder.FEATURES.zombieHorseChance.get();
        RoughConfig.zombieHorseMinY = (Integer)ConfigHolder.FEATURES.zombieHorseMinY.get();
        RoughConfig.zombieHungerChance = (Integer)ConfigHolder.FEATURES.zombieHungerChance.get();
        RoughConfig.zombieHungerDuration = (Integer)ConfigHolder.FEATURES.zombieHungerDuration.get();
        RoughConfig.zombieLeapChance = (Integer)ConfigHolder.FEATURES.zombieLeapChance.get();
        RoughConfig.zombieChampionChance = (Integer)ConfigHolder.FEATURES.zombieChampionChance.get();
        RoughConfig.zombieLeapHeight = ((Double)ConfigHolder.FEATURES.zombieLeapHeight.get()).floatValue();
        RoughConfig.zombieBreakBlocks = (List)ConfigHolder.FEATURES.zombieBreakBlocks.get();
        RoughConfig.zombieChampionNames = (List)ConfigHolder.FEATURES.zombieChampionNames.get();
        RoughConfig.featuresEnabled.put("zombie", (Boolean)ConfigHolder.FEATURES.zombieFeaturesEnabled.get());
        RoughConfig.entities.put("zombie", (List<String>)ConfigHolder.FEATURES.zombieEntities.get());
        RoughConfig.zombiePigmanFeaturesEnabled = (Boolean)ConfigHolder.FEATURES.zombiePigmanFeaturesEnabled.get();
        RoughConfig.zombiePigmanAggressiveTouch = (Boolean)ConfigHolder.FEATURES.zombiePigmanAggressiveTouch.get();
        RoughConfig.zombiePigmanAlwaysAggressive = (Boolean)ConfigHolder.FEATURES.zombiePigmanAlwaysAggressive.get();
        RoughConfig.zombiePigmanAggressiveRange = (Integer)ConfigHolder.FEATURES.zombiePigmanAggressiveRange.get();
        RoughConfig.zombiePigmanAggressiveBlockRange = (Integer)ConfigHolder.FEATURES.zombiePigmanAggressiveBlockRange.get();
        RoughConfig.zombiePigmanAggressiveBlockChance = (Integer)ConfigHolder.FEATURES.zombiePigmanAggressiveBlockChance.get();
        RoughConfig.zombiePigmanEntities = (List)ConfigHolder.FEATURES.zombiePigmanEntities.get();
        RoughConfig.featuresEnabled.put("zombie_pigman", (Boolean)ConfigHolder.FEATURES.zombiePigmanFeaturesEnabled.get());
        RoughConfig.entities.put("zombie_pigman", (List<String>)ConfigHolder.FEATURES.zombiePigmanEntities.get());
    }

    public static void bakeAttributes(ModConfig config) {
        RoughConfig.attributes = (List)ConfigHolder.ATTRIBUTES.options.get();
    }

    public static void bakeFog(ModConfig config) {
        fogConfig = config;
        RoughConfig.bossFogEnabled = (Boolean)ConfigHolder.FOG.bossFogEnabled.get();
        RoughConfig.bossFogColor = (List)ConfigHolder.FOG.bossFogColor.get();
        RoughConfig.bossFogMaxDist = (Integer)ConfigHolder.FOG.bossFogMaxDist.get();
        RoughConfig.bossFogStartDist = (Integer)ConfigHolder.FOG.bossFogStartDist.get();
        RoughConfig.bossFogFarPlane = (Integer)ConfigHolder.FOG.bossFogFarPlane.get();
        RoughConfig.bossFogFarPlaneScale = ((Double)ConfigHolder.FOG.bossFogFarPlaneScale.get()).floatValue();
        RoughConfig.bossFogDoTEnabled = (Boolean)ConfigHolder.FOG.bossFogDoTEnabled.get();
        RoughConfig.bossFogDoTWarning = (Boolean)ConfigHolder.FOG.bossFogDoTWarning.get();
        RoughConfig.bossFogPlayerCough = (Boolean)ConfigHolder.FOG.bossFogPlayerCough.get();
        RoughConfig.bossFogDoTDelay = (Integer)ConfigHolder.FOG.bossFogDoTDelay.get();
        RoughConfig.bossFogDoTWarningTime = (Integer)ConfigHolder.FOG.bossFogDoTWarningTime.get();
        RoughConfig.bossFogDoTDamage = (Integer)ConfigHolder.FOG.bossFogDoTDamage.get();
    }

    public static void setValueAndSave(ModConfig modConfig, String path, Object newValue) {
        modConfig.getConfigData().set(path, newValue);
        modConfig.save();
    }
}

