/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.config;

import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.reference.Constants;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.ForgeConfigSpec;

public class FeaturesConfig {
    final ForgeConfigSpec.BooleanValue blazeFeaturesEnabled;
    final ForgeConfigSpec.BooleanValue blazePushAttackersAway;
    final ForgeConfigSpec.BooleanValue blazeFlameTouch;
    final ForgeConfigSpec.DoubleValue blazePushDamage;
    final ForgeConfigSpec.DoubleValue blazeDeathExplosionStrength;
    final ForgeConfigSpec.EnumValue<Explosion.Mode> blazeDeathExplosionType;
    final ForgeConfigSpec.ConfigValue<List<String>> blazeEntities;
    final ForgeConfigSpec.BooleanValue spiderFeaturesEnabled;
    final ForgeConfigSpec.BooleanValue spiderSlownessCreateWeb;
    final ForgeConfigSpec.IntValue spiderSlownessChance;
    final ForgeConfigSpec.IntValue spiderSlownessDuration;
    final ForgeConfigSpec.IntValue spiderRiderChance;
    final ForgeConfigSpec.IntValue spiderRiderChanceRandom;
    final ForgeConfigSpec.DoubleValue spiderIgnoreFallDamage;
    final ForgeConfigSpec.ConfigValue<List<String>> spiderEntities;
    final ForgeConfigSpec.ConfigValue<List<String>> spiderRiderEntities;
    final ForgeConfigSpec.BooleanValue zombieFeaturesEnabled;
    final ForgeConfigSpec.BooleanValue zombieBabyBurn;
    final ForgeConfigSpec.BooleanValue zombieHelmetBurn;
    final ForgeConfigSpec.IntValue zombieHorseChance;
    final ForgeConfigSpec.IntValue zombieHorseMinY;
    final ForgeConfigSpec.IntValue zombieHungerChance;
    final ForgeConfigSpec.IntValue zombieHungerDuration;
    final ForgeConfigSpec.IntValue zombieLeapChance;
    final ForgeConfigSpec.IntValue zombieChampionChance;
    final ForgeConfigSpec.DoubleValue zombieLeapHeight;
    final ForgeConfigSpec.ConfigValue<List<String>> zombieEntities;
    final ForgeConfigSpec.ConfigValue<List<? extends String>> zombieBreakBlocks;
    final ForgeConfigSpec.ConfigValue<List<? extends String>> zombieChampionNames;
    final ForgeConfigSpec.BooleanValue zombiePigmanFeaturesEnabled;
    final ForgeConfigSpec.BooleanValue zombiePigmanAggressiveTouch;
    final ForgeConfigSpec.BooleanValue zombiePigmanAlwaysAggressive;
    final ForgeConfigSpec.IntValue zombiePigmanAggressiveRange;
    final ForgeConfigSpec.IntValue zombiePigmanAggressiveBlockRange;
    final ForgeConfigSpec.IntValue zombiePigmanAggressiveBlockChance;
    final ForgeConfigSpec.ConfigValue<List<String>> zombiePigmanEntities;
    final ForgeConfigSpec.BooleanValue hostileHorseFeaturesEnabled;
    final ForgeConfigSpec.BooleanValue hostileHorseBurn;
    final ForgeConfigSpec.BooleanValue hostileHorseCanDespawn;
    final ForgeConfigSpec.IntValue hostileHorseRiderChance;
    final ForgeConfigSpec.ConfigValue<List<String>> hostileHorseEntities;

    FeaturesConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Blaze Features");
        this.blazeFeaturesEnabled = builder.comment("Set to false to disable all Blaze features.").define("Blaze_FeaturesEnabled", true);
        this.blazePushAttackersAway = builder.comment("Set to false to prevent Blazes from pushing attackers away.").define("Blaze_PushAttackersAway", true);
        this.blazePushDamage = builder.comment("The amount of damage done when pushed by a Blaze.").defineInRange("Blaze_PushDamage", 1.0, 0.0, 32767.0);
        this.blazeFlameTouch = builder.comment("Set to false to prevent Blazes from igniting entities which touch their hitbox.").define("Blaze_FlameTouch", true);
        this.blazeDeathExplosionStrength = builder.comment(new String[]{"Explosion strength which Blazes create on death.", "Set to 0 to disable this feature "}).defineInRange("Blaze_DeathExplosionStrength", 1.0, 0.0, 32767.0);
        this.blazeDeathExplosionType = builder.comment(new String[]{"The type of explosion that occurs when a Blaze dies:", "NONE = no effect other than damage to player", "BREAK = break blocks in range; broken blocks drop items", "DESTROY = destroy blocks and items"}).defineEnum("Blaze_DeathExplosionType", (Enum)Explosion.Mode.NONE);
        this.blazeEntities = builder.comment("Entities which count as Blaze entities").define("Blaze_Entities", Constants.getRegNames(Arrays.asList(Constants.BLAZES)));
        builder.pop();
        builder.push("Hostile Horse Features");
        this.hostileHorseFeaturesEnabled = builder.comment("Set to false to disable all hostile horse features.").define("HostileHorse_FeaturesEnabled", true);
        this.hostileHorseBurn = builder.comment("Set this to false to prevent undead horses from burning in sunlight (as long as they have no rider).").define("HostileHorse_DaylightBurn", true);
        this.hostileHorseCanDespawn = builder.comment("Set to false to prevent undead horses summoned by this mod from despawning.").define("HostileHorse_CanDespawn", true);
        this.hostileHorseRiderChance = builder.comment("Chance (1 in X) that a random skeleton or zombie starts riding unmounted hostile horses around it.").defineInRange("HostileHorse_RiderChance", 3, 0, Short.MAX_VALUE);
        this.hostileHorseEntities = builder.comment("Entities which count as hostile horses.").define("HostileHorse_Entities", Constants.getRegNames(Arrays.asList(Constants.HOSTILE_HORSES)));
        builder.pop();
        builder.push("Spider Features");
        this.spiderFeaturesEnabled = builder.comment("Enable this to use all Spider features.").define("Spider_FeaturesEnabled", true);
        this.spiderRiderChance = builder.comment(new String[]{"Chance (1 in X) for a spider to spawn with another entity riding it.", "Set to 0 to disable this feature."}).defineInRange("Spider_SpawnedRiderChance", 10, 0, Short.MAX_VALUE);
        this.spiderRiderChanceRandom = builder.comment(new String[]{"Chance (1 in X) that a randomly spawned entity from the RiderEntities list can start riding on random spiders.", "Set to 0 to disable this feature."}).defineInRange("Spider_StartRidingChance", 10, 0, Short.MAX_VALUE);
        this.spiderSlownessChance = builder.comment(new String[]{"Chance (1 in X) for a spider to apply the slowness effect on attack.", "Set to 0 to disable this feature."}).defineInRange("Spider_SlownessChance", 1, 0, Short.MAX_VALUE);
        this.spiderSlownessDuration = builder.comment("Duration in seconds of the applied slowness effect.").defineInRange("Spider_SlownessDuration", 10, 0, Short.MAX_VALUE);
        this.spiderSlownessCreateWeb = builder.comment("Set this to false to prevent spiders from creating webs on slowed targets.").define("Spider_SlownessWeb", true);
        this.spiderIgnoreFallDamage = builder.comment("The fall damage spiders take is multiplied by this value (0.0 means no fall damage, 1.0 means normal full damage).").defineInRange("Spider_IgnoreFallDamageMultiplier", 0.0, 0.0, 1.0);
        this.spiderEntities = builder.comment("Entities which count as Spiders.").define("Spider_Entities", Constants.getRegNames(Arrays.asList(Constants.SPIDERS)));
        this.spiderRiderEntities = builder.comment("Entities which may ride on spiders.").define("Spider_RiderEntities", Constants.getRegNames(Arrays.asList(Constants.DEFAULT_SPIDER_RIDERS)));
        builder.pop();
        builder.push("Zombie Features");
        this.zombieFeaturesEnabled = builder.comment("Enable this to use all Zombie features.").define("Zombie_FeaturesEnabled", true);
        this.zombieBabyBurn = builder.comment("Set this to false to prevent baby zombies from burning in sunlight.").define("Zombie_BabyBurns", true);
        this.zombieHelmetBurn = builder.comment("Set this to true to make all zombies burn in sunlight even if they wear a helmet.").define("Zombie_HelmetBurn", true);
        this.zombieHorseChance = builder.comment(new String[]{"Chance (1 in X) that a zombie spawns riding a zombie horse.", "Set to 0 to disable this feature."}).defineInRange("Zombie_HorseChance", 10, 0, Short.MAX_VALUE);
        this.zombieHorseMinY = builder.comment("Minimum Y position above which zombie horses may spawn.").defineInRange("Zombie_HorseMinY", 63, 0, Short.MAX_VALUE);
        this.zombieHungerChance = builder.comment(new String[]{"Chance (1 in X) for a zombie to apply the hunger effect on attack.", "Set to 0 to disable this feature."}).defineInRange("Zombie_HungerChance", 1, 0, Short.MAX_VALUE);
        this.zombieHungerDuration = builder.comment("Duration in seconds of the applied hunger effect.").defineInRange("Zombie_HungerDuration", 10, 0, Short.MAX_VALUE);
        this.zombieLeapChance = builder.comment(new String[]{"Chance (1 in X) for a zombie to leap to the target.", "Set to 0 to disable this feature."}).defineInRange("Zombie_LeapChance", 5, 0, Short.MAX_VALUE);
        this.zombieLeapHeight = builder.comment("Amount of blocks the zombie jumps on leap attack.").defineInRange("Zombie_LeapHeight", (double)0.2f, 0.0, 127.0);
        this.zombieChampionChance = builder.comment("Chance (1 in X) for a newly spawned zombie to become a Zombie Champion").defineInRange("Zombie_ChampionChance", 200, 0, Short.MAX_VALUE);
        this.zombieEntities = builder.comment("Entities which count as Zombies.").define("Zombie_Entities", Constants.getRegNames(Arrays.asList(Constants.ZOMBIES)));
        this.zombieBreakBlocks = builder.comment(new String[]{"Blocks which can be destroyed by zombies if they have no attack target.", "Delete all lines to disable this feature."}).defineList("Zombie_BreakBlocks", Arrays.asList(Constants.DEFAULT_DESTROY_BLOCKS), RoughConfig.ELEMENT_STRING_VALIDATOR);
        this.zombieChampionNames = builder.comment("A list of names to be used by Zombie Champions.").defineList("Zombie_ChampionNames", Arrays.asList(Constants.ZOMBIE_CHAMP_NAMES), RoughConfig.ELEMENT_STRING_VALIDATOR);
        builder.pop();
        builder.push("Zombie Pigman Features");
        this.zombiePigmanFeaturesEnabled = builder.comment("Enable this to use all Zombie Pigman features.").define("ZombiePigman_FeaturesEnabled", true);
        this.zombiePigmanAggressiveTouch = builder.comment("Set to false to prevent zombie pigman from getting aggressive if the player touches its hitbox.").define("ZombiePigman_AggressiveTouch", false);
        this.zombiePigmanAlwaysAggressive = builder.comment("Set to true for zombie pigmen to always be aggressive.").define("ZombiePigman_AlwaysAggressive", false);
        this.zombiePigmanAggressiveRange = builder.comment("The range at which zombie pigmen will be aggressive to the player..").defineInRange("ZombiePigman_AggressiveRange", 10, 0, Short.MAX_VALUE);
        this.zombiePigmanAggressiveBlockRange = builder.comment("Block radius in which zombie pigman get aggressive if the player breaks blocks.").defineInRange("ZombiePigman_AggressiveBlockRange", 20, 1, Short.MAX_VALUE);
        this.zombiePigmanAggressiveBlockChance = builder.comment("Chance (1 in X) that a zombie pigman gets aggressive if the player breaks nearby blocks.").defineInRange("ZombiePigman_AggressiveBlockChance", 10, 0, Short.MAX_VALUE);
        this.zombiePigmanEntities = builder.comment("Entities which count as Zombie Pigmen.").define("ZombiePigman_Entities", Constants.getRegNames(Arrays.asList(Constants.ZOMBIE_PIGMEN)));
        builder.pop();
    }
}

