/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.config;

import com.p1ut0nium.roughmobsrevamped.reference.Constants;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;

final class ModCompatConfig {
    final ForgeConfigSpec.BooleanValue useAllStages;
    final ForgeConfigSpec.BooleanValue useEquipmentStage;
    final ForgeConfigSpec.BooleanValue useBossStage;
    final ForgeConfigSpec.BooleanValue useAbilitiesStage;
    final ForgeConfigSpec.BooleanValue useEnchantStage;
    final ForgeConfigSpec.ConfigValue<List<String>> seasonWhiteList;
    private static final Predicate<Object> SEASON_VALIDATOR = obj -> {
        List<Object> seasons = Arrays.asList(obj);
        try {
            seasons.stream().allMatch(e -> e.getClass().equals(String.class));
        }
        catch (Exception e2) {
            return false;
        }
        return true;
    };

    ModCompatConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Config options for enabling/disabling Game Stages support.");
        builder.push("Game Stages");
        this.useAllStages = builder.comment("Require this Game Stage to allow all Rough Mobs stages be given at once.").define("GameStages_AllStages", false);
        this.useEquipmentStage = builder.comment("Require this Game Stage for Rough Mobs to have equipment.").define("GameStages_Equipment", false);
        this.useBossStage = builder.comment("Require this Game Stage for Rough Mob Bosses to spawn.").define("GameStages_Bosses", false);
        this.useAbilitiesStage = builder.comment("Require this Game Stage for Rough Mobs to have special combat AI and attributes.").define("GameStages_Abilities", false);
        this.useEnchantStage = builder.comment("Require this Game Stage for Rough Mob equipment to be enchanted.").define("GameStages_Enchantments", false);
        builder.pop();
        builder.comment("Config options for enabling/disabling Serene Seasons support.");
        builder.push("Serene Seasons");
        this.seasonWhiteList = builder.comment(new String[]{"Whitelist of all seasons that Rough Mobs can spawn in.", "Default Seasons: SUMMER, AUTUMN, WINTER, SPRING"}).define("Season_Whitelist", Arrays.asList(Constants.SEASONS), SEASON_VALIDATOR);
        builder.pop();
    }
}

