/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class SpawnConditionsConfig {
    final ForgeConfigSpec.IntValue minPlayerLevel;
    final ForgeConfigSpec.BooleanValue mustBeUnderground;
    final ForgeConfigSpec.IntValue maxSpawnHeight;
    final ForgeConfigSpec.IntValue minDistFromSpawn;

    SpawnConditionsConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Config options for determining if a Rough Mob can spawn.");
        builder.push("Spawn Conditions");
        this.minPlayerLevel = builder.comment("Player's Minecraft Experience Level required before a Rough Mob will spawn.").defineInRange("Player_XP_Level", 0, 0, Short.MAX_VALUE);
        this.maxSpawnHeight = builder.comment("Set maximum height for Rough Mobs to spawn. Works in conjunction with MustBeUnderground.").defineInRange("Max_Spawn_Height", 256, 0, 256);
        this.mustBeUnderground = builder.comment("Enable this to require Rough Mobs be underground in order to spawn.").define("Spawn_Underground", false);
        this.minDistFromSpawn = builder.comment("Set the minimum distance from the world spawn before a Rough Mob can spawn.").defineInRange("Min_Distance_From_Spawn", 0, 0, Short.MAX_VALUE);
        builder.pop();
    }
}

