/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.entity.ai.goal.RoughAIFlameTouchGoal;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.misc.FeatureHelper;
import com.p1ut0nium.roughmobsrevamped.reference.Constants;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class BlazeFeatures
extends EntityFeatures {
    private boolean pushAttackersAway;
    private boolean flameTouch;
    private Explosion.Mode deathExplosionType;
    private float pushStrength;
    private float deathExplosionStrength;

    public BlazeFeatures() {
        super("blaze", Constants.BLAZES);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.pushAttackersAway = RoughConfig.blazePushAttackersAway;
        this.pushStrength = RoughConfig.blazePushDamage;
        this.flameTouch = RoughConfig.blazeFlameTouch;
        this.deathExplosionStrength = RoughConfig.blazeDeathExplosionStrength;
        this.deathExplosionType = RoughConfig.blazeDeathExplosionType;
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, MobEntity entity, GoalSelector goalSelector, GoalSelector targetSelector) {
        if (entity instanceof MobEntity && this.flameTouch) {
            goalSelector.func_75776_a(1, (Goal)new RoughAIFlameTouchGoal(entity));
        }
    }

    @Override
    public void onDefend(LivingEntity target, Entity attacker, Entity immediateAttacker, LivingAttackEvent event) {
        if (this.pushAttackersAway && attacker instanceof LivingEntity && attacker == immediateAttacker) {
            FeatureHelper.knockback((Entity)target, (LivingEntity)attacker, 1.0f, 0.05f);
            attacker.func_70097_a(DamageSource.field_76377_j, this.pushStrength);
            attacker.func_70015_d(8);
            FeatureHelper.playSound((Entity)target, SoundEvents.field_187646_bt, 0.7f, 1.0f);
        }
    }

    @Override
    public void onDeath(LivingEntity deadEntity, DamageSource source) {
        if (this.deathExplosionStrength > 0.0f && !(source.func_76346_g() instanceof FakePlayer)) {
            deadEntity.field_70170_p.func_217385_a((Entity)deadEntity, deadEntity.field_70165_t, deadEntity.field_70163_u, deadEntity.field_70161_v, this.deathExplosionStrength, this.deathExplosionType);
        }
    }
}

