/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.compat.GameStagesCompat;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.world.BlockEvent;

public abstract class EntityFeatures {
    public static final Random RND = new Random();
    public static final int MAX = Short.MAX_VALUE;
    public String name;
    protected List<EntityType<? extends Entity>> entityTypes;
    protected boolean featuresEnabled;
    protected List<String> entityNames;

    public EntityFeatures(String name, EntityType<? extends Entity>[] entityTypes) {
        this.name = name;
        this.entityTypes = Arrays.asList(entityTypes);
    }

    public boolean isEntityType(MonsterEntity mobEntity) {
        EntityType entityType = mobEntity.func_200600_R();
        ResourceLocation loc = EntityType.func_200718_a((EntityType)entityType);
        return this.featuresEnabled && loc != null && this.entityNames.contains(loc.toString());
    }

    public void initConfig() {
        if (!this.hasDefaultConfig()) {
            return;
        }
        this.featuresEnabled = RoughConfig.featuresEnabled.get(this.name);
        this.entityNames = RoughConfig.entities.get(this.name);
    }

    private boolean hasDefaultConfig() {
        return true;
    }

    public void addFeatures(EntityJoinWorldEvent event, MobEntity entity) {
    }

    public boolean bossesEnabled(MobEntity entity) {
        if (GameStagesCompat.useBossStage().booleanValue()) {
            PlayerEntity playerClosest = entity.field_70170_p.func_217362_a((Entity)entity, -1.0);
            return GameStageHelper.hasAnyOf((PlayerEntity)playerClosest, (String[])new String[]{"roughmobsall", "roughmobsboss"});
        }
        return true;
    }

    public void preInit() {
    }

    public void postInit() {
    }

    public void addAI(EntityJoinWorldEvent event, MobEntity entity, GoalSelector goalSelector, GoalSelector targeSelector) {
    }

    public void onAttack(Entity attacker, Entity immediateAttacker, Entity target, LivingAttackEvent event) {
    }

    public void onDefend(LivingEntity target, Entity trueSource, Entity immediateSource, LivingAttackEvent event) {
    }

    public void onDeath(LivingEntity deadEntity, DamageSource source) {
    }

    public void onFall(LivingEntity entity, LivingFallEvent event) {
    }

    public void onBlockBreak(PlayerEntity player, BlockEvent.BreakEvent event) {
    }
}

