/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.misc.FeatureHelper;
import com.p1ut0nium.roughmobsrevamped.misc.MountHelper;
import com.p1ut0nium.roughmobsrevamped.reference.Constants;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class SpiderFeatures
extends EntityFeatures {
    private float ignoreFallDamageMult;
    private int slownessChance;
    private int slownessDuration;
    private boolean slownessCreateWeb;
    private MountHelper.Rider rider;

    public SpiderFeatures() {
        super("spider", Constants.SPIDERS);
    }

    @Override
    public void preInit() {
        this.rider = new MountHelper.Rider(this.name, RoughConfig.spiderRiderEntities, 10);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.ignoreFallDamageMult = RoughConfig.spiderIgnoreFallDamage;
        this.slownessDuration = RoughConfig.spiderSlownessDuration * 20;
        this.slownessChance = RoughConfig.spiderSlownessChance;
        this.slownessCreateWeb = RoughConfig.spiderSlownessCreateWeb;
        this.rider.initConfigs();
    }

    @Override
    public void postInit() {
        this.rider.postInit();
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, MobEntity entity, GoalSelector goalSelector, GoalSelector targetSelector) {
        if (entity instanceof MobEntity) {
            this.rider.addAI((LivingEntity)entity);
        }
    }

    @Override
    public void addFeatures(EntityJoinWorldEvent event, MobEntity spider) {
        if (spider instanceof LivingEntity) {
            this.rider.tryAddRider((LivingEntity)spider);
        }
    }

    @Override
    public void onFall(LivingEntity entity, LivingFallEvent event) {
        if (this.ignoreFallDamageMult == 1.0f) {
            return;
        }
        if (this.ignoreFallDamageMult == 0.0f) {
            event.setCanceled(true);
        }
        event.setDamageMultiplier(event.getDamageMultiplier() * this.ignoreFallDamageMult);
    }

    @Override
    public void onAttack(Entity attacker, Entity immediateAttacker, Entity target, LivingAttackEvent event) {
        if (target instanceof LivingEntity && this.slownessChance > 0) {
            LivingEntity living = (LivingEntity)target;
            int maxAmp = 4;
            FeatureHelper.addEffect(living, Effects.field_76421_d, this.slownessDuration, 0, this.slownessChance, true, maxAmp);
            EffectInstance active = living.func_70660_b(Effects.field_76421_d);
            if (this.slownessCreateWeb && active != null && active.func_76458_c() >= maxAmp && RND.nextInt(this.slownessChance) == 0 && target.func_130014_f_().func_180495_p(target.func_180425_c()).func_177230_c() == Blocks.field_150350_a) {
                target.func_130014_f_().func_175656_a(target.func_180425_c(), Blocks.field_196553_aF.func_176223_P());
            }
        }
    }
}

