/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.entity.ai.goal.RoughAIAggressiveTouchGoal;
import com.p1ut0nium.roughmobsrevamped.entity.ai.goal.RoughAIAlwaysAggressiveGoal;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.misc.FeatureHelper;
import com.p1ut0nium.roughmobsrevamped.reference.Constants;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ZombiePigmanFeatures
extends EntityFeatures {
    private boolean aggressiveTouch;
    private boolean alwaysAggressive;
    private int aggressiveRange;
    private float aggressiveBlockRange;
    private int aggressiveBlockChance;

    public ZombiePigmanFeatures() {
        super("zombie_pigman", Constants.ZOMBIE_PIGMEN);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.aggressiveTouch = RoughConfig.zombiePigmanAggressiveTouch;
        this.alwaysAggressive = RoughConfig.zombiePigmanAlwaysAggressive;
        this.aggressiveRange = RoughConfig.zombiePigmanAggressiveRange;
        this.aggressiveBlockRange = RoughConfig.zombiePigmanAggressiveBlockRange;
        this.aggressiveBlockChance = RoughConfig.zombiePigmanAggressiveBlockChance;
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, MobEntity entity, GoalSelector goalSelector, GoalSelector targetSelector) {
        if (!(entity instanceof MobEntity)) {
            return;
        }
        if (this.aggressiveTouch) {
            goalSelector.func_75776_a(1, (Goal)new RoughAIAggressiveTouchGoal(entity));
        }
        if (this.alwaysAggressive) {
            goalSelector.func_75776_a(3, (Goal)new RoughAIAlwaysAggressiveGoal(entity, this.aggressiveRange));
        }
    }

    @Override
    public void onBlockBreak(PlayerEntity player, BlockEvent.BreakEvent event) {
        for (EntityType clazz : this.entityTypes) {
            List entities = player.field_70170_p.func_217394_a(clazz, player.func_174813_aQ().func_72321_a((double)this.aggressiveBlockRange, (double)this.aggressiveBlockRange, (double)this.aggressiveBlockRange), null);
            for (Entity entity : entities) {
                if (this.aggressiveBlockChance <= 0 || !(entity instanceof MobEntity) || player.field_70170_p.field_73012_v.nextInt(this.aggressiveBlockChance) != 0) continue;
                MobEntity mob = (MobEntity)entity;
                mob.func_70624_b((LivingEntity)player);
                mob.func_70604_c((LivingEntity)player);
                FeatureHelper.playSound((Entity)mob, SoundEvents.field_187936_hj);
            }
        }
    }
}

