/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.misc;

import com.p1ut0nium.roughmobsrevamped.entity.boss.HuskChampionEntity;
import com.p1ut0nium.roughmobsrevamped.entity.boss.IChampion;
import com.p1ut0nium.roughmobsrevamped.entity.boss.SkeletonChampionEntity;
import com.p1ut0nium.roughmobsrevamped.entity.boss.ZombieChampionEntity;
import com.p1ut0nium.roughmobsrevamped.entity.boss.ZombiePigmanChampionEntity;
import com.p1ut0nium.roughmobsrevamped.misc.EquipHelper;
import com.p1ut0nium.roughmobsrevamped.reference.Constants;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class BossHelper {
    public static final Random RND = new Random();
    public static final String BOSS = Constants.unique("isBoss");
    private static boolean bossWarning;
    private static boolean bossWarningSound;
    private static int bossWarningDist;
    public static boolean bossFogEnabled;
    public static String[] bossFogColor;
    public static int bossFogMaxDistance;
    public static int bossFogFarPlane;
    public static float bossFogFarPlaneScale;
    public static int bossFogStartDistance;
    public static boolean bossFogPlayerCough;
    public static boolean bossFogDoTEnabled;
    public static int bossFogDoTDelay;
    public static boolean bossFogDoTWarning;
    public static int bossFogDoTWarningTime;
    public static int bossFogDoTDamage;
    public static boolean bossBatSwarmEnabled;
    public static int bossBatSwarmCount;
    public static int bossBatSwarmDelay;
    public static int bossBatSwarmRange;
    public static int bossBatSwarmDamage;
    public static int bossBatSwarmHealth;
    public static int bossBatSwarmAttackRange;

    public static void initGlobalBossConfig() {
        if (!BossHelper.hasDefaultConfig()) {
            return;
        }
    }

    public static boolean hasDefaultConfig() {
        return true;
    }

    public static boolean isBoss(MobEntity entity) {
        return entity.getPersistentData() != null && entity.getPersistentData().func_74767_n(BOSS);
    }

    public static abstract class BossApplier {
        private EquipHelper.EquipmentApplier equipApplier;
        private final String name;
        private final int defaultChampionChance;
        private final float defaultEnchMultiplier;
        private final float defaultDropChance;
        private final String[] defaultChampionNames;

        public BossApplier(String name, int defaultChampionChance, float defaultEnchMultiplier, float defaultDropChance, String[] championNames) {
            this.name = name;
            this.defaultChampionChance = defaultChampionChance;
            this.defaultEnchMultiplier = defaultEnchMultiplier;
            this.defaultDropChance = defaultDropChance;
            this.defaultChampionNames = championNames;
            this.equipApplier = new EquipHelper.EquipmentApplier(name + " boss", 1, 1, 1, this.defaultEnchMultiplier, this.defaultDropChance);
        }

        public void initConfig() {
            boolean isBoss = true;
            boolean useDefaultValues = true;
            this.equipApplier.initConfig(isBoss, useDefaultValues);
        }

        public void postInit() {
            this.equipApplier.createPools();
        }

        public MobEntity trySetBoss(MobEntity entity) {
            String entityTypeName;
            if (this.defaultChampionChance <= 0 || RND.nextInt(this.defaultChampionChance) != 0 || entity instanceof ZombieEntity && ((ZombieEntity)entity).func_70631_g_()) {
                return null;
            }
            IChampion boss = null;
            switch (entityTypeName = entity.func_145748_c_().func_150261_e()) {
                case "Zombie": {
                    boss = new ZombieChampionEntity(entity.field_70170_p);
                    ((MobEntity)boss).func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    entity.field_70170_p.func_217376_c((Entity)boss);
                    break;
                }
                case "Zombie Pigman": {
                    boss = new ZombiePigmanChampionEntity(entity.field_70170_p);
                    ((MobEntity)boss).func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    entity.field_70170_p.func_217376_c((Entity)((ZombiePigmanChampionEntity)boss));
                    break;
                }
                case "Husk": {
                    boss = new HuskChampionEntity(entity.field_70170_p);
                    ((MobEntity)boss).func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    entity.field_70170_p.func_217376_c((Entity)((HuskChampionEntity)boss));
                    break;
                }
                case "Skeleton": {
                    boss = new SkeletonChampionEntity(entity.field_70170_p);
                    ((MobEntity)boss).func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    entity.field_70170_p.func_217376_c((Entity)((SkeletonChampionEntity)boss));
                }
            }
            entity.func_70106_y();
            if (boss != null) {
                boolean isBoss = true;
                this.equipApplier.equipEntity((MobEntity)boss, isBoss);
                StringTextComponent bossName = new StringTextComponent(this.defaultChampionNames[RND.nextInt(this.defaultChampionNames.length)]);
                ((MobEntity)boss).func_200203_b((ITextComponent)bossName);
                ((MobEntity)boss).getPersistentData().func_74757_a(BOSS, true);
                this.addBossFeatures((MobEntity)boss);
                return (MobEntity)boss;
            }
            return null;
        }

        public abstract void addBossFeatures(MobEntity var1);
    }
}

