/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.misc;

import com.p1ut0nium.roughmobsrevamped.core.RoughMobsRevamped;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;

public class TargetHelper {
    public static final String CATEGORY = "targetBlocker";
    private static boolean enableTargetBlock;
    private static final List<TargetEntry> BlockerList;
    public static boolean enableTargetAlways;
    public static boolean ignoreSpawnConditions;
    private static final List<TargetEntry> AttackerList;

    public static void init() {
    }

    private static void fillList(String[] options, String listType) {
        for (String option : options) {
            String[] split = option.split(";");
            if (split.length >= 2) {
                Class[] entities = new Class[2];
                boolean success = true;
                for (int i = 0; i < 2; ++i) {
                    if (!split[i].trim().equals("*")) continue;
                    entities[i] = Entity.class;
                }
                if (!success) continue;
                if (listType == "targetblocker") {
                    BlockerList.add(new TargetEntry(entities[1], entities[0]));
                    continue;
                }
                if (listType != "targetattacker") continue;
                AttackerList.add(new TargetEntry(entities[1], entities[0]));
                continue;
            }
            RoughMobsRevamped.LOGGER.error(listType + ": each option needs at least 2 arguments! (" + option + ")");
        }
    }

    public static Class<? extends Entity> getBlockerEntityForTarget(Entity target) {
        for (TargetEntry entry : BlockerList) {
            if (!target.getClass().equals(entry.getTargetClass())) continue;
            return entry.getAttackerClass();
        }
        return null;
    }

    public static boolean targetBlockerEnabled() {
        return enableTargetBlock;
    }

    public static boolean targetAttackerEnabled() {
        return enableTargetAlways;
    }

    static {
        BlockerList = new ArrayList<TargetEntry>();
        AttackerList = new ArrayList<TargetEntry>();
    }

    static class TargetEntry {
        private final Class<? extends Entity> attackerClass;
        private final Class<? extends Entity> targetClass;

        public TargetEntry(Class<? extends Entity> attackerClass, Class<? extends Entity> targetClass) {
            this.attackerClass = attackerClass;
            this.targetClass = targetClass;
        }

        public Class<? extends Entity> getAttackerClass() {
            return this.attackerClass;
        }

        public Class<? extends Entity> getTargetClass() {
            return this.targetClass;
        }
    }
}

