/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.compat;

import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import java.util.HashMap;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;

public abstract class GameStagesCompat {
    private static boolean registered;
    private static Boolean useEquipmentStage;
    private static Boolean useAllStages;
    private static Boolean useBossStage;
    private static Boolean useEnchantStage;
    private static Boolean useAbilitiesStage;
    private static HashMap<String, Boolean> playerStages;
    public static HashMap<PlayerEntity, HashMap<String, Boolean>> players;

    private GameStagesCompat() {
    }

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        GameStagesCompat.preInit();
    }

    public static void preInit() {
        useAllStages = RoughConfig.useAllStages;
        if (useAllStages.booleanValue()) {
            useAbilitiesStage = useEnchantStage = Boolean.valueOf(true);
            useBossStage = useEnchantStage;
            useEquipmentStage = useEnchantStage;
        } else {
            useEquipmentStage = RoughConfig.useEquipmentStage;
            useBossStage = RoughConfig.useBossStage;
            useAbilitiesStage = RoughConfig.useAbilitiesStage;
            useEnchantStage = RoughConfig.useEnchantStage;
        }
    }

    public static void syncPlayerGameStages(ServerPlayerEntity player) {
        if (registered) {
            GameStageHelper.syncPlayer((ServerPlayerEntity)player);
            playerStages.put("playerHasEquipmentStage", GameStageHelper.hasAnyOf((ServerPlayerEntity)player, (String[])new String[]{"roughmobsall", "roughmobsequip"}));
            playerStages.put("playerHasAbilitiesStage", GameStageHelper.hasAnyOf((ServerPlayerEntity)player, (String[])new String[]{"roughmobsall", "roughmobsabils"}));
            playerStages.put("playerHasBossStage", GameStageHelper.hasAnyOf((ServerPlayerEntity)player, (String[])new String[]{"roughmobsall", "roughmobsboss"}));
            playerStages.put("playerHasEnchantStage", GameStageHelper.hasAnyOf((ServerPlayerEntity)player, (String[])new String[]{"roughmobsall", "roughmobsenchant"}));
            players.put((PlayerEntity)player, playerStages);
        }
    }

    public static Boolean useEquipmentStage() {
        if (registered) {
            return useEquipmentStage;
        }
        return false;
    }

    public static Boolean useAllStages() {
        if (registered) {
            return useAllStages;
        }
        return false;
    }

    public static Boolean useBossStage() {
        if (registered) {
            return useBossStage;
        }
        return false;
    }

    public static Boolean useEnchantStage() {
        if (registered) {
            return useEnchantStage;
        }
        return false;
    }

    public static Boolean useAbilitiesStage() {
        if (registered) {
            return useAbilitiesStage;
        }
        return false;
    }

    static {
        playerStages = new HashMap();
        players = new HashMap();
    }
}

