/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.config;

import com.p1ut0nium.roughmobsrevamped.config.ConfigHolder;
import com.p1ut0nium.roughmobsrevamped.core.RoughMobsRevamped;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.Explosion;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber
public class RoughConfig {
    public static HashMap<String, Boolean> featuresEnabled = new HashMap();
    public static HashMap<String, List<String>> entities = new HashMap();
    public static boolean useAllStages;
    public static boolean useEquipmentStage;
    public static boolean useBossStage;
    public static boolean useAbilitiesStage;
    public static boolean useEnchantStage;
    public static List<String> seasonWhiteList;
    public static boolean mustBeUnderground;
    public static int minPlayerLevel;
    public static int maxSpawnHeight;
    public static int minDistFromSpawn;
    public static int chancePerWeapon;
    public static int chancePerArmor;
    public static int chancePerEnchantment;
    public static float enchantMultiplier;
    public static float dropChance;
    public static List<? extends String> equipMainhand;
    public static List<? extends String> equipOffhand;
    public static List<? extends String> equipHelmet;
    public static List<? extends String> equipChestplate;
    public static List<? extends String> equipLeggings;
    public static List<? extends String> equipBoots;
    public static List<? extends String> equipWeaponEnchants;
    public static List<? extends String> equipArmorEnchants;
    public static boolean chanceTimeMultiplier;
    public static boolean chanceDistMultiplier;
    public static int distThreshold;
    public static boolean disableBabyZombieEquipment;
    public static boolean blazeFeaturesEnabled;
    public static boolean blazePushAttackersAway;
    public static boolean blazeFlameTouch;
    public static float blazePushDamage;
    public static float blazeDeathExplosionStrength;
    public static Explosion.Mode blazeDeathExplosionType;
    public static List<String> blazeEntities;
    public static boolean spiderFeaturesEnabled;
    public static boolean spiderSlownessCreateWeb;
    public static int spiderRiderChance;
    public static int spiderRiderChanceRandom;
    public static int spiderSlownessChance;
    public static int spiderSlownessDuration;
    public static float spiderIgnoreFallDamage;
    public static List<String> spiderEntities;
    public static List<String> spiderRiderEntities;
    public static boolean zombieFeaturesEnabled;
    public static boolean zombieBabyBurn;
    public static boolean zombieHelmetBurn;
    public static int zombieHorseChance;
    public static int zombieHorseMinY;
    public static int zombieHungerChance;
    public static int zombieHungerDuration;
    public static int zombieLeapChance;
    public static int zombieChampionChance;
    public static float zombieLeapHeight;
    public static List<String> zombieEntities;
    public static List<? extends String> zombieBreakBlocks;
    public static List<? extends String> zombieChampionNames;
    public static boolean zombiePigmanFeaturesEnabled;
    public static boolean zombiePigmanAggressiveTouch;
    public static boolean zombiePigmanAlwaysAggressive;
    public static int zombiePigmanAggressiveRange;
    public static int zombiePigmanAggressiveBlockRange;
    public static int zombiePigmanAggressiveBlockChance;
    public static List<String> zombiePigmanEntities;
    public static boolean hostileHorseFeaturesEnabled;
    public static boolean hostileHorseBurn;
    public static boolean hostileHorseCanDespawn;
    public static int hostileHorseRiderChance;
    public static List<String> hostileHorseEntities;
    public static List<? extends String> attributes;
    public static boolean bossFogEnabled;
    public static List<Float> bossFogColor;
    public static int bossFogMaxDist;
    public static int bossFogStartDist;
    public static int bossFogFarPlane;
    public static float bossFogFarPlaneScale;
    public static boolean bossFogDoTEnabled;
    public static boolean bossFogDoTWarning;
    public static boolean bossFogPlayerCough;
    public static int bossFogDoTDelay;
    public static int bossFogDoTWarningTime;
    public static int bossFogDoTDamage;
    public static final Predicate<Object> ENTITY_CLASS_VALIDATOR;
    public static final Predicate<Object> ELEMENT_STRING_VALIDATOR;

    public static void init() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path roughConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "roughmobsrevamped");
        try {
            Files.createDirectory(roughConfigPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            RoughMobsRevamped.LOGGER.error("Failed to create config directory.", (Throwable)e);
        }
    }

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, ConfigHolder.MODCOMPAT_SPEC, "roughmobsrevamped/modcompat.toml");
        context.registerConfig(ModConfig.Type.COMMON, ConfigHolder.SPAWNCONDITIONS_SPEC, "roughmobsrevamped/spawnconditions.toml");
        context.registerConfig(ModConfig.Type.COMMON, ConfigHolder.EQUIPMENT_SPEC, "roughmobsrevamped/equipment.toml");
        context.registerConfig(ModConfig.Type.COMMON, ConfigHolder.FEATURES_SPEC, "roughmobsrevamped/features.toml");
        context.registerConfig(ModConfig.Type.COMMON, ConfigHolder.ATTRIBUTES_SPEC, "roughmobsrevamped/attributes.toml");
        context.registerConfig(ModConfig.Type.COMMON, ConfigHolder.FOG_SPEC, "roughmobsrevamped/fog.toml");
    }

    static {
        ENTITY_CLASS_VALIDATOR = obj -> {
            List<Object> entityClasses = Arrays.asList(obj);
            try {
                entityClasses.stream().filter(e -> e.getClass().equals(String.class)).allMatch(e -> e.toString().endsWith(".class"));
            }
            catch (Exception e2) {
                return false;
            }
            return true;
        };
        ELEMENT_STRING_VALIDATOR = obj -> {
            List<Object> elements = Arrays.asList(obj);
            try {
                elements.stream().allMatch(e -> e.getClass().equals(String.class));
            }
            catch (Exception e2) {
                return false;
            }
            return true;
        };
    }
}

