/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.core;

import com.p1ut0nium.roughmobsrevamped.compat.GameStagesCompat;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.entity.boss.IChampion;
import com.p1ut0nium.roughmobsrevamped.features.BlazeFeatures;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.features.HostileHorseFeatures;
import com.p1ut0nium.roughmobsrevamped.features.SpiderFeatures;
import com.p1ut0nium.roughmobsrevamped.features.ZombieFeatures;
import com.p1ut0nium.roughmobsrevamped.features.ZombiePigmanFeatures;
import com.p1ut0nium.roughmobsrevamped.misc.AttributeHelper;
import com.p1ut0nium.roughmobsrevamped.misc.SpawnHelper;
import com.p1ut0nium.roughmobsrevamped.reference.Constants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RoughApplier {
    public static final String FEATURES_APPLIED = Constants.unique("featuresApplied");
    public static final List<EntityFeatures> FEATURES = new ArrayList<EntityFeatures>();

    public RoughApplier() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FEATURES.add(new BlazeFeatures());
        FEATURES.add(new ZombieFeatures());
        FEATURES.add(new ZombiePigmanFeatures());
        FEATURES.add(new HostileHorseFeatures());
        FEATURES.add(new SpiderFeatures());
    }

    public void init() {
        for (EntityFeatures features : FEATURES) {
            features.preInit();
        }
        for (EntityFeatures features : FEATURES) {
            features.initConfig();
        }
        for (EntityFeatures features : FEATURES) {
            features.postInit();
        }
        AttributeHelper.initAttributeOption();
    }

    private static void addAttributes(MonsterEntity entity) {
        if (entity instanceof MonsterEntity) {
            AttributeHelper.addAttributes((LivingEntity)entity);
        }
    }

    private static void addFeatures(EntityJoinWorldEvent event, MonsterEntity entity) {
        if (entity.getClass().equals(PlayerEntity.class)) {
            return;
        }
        if (!(entity instanceof MonsterEntity)) {
            return;
        }
        for (EntityFeatures features : FEATURES) {
            if (!features.isEntityType(entity) || entity instanceof IChampion || entity.func_70631_g_() && (!entity.func_70631_g_() || RoughConfig.disableBabyZombieEquipment) || entity.getPersistentData().func_74767_n(FEATURES_APPLIED)) continue;
            features.addFeatures(event, (MobEntity)entity);
        }
    }

    private static void addAI(EntityJoinWorldEvent event, MonsterEntity entity) {
        for (EntityFeatures features : FEATURES) {
            if (!features.isEntityType(entity) || !(entity instanceof MonsterEntity)) continue;
            features.addAI(event, (MobEntity)entity, entity.field_70714_bg, entity.field_70715_bh);
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K || event.getEntity() instanceof PlayerEntity || !(event.getEntity() instanceof MonsterEntity)) {
            return;
        }
        MonsterEntity entity = (MonsterEntity)event.getEntity();
        boolean isBoss = entity instanceof IChampion;
        boolean canSpawn = SpawnHelper.checkSpawnConditions(event);
        if (!isBoss && !canSpawn) {
            return;
        }
        PlayerEntity closestPlayer = entity.field_70170_p.func_217362_a((Entity)entity, -1.0);
        GameStagesCompat.syncPlayerGameStages((ServerPlayerEntity)closestPlayer);
        if (!GameStagesCompat.useAbilitiesStage().booleanValue() || GameStagesCompat.useAbilitiesStage().booleanValue() && GameStagesCompat.players.get(closestPlayer).get("playerHasAbilitiesStage").booleanValue()) {
            RoughApplier.addAttributes(entity);
            RoughApplier.addAI(event, entity);
        }
        if (!GameStagesCompat.useEquipmentStage().booleanValue() || GameStagesCompat.useEquipmentStage().booleanValue() && GameStagesCompat.players.get(closestPlayer).get("playerHasEquipmentStage").booleanValue()) {
            RoughApplier.addFeatures(event, entity);
        }
        entity.getPersistentData().func_74757_a(FEATURES_APPLIED, true);
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        Entity trueSource = event.getSource().func_76346_g();
        Entity immediateSource = event.getSource().func_76364_f();
        Entity target = event.getEntity();
        if (trueSource == null || target == null || target instanceof FakePlayer || trueSource instanceof FakePlayer || immediateSource instanceof FakePlayer || target.field_70170_p.field_72995_K) {
            return;
        }
        for (EntityFeatures features : FEATURES) {
            if (trueSource instanceof MonsterEntity && features.isEntityType((MonsterEntity)trueSource) && (!(target instanceof PlayerEntity) || !((PlayerEntity)target).func_184812_l_())) {
                features.onAttack((Entity)((MonsterEntity)trueSource), immediateSource, target, event);
            }
            if (!(target instanceof MonsterEntity) || !features.isEntityType((MonsterEntity)target) || trueSource instanceof PlayerEntity && ((PlayerEntity)trueSource).func_184812_l_()) continue;
            features.onDefend((LivingEntity)((MonsterEntity)target), trueSource, immediateSource, event);
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        Entity deadEntity = event.getEntity();
        if (deadEntity == null || deadEntity.field_70170_p.field_72995_K || !(deadEntity instanceof MonsterEntity)) {
            return;
        }
        for (EntityFeatures features : FEATURES) {
            if (!features.isEntityType((MonsterEntity)deadEntity)) continue;
            features.onDeath((LivingEntity)((MonsterEntity)deadEntity), event.getSource());
            return;
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        Entity entity = event.getEntity();
        if (entity == null || entity.field_70170_p.field_72995_K || !(entity instanceof MonsterEntity)) {
            return;
        }
        for (EntityFeatures features : FEATURES) {
            if (!features.isEntityType((MonsterEntity)entity)) continue;
            features.onFall((LivingEntity)((MonsterEntity)entity), event);
            return;
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player == null || player.field_70170_p.field_72995_K || player.func_184812_l_()) {
            return;
        }
        for (EntityFeatures features : FEATURES) {
            features.onBlockBreak(player, event);
        }
    }
}

