/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.entity.ai.goal;

import com.p1ut0nium.roughmobsrevamped.reference.Constants;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RoughAIBreakBlocksGoal
extends Goal {
    public static final String BANS = Constants.unique("breakbans");
    public static final String LONG_POS = Constants.unique("breakpos");
    protected CreatureEntity breaker;
    protected int range;
    protected World world;
    protected List<Block> allowedBlocks;
    protected BlockPos target;
    protected int breakingTime;
    protected int previousBreakProgress = -1;
    protected Block block;
    protected int neededTime;
    protected int idleTime;
    protected int curDistance;

    public RoughAIBreakBlocksGoal(LivingEntity breaker, int range, List<Block> allowedBlocks) {
        this.breaker = (CreatureEntity)breaker;
        this.range = range;
        this.world = breaker.field_70170_p;
        this.allowedBlocks = allowedBlocks;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean func_75250_a() {
        if (!this.world.func_82736_K().func_223586_b(GameRules.field_223599_b) || this.breaker.func_70638_az() != null) {
            return false;
        }
        BlockPos target = this.getFirstTarget();
        if (target != null) {
            this.target = target;
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.breakingTime = 0;
        this.idleTime = 0;
        this.block = this.world.func_180495_p(this.target).func_177230_c();
        this.neededTime = this.getBreakSpeed();
    }

    private int getBreakSpeed() {
        float multiplier = 100.0f;
        ItemStack held = this.breaker.func_184614_ca();
        BlockState state = this.world.func_180495_p(this.target);
        if (held != null && held.func_77973_b() instanceof ToolItem) {
            multiplier -= ((ToolItem)held.func_77973_b()).func_150893_a(held, state) * 10.0f;
        }
        return (int)(state.func_185887_b((IBlockReader)this.world, this.target) * Math.max(0.0f, multiplier) + 10.0f);
    }

    public void func_75246_d() {
        this.breaker.func_70661_as().func_75484_a(this.breaker.func_70661_as().func_179680_a(this.target, 0), 1.0);
        CreatureEntity breakerEntity = this.breaker;
        while (breakerEntity.func_184218_aH()) {
            breakerEntity = breakerEntity.func_184187_bx();
        }
        ++this.idleTime;
        double distance = this.target.func_218140_a(breakerEntity.func_226277_ct_(), breakerEntity.func_226278_cu_(), breakerEntity.func_226281_cx_(), false);
        this.idleTime = (int)Math.round(distance) == this.curDistance ? ++this.idleTime : 0;
        if (this.idleTime >= 160) {
            this.banishTarget();
        }
        this.curDistance = (int)Math.round(distance);
        if (distance <= 2.0 && this.target != null) {
            ++this.breakingTime;
            int i = (int)((float)this.breakingTime / (float)this.neededTime * 10.0f);
            if (i != this.previousBreakProgress) {
                this.world.func_175715_c(this.breaker.func_145782_y(), this.target, i);
                this.previousBreakProgress = i;
            }
            if (this.breakingTime >= this.neededTime) {
                this.world.func_175655_b(this.target, true);
                this.breakingTime = 0;
            }
        }
    }

    public boolean func_75253_b() {
        return this.target != null && (!(this.breaker instanceof CreatureEntity) || this.breaker.func_213389_a(this.target)) && this.world.func_180495_p(this.target).func_177230_c() == this.block && this.breaker.func_70638_az() == null;
    }

    public void func_75251_c() {
        this.breaker.func_70661_as().func_75499_g();
    }

    private BlockPos getFirstTarget() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockPos target = null;
        double bestDistance = Double.MAX_VALUE;
        CreatureEntity breakerEntity = this.breaker;
        while (breakerEntity.func_184218_aH()) {
            breakerEntity = breakerEntity.func_184187_bx();
        }
        for (int i = -this.range; i <= this.range; ++i) {
            for (int j = -this.range; j <= this.range; ++j) {
                for (int k = -this.range; k <= this.range; ++k) {
                    BlockPos curPos = new BlockPos(breakerEntity.func_226277_ct_() + (double)i, breakerEntity.func_226278_cu_() + (double)j, breakerEntity.func_226281_cx_() + (double)k);
                    Block block = this.world.func_180495_p(curPos).func_177230_c();
                    if (block instanceof SpawnerBlock) {
                        return null;
                    }
                    if (!this.allowedBlocks.contains(block) || this.isBanned(curPos)) continue;
                    positions.add(curPos);
                }
            }
        }
        for (BlockPos pos : positions) {
            double distance = pos.func_218140_a(breakerEntity.func_226277_ct_(), breakerEntity.func_226278_cu_(), breakerEntity.func_226281_cx_(), false);
            if (!(distance < bestDistance)) continue;
            target = pos;
            bestDistance = distance;
        }
        return target;
    }

    private void banishTarget() {
        if (this.breaker.getPersistentData().func_74781_a(BANS) == null) {
            this.breaker.getPersistentData().func_218657_a(BANS, (INBT)new ListNBT());
        }
        CompoundNBT comp = new CompoundNBT();
        comp.func_74772_a(LONG_POS, this.target.func_218275_a());
        this.breaker.getPersistentData().func_218657_a(BANS, (INBT)comp);
        this.target = null;
        this.func_75251_c();
    }

    private boolean isBanned(BlockPos pos) {
        long l = pos.func_218275_a();
        CompoundNBT list = (CompoundNBT)this.breaker.getPersistentData().func_74781_a(BANS);
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.func_186856_d(); ++i) {
            if (list.func_74763_f(LONG_POS) != l) continue;
            return true;
        }
        return false;
    }
}

