/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.entity.ai.goal.RoughAIDespawnGoal;
import com.p1ut0nium.roughmobsrevamped.entity.ai.goal.RoughAISearchForRiderGoal;
import com.p1ut0nium.roughmobsrevamped.entity.ai.goal.RoughAISunlightBurnGoal;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.reference.Constants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class HostileHorseFeatures
extends EntityFeatures {
    public static final String ROUGH_HORSE = Constants.unique("roughhorse");
    private boolean horseBurn;
    private int randomRiderChance;
    private boolean canDespawn;

    public HostileHorseFeatures() {
        super("hostileHorse", Constants.HOSTILE_HORSES);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.horseBurn = RoughConfig.hostileHorseBurn;
        this.randomRiderChance = RoughConfig.hostileHorseRiderChance;
        this.canDespawn = RoughConfig.hostileHorseCanDespawn;
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, MobEntity entity, GoalSelector goalSelector, GoalSelector targetSelector) {
        if (this.horseBurn && !entity.func_70045_F() && entity instanceof LivingEntity) {
            goalSelector.func_75776_a(0, (Goal)new RoughAISunlightBurnGoal((LivingEntity)entity, false){

                @Override
                public boolean func_75250_a() {
                    return super.func_75250_a() && !this.entity.func_184207_aI();
                }
            });
        }
        if (entity instanceof LivingEntity && this.randomRiderChance > 0) {
            goalSelector.func_75776_a(1, (Goal)new RoughAISearchForRiderGoal((LivingEntity)entity, this.getRiders((Entity)entity), 32, this.randomRiderChance));
        }
        if (entity instanceof LivingEntity && this.shouldDespawn(entity)) {
            goalSelector.func_75776_a(1, (Goal)new RoughAIDespawnGoal((LivingEntity)entity));
        }
    }

    @Override
    public void addFeatures(EntityJoinWorldEvent event, MobEntity entity) {
        if (entity instanceof MobEntity && this.shouldDespawn(entity)) {
            ObfuscationReflectionHelper.setPrivateValue(MobEntity.class, (Object)entity, (Object)false, (String)"field_82179_bU");
        }
    }

    private boolean shouldDespawn(MobEntity entity) {
        return this.canDespawn && entity.getPersistentData().func_74767_n(ROUGH_HORSE);
    }

    private List<EntityType<?>> getRiders(Entity entity) {
        ArrayList riders = new ArrayList();
        if (entity instanceof SkeletonHorseEntity) {
            riders.add(EntityType.field_200741_ag);
        } else {
            riders.add(EntityType.field_200725_aD);
        }
        return riders;
    }
}

