/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.entity.ai.goal.RoughAIBreakBlocksGoal;
import com.p1ut0nium.roughmobsrevamped.entity.ai.goal.RoughAILeapAtTargetChancedGoal;
import com.p1ut0nium.roughmobsrevamped.entity.ai.goal.RoughAISunlightBurnGoal;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.misc.BossHelper;
import com.p1ut0nium.roughmobsrevamped.misc.EquipHelper;
import com.p1ut0nium.roughmobsrevamped.misc.FeatureHelper;
import com.p1ut0nium.roughmobsrevamped.misc.MountHelper;
import com.p1ut0nium.roughmobsrevamped.misc.SpawnHelper;
import com.p1ut0nium.roughmobsrevamped.reference.Constants;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class ZombieFeatures
extends EntityFeatures {
    private static final String BOSS_MINION = Constants.unique("bossMinion");
    private float leapHeight;
    private int leapChance;
    private int hungerDuration;
    private int hungerChance;
    private int horseChance;
    private int horseMinY;
    private boolean babyBurn;
    private boolean helmetBurn;
    private EquipHelper.EquipmentApplier equipApplier;
    private BossHelper.BossApplier bossApplier;
    private List<? extends String> breakBlocks;
    private List<Block> allowedBreakBlocks;

    public ZombieFeatures() {
        super("zombie", Constants.ZOMBIES);
    }

    @Override
    public void preInit() {
        this.equipApplier = new EquipHelper.EquipmentApplier(this.name, 3, 4, 8, 0.5f, 0.085f);
        this.bossApplier = new BossHelper.BossApplier(this.name, RoughConfig.zombieChampionChance, 1.0f, 0.2f, RoughConfig.zombieChampionNames.toArray(new String[0])){

            @Override
            public void addBossFeatures(MobEntity entity) {
                if (!SpawnHelper.disableBabyZombies()) {
                    for (int i = 0; i < 4; ++i) {
                        ZombieEntity zombieMinion = new ZombieEntity(entity.func_130014_f_());
                        CompoundNBT nbtMinion = zombieMinion.getPersistentData();
                        nbtMinion.func_74757_a(BOSS_MINION, true);
                        zombieMinion.func_70107_b(entity.func_226277_ct_() + Math.random() - Math.random(), entity.func_226278_cu_() + Math.random(), entity.func_226281_cx_() + Math.random() - Math.random());
                        zombieMinion.func_213386_a((IWorld)zombieMinion.field_70170_p, entity.func_130014_f_().func_175649_E(entity.func_180425_c()), SpawnReason.MOB_SUMMONED, null, nbtMinion);
                        zombieMinion.func_82227_f(true);
                        entity.field_70170_p.func_217376_c((Entity)zombieMinion);
                    }
                }
            }
        };
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.leapChance = RoughConfig.zombieLeapChance;
        this.leapHeight = RoughConfig.zombieLeapHeight;
        this.hungerDuration = RoughConfig.zombieHungerDuration * 20;
        this.hungerChance = RoughConfig.zombieHungerChance;
        this.horseChance = RoughConfig.zombieHorseChance;
        this.horseMinY = RoughConfig.zombieHorseMinY;
        this.babyBurn = RoughConfig.zombieBabyBurn;
        this.helmetBurn = RoughConfig.zombieHelmetBurn;
        this.breakBlocks = RoughConfig.zombieBreakBlocks;
        boolean isBoss = false;
        boolean useDefaultValues = false;
        this.equipApplier.initConfig(isBoss, useDefaultValues);
        this.bossApplier.initConfig();
    }

    @Override
    public void postInit() {
        this.equipApplier.createPools();
        this.bossApplier.postInit();
        this.allowedBreakBlocks = FeatureHelper.getBlocksFromNames(this.breakBlocks);
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, MobEntity entity, GoalSelector goalSelector, GoalSelector targetSelector) {
        if (!(entity instanceof MobEntity)) {
            return;
        }
        if (this.leapChance > 0) {
            goalSelector.func_75776_a(1, (Goal)new RoughAILeapAtTargetChancedGoal(entity, this.leapHeight, this.leapChance));
        }
        if (this.babyBurn && entity instanceof ZombieEntity && ((ZombieEntity)entity).func_70631_g_() && !entity.func_70045_F()) {
            goalSelector.func_75776_a(0, (Goal)new RoughAISunlightBurnGoal((LivingEntity)entity, false));
        }
        if (this.helmetBurn) {
            goalSelector.func_75776_a(0, (Goal)new RoughAISunlightBurnGoal((LivingEntity)entity, true));
        }
        if (this.allowedBreakBlocks.size() > 0) {
            goalSelector.func_75776_a(1, (Goal)new RoughAIBreakBlocksGoal((LivingEntity)entity, 8, this.allowedBreakBlocks));
        }
    }

    @Override
    public void addFeatures(EntityJoinWorldEvent event, MobEntity entity) {
        if (!(entity instanceof MobEntity) || entity.getPersistentData().func_74767_n(BOSS_MINION)) {
            return;
        }
        if (super.bossesEnabled(entity)) {
            MobEntity boss = this.bossApplier.trySetBoss(entity);
            if (boss != null) {
                entity = boss;
                event.setCanceled(true);
            } else {
                this.equipApplier.equipEntity(entity);
            }
        }
        MountHelper.tryMountHorse(entity, MountHelper.HorseType.ZOMBIE, this.horseChance, this.horseMinY);
    }

    @Override
    public void onAttack(Entity attacker, Entity immediateAttacker, Entity target, LivingAttackEvent event) {
        if (target instanceof LivingEntity && this.hungerChance > 0) {
            FeatureHelper.addEffect((LivingEntity)target, Effects.field_76438_s, this.hungerDuration, 0, this.hungerChance, true, 4);
        }
    }
}

