/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.misc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.core.RoughMobsRevamped;
import com.p1ut0nium.roughmobsrevamped.reference.Constants;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class AttributeHelper {
    private static Multimap<EntityType<?>, AttributeEntry> map;
    public static final String KEY_ATTRIBUTES;

    public static void initAttributeOption() {
        AttributeHelper.fillMap(RoughConfig.attributes);
    }

    public static boolean applyAttributeModifier(LivingEntity entity, IAttribute attribute, String name, AttributeModifier.Operation operator, double amount) {
        if (amount != 0.0) {
            IAttributeInstance instance = entity.func_110148_a(attribute);
            AttributeModifier modifier = new AttributeModifier(Constants.unique(name), amount, operator);
            if (instance != null && !instance.func_180374_a(modifier)) {
                instance.func_111121_a(modifier);
                if (attribute == SharedMonsterAttributes.field_111267_a) {
                    entity.func_70606_j(entity.func_110138_aP());
                }
                return true;
            }
        }
        return false;
    }

    public static void addAttributes(LivingEntity entity) {
        if (entity.getPersistentData().func_74767_n(KEY_ATTRIBUTES)) {
            return;
        }
        Collection attributes = map.get((Object)entity.func_200600_R());
        int i = 0;
        for (AttributeEntry attribute : attributes) {
            if (!attribute.checkChild(entity)) continue;
            IAttributeInstance instance = entity.func_110140_aT().func_111152_a(attribute.attribute);
            if (instance != null) {
                AttributeModifier modifier = new AttributeModifier(attribute.getUuid(), Constants.unique("mod" + i), attribute.getValue(), attribute.getOperator());
                instance.func_111121_a(modifier);
                if (instance.func_111123_a() == SharedMonsterAttributes.field_111267_a) {
                    entity.func_70606_j(entity.func_110138_aP());
                }
            } else {
                RoughMobsRevamped.LOGGER.error("Error on attribute modification: \"" + attribute.attribute + "\" is not a valid attribute. Affected Entity: " + entity);
            }
            ++i;
        }
        entity.getPersistentData().func_74757_a(KEY_ATTRIBUTES, true);
    }

    private static void fillMap(List<? extends String> attributes) {
        map = ArrayListMultimap.create();
        for (String string : attributes) {
            String[] pars = string.split(";");
            if (pars.length >= 4) {
                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(pars[0]));
                if (entityType != null) {
                    try {
                        int child;
                        AttributeModifier.Operation operator = AttributeModifier.Operation.values()[Integer.parseInt(pars[2])];
                        double value = Double.parseDouble(pars[3]);
                        int dimension = pars.length >= 5 && !pars[4].equals("/") ? Integer.parseInt(pars[4]) : Integer.MIN_VALUE;
                        int n = child = pars.length >= 6 ? Integer.parseInt(pars[5]) : 0;
                        if (child < 0 || child > 2) {
                            RoughMobsRevamped.LOGGER.error("Error on attribute initialization: child is not between 0 and 2: " + string);
                            continue;
                        }
                        map.put((Object)entityType, (Object)new AttributeEntry(UUID.randomUUID(), pars[1], operator, value, dimension, child));
                    }
                    catch (NumberFormatException e) {
                        RoughMobsRevamped.LOGGER.error("Error on attribute initialization: Invalid numbers: " + string);
                    }
                    continue;
                }
                RoughMobsRevamped.LOGGER.error("Error on attribute initialization: Entity " + pars[0] + " does not exist");
                continue;
            }
            RoughMobsRevamped.LOGGER.error("Error on attribute initialization: Wrong amount of arguments: " + string);
        }
    }

    public static String getAttributesString() {
        String attributes = "";
        try {
            for (Field field : SharedMonsterAttributes.class.getFields()) {
                field.setAccessible(true);
                Object obj = field.get(null);
                if (obj == null || !(obj instanceof IAttribute)) continue;
                attributes = attributes + ", " + ((IAttribute)obj).func_111108_a();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attributes.length() > 2 ? attributes.substring(2) : "";
    }

    static {
        KEY_ATTRIBUTES = Constants.unique("attributesApplied");
    }

    public static class AttributeEntry {
        private UUID uuid;
        private String attribute;
        private AttributeModifier.Operation operator;
        private double value;
        private int dimension;
        private int child;

        public AttributeEntry(UUID uuid, String attribute, AttributeModifier.Operation operator2, double value, int dimension, int child) {
            this.uuid = uuid;
            this.attribute = attribute;
            this.operator = operator2;
            this.value = value;
            this.dimension = dimension;
            this.child = child;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public AttributeModifier.Operation getOperator() {
            return this.operator;
        }

        public double getValue() {
            return this.value;
        }

        public int getDimension() {
            return this.dimension;
        }

        public int getChild() {
            return this.child;
        }

        public boolean hasDimension() {
            return this.dimension != Integer.MIN_VALUE;
        }

        public boolean checkChild(LivingEntity entity) {
            return this.child == 0 || this.child == 1 && !entity.func_70631_g_() || this.child == 2 && entity.func_70631_g_();
        }
    }
}

