/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.misc;

import com.p1ut0nium.roughmobsrevamped.compat.GameStagesCompat;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.core.RoughMobsRevamped;
import com.p1ut0nium.roughmobsrevamped.reference.Constants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class EquipHelper {
    private static final String KEY_APPLIED = Constants.unique("equipApplied");
    private static final Random RND = new Random();
    private static boolean playerHasEnchantStage;
    private static boolean enchantStageEnabled;

    private static boolean getChance(Entity entity, int chance) {
        World world;
        double distanceToSpawn;
        if (chance <= 0) {
            return false;
        }
        float distanceChanceIncrease = 0.0f;
        float timeChanceIncrease = 0.0f;
        if (RoughConfig.chanceTimeMultiplier) {
            long currentTime = entity.func_130014_f_().func_82737_E();
            byte currentHour = (byte)Math.floor((currentTime %= 24000L) / 1000L);
            if (currentHour >= 13 && currentHour <= 18) {
                timeChanceIncrease = (float)((double)(currentHour - 12) * 0.16);
            } else if (currentHour > 18 && currentHour <= 22) {
                timeChanceIncrease = (float)((double)Math.abs(currentHour - 23) * 0.25);
            }
        }
        if (RoughConfig.chanceDistMultiplier && (distanceToSpawn = entity.func_70092_e((double)(world = entity.func_130014_f_()).func_175694_M().func_177958_n(), (double)world.func_175694_M().func_177956_o(), (double)world.func_175694_M().func_177952_p())) >= (double)RoughConfig.minDistFromSpawn) {
            distanceChanceIncrease = Math.min(1.0f, (float)(distanceToSpawn -= (double)RoughConfig.minDistFromSpawn) / (float)RoughConfig.distThreshold);
        }
        float adjustedChance = Math.min(1.0f, 1.0f / (float)chance + Math.min(1.0f, 1.0f / (float)chance * distanceChanceIncrease + 1.0f / (float)chance * timeChanceIncrease));
        return Math.random() <= (double)adjustedChance;
    }

    public static class EntryPool<T> {
        public final Map<T, Object[]> POOL = new HashMap<T, Object[]>();
        private List<T> entries = null;

        public void addEntry(T t, Object ... data) {
            this.POOL.put(t, data);
        }

        public T getRandom(Entity entity) {
            return this.getRandom(entity, null);
        }

        public T getRandom(Entity entity, ItemStack item) {
            this.entries = new ArrayList<T>();
            for (Map.Entry<T, Object[]> entry : this.POOL.entrySet()) {
                Object[] data = entry.getValue();
                T key = entry.getKey();
                if (!EntryPool.isDimension(entity, String.valueOf(data[1]))) continue;
                boolean validEntry = true;
                if (item != null && key instanceof Enchantment) {
                    validEntry = ((Enchantment)key).func_92089_a(item);
                }
                if (!validEntry) continue;
                for (int i = 0; i < (Integer)data[0]; ++i) {
                    this.entries.add(key);
                }
            }
            int entrySize = this.entries.size();
            if (entrySize != 0) {
                int rnd = RND.nextInt(entrySize);
                return this.entries.get(rnd);
            }
            return null;
        }

        private static boolean isDimension(Entity entity, String dimension) {
            return dimension.trim().toUpperCase().equals("ALL") || String.valueOf(entity.field_71093_bK).equals(dimension);
        }
    }

    public static class EquipmentPool {
        public final EntryPool<ItemStack> ITEM_POOL = new EntryPool();
        public final EntryPool<Enchantment> ENCHANTMENT_POOL = new EntryPool();

        public static EquipmentPool createEquipmentPool(String name, List<? extends String> equipMainhand, List<? extends String> equipWeaponEnchants) {
            List<String> errorEnchants;
            EquipmentPool pool = new EquipmentPool();
            List<String> errorItems = pool.addItemsFromNames(equipMainhand);
            if (!errorItems.isEmpty()) {
                RoughMobsRevamped.LOGGER.error("Rough Mobs Revamped: error on creating the " + name + " item pool! " + String.join((CharSequence)", ", errorItems));
            }
            if (!(errorEnchants = pool.addEnchantmentsFromNames(equipWeaponEnchants)).isEmpty()) {
                RoughMobsRevamped.LOGGER.error("Rough Mobs Revamped: error on creating the " + name + " enchantment pool! " + String.join((CharSequence)", ", errorEnchants));
            }
            return pool;
        }

        public List<String> addEnchantmentsFromNames(List<? extends String> equipWeaponEnchants) {
            ArrayList<String> errors = new ArrayList<String>();
            for (String string : equipWeaponEnchants) {
                String error = this.addEnchantmentFromName(string);
                if (error == null) continue;
                errors.add(error);
            }
            return errors;
        }

        private String addEnchantmentFromName(String s) {
            String[] parts = s.split(";");
            if (parts.length >= 2) {
                try {
                    int dimension;
                    Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(parts[0]));
                    int probability = Integer.parseInt(parts[1]);
                    int n = dimension = parts.length > 2 ? Integer.parseInt(parts[2]) : Integer.MIN_VALUE;
                    if (ench == null) {
                        return "Invalid enchantment: " + parts[0] + " in line: " + s;
                    }
                    this.addEnchantment(ench, probability, dimension);
                }
                catch (NumberFormatException e) {
                    return "Invalid numbers in line: " + s;
                }
            } else {
                return "Invalid format for line: \"" + s + "\" Please change to enchantment;probability;dimensionID";
            }
            return null;
        }

        public List<String> addItemsFromNames(List<? extends String> equipMainhand) {
            ArrayList<String> errors = new ArrayList<String>();
            for (String string : equipMainhand) {
                String error = this.addItemFromName(string);
                if (error == null) continue;
                errors.add(error);
            }
            return errors;
        }

        private String addItemFromName(String s) {
            String[] parts = s.split(";");
            if (parts.length >= 2) {
                try {
                    String nbt;
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0]));
                    int probability = Integer.parseInt(parts[1]);
                    int dimension = parts.length >= 3 ? Integer.parseInt(parts[2]) : Integer.MIN_VALUE;
                    int meta = parts.length >= 4 ? Integer.parseInt(parts[3]) : 0;
                    String string = nbt = parts.length >= 5 ? parts[4] : "";
                    if (item == null) {
                        return "Invalid item: " + parts[0] + " in line: " + s;
                    }
                    this.addItem(new ItemStack((IItemProvider)item), probability, dimension, nbt);
                }
                catch (NumberFormatException e) {
                    return "Invalid numbers in line: " + s;
                }
            } else {
                return "Invalid format for line: \"" + s + "\" Please change to item;probability;meta";
            }
            return null;
        }

        public void addItem(ItemStack stack, int probability, int dimension, String nbt) {
            this.ITEM_POOL.addEntry(stack, probability, dimension == Integer.MIN_VALUE ? "ALL" : Integer.valueOf(dimension), nbt);
        }

        public void addEnchantment(Enchantment enchantment, int probability, int dimension) {
            this.ENCHANTMENT_POOL.addEntry(enchantment, probability, dimension == Integer.MIN_VALUE ? "ALL" : Integer.valueOf(dimension));
        }

        public ItemStack getRandom(Entity entity, int enchChance, float levelMultiplier) {
            Enchantment ench;
            if (this.ITEM_POOL.POOL.isEmpty()) {
                return null;
            }
            ItemStack randomStack = this.ITEM_POOL.getRandom(entity);
            if ((!enchantStageEnabled || enchantStageEnabled && playerHasEnchantStage) && randomStack != null && !this.ENCHANTMENT_POOL.POOL.isEmpty() && enchChance > 0 && RND.nextInt(enchChance) == 0 && EquipHelper.getChance(entity, enchChance) && (ench = this.ENCHANTMENT_POOL.getRandom(entity, randomStack)) != null) {
                double maxLevel = Math.max(ench.func_77319_d(), Math.min(ench.func_77325_b(), Math.round((float)ench.func_77325_b() * levelMultiplier)));
                int level = (int)Math.round(maxLevel * (0.5 + Math.random() / 2.0));
                if (!randomStack.func_77948_v()) {
                    randomStack.func_77966_a(ench, level);
                }
            }
            return randomStack;
        }
    }

    public static class EquipmentApplier {
        private final String name;
        private final int chancePerWeaponDefault;
        private final int chancePerArmorDefault;
        private final int enchChanceDefault;
        private final float enchMultiplierDefault;
        private final float dropChanceDefault;
        private int chancePerWeapon;
        private int chancePerArmor;
        private int enchChance;
        private float enchMultiplier;
        private float dropChance;
        private EquipmentPool poolMainhand;
        private EquipmentPool poolOffhand;
        private EquipmentPool poolHelmet;
        private EquipmentPool poolChestplate;
        private EquipmentPool poolLeggings;
        private EquipmentPool poolBoots;
        private List<? extends String> equipMainhand;
        private List<? extends String> equipOffhand;
        private List<? extends String> equipHelmet;
        private List<? extends String> equipChestplate;
        private List<? extends String> equipLeggings;
        private List<? extends String> equipBoots;
        private List<? extends String> equipWeaponEnchants;
        private List<? extends String> equipArmorEnchants;

        public EquipmentApplier(String name, int chancePerWeaponDefault, int chancePerArmorDefault, int enchChanceDefault, float enchMultiplierDefault, float dropChanceDefault) {
            this.name = name;
            this.chancePerWeaponDefault = chancePerWeaponDefault;
            this.chancePerArmorDefault = chancePerArmorDefault;
            this.enchChanceDefault = enchChanceDefault;
            this.enchMultiplierDefault = enchMultiplierDefault;
            this.dropChanceDefault = dropChanceDefault;
        }

        public EquipmentPool getPoolMainhand() {
            return this.poolMainhand;
        }

        public EquipmentPool getPoolOffhand() {
            return this.poolOffhand;
        }

        public EquipmentPool getPoolHelmet() {
            return this.poolHelmet;
        }

        public EquipmentPool getPoolChestplate() {
            return this.poolChestplate;
        }

        public EquipmentPool getPoolLeggings() {
            return this.poolLeggings;
        }

        public EquipmentPool getPoolBoots() {
            return this.poolBoots;
        }

        public void setPoolMainhand(EquipmentPool poolMainhand) {
            this.poolMainhand = poolMainhand;
        }

        public void setPoolOffhand(EquipmentPool poolOffhand) {
            this.poolOffhand = poolOffhand;
        }

        public void setPoolHelmet(EquipmentPool poolHelmet) {
            this.poolHelmet = poolHelmet;
        }

        public void setPoolChestplate(EquipmentPool poolChestplate) {
            this.poolChestplate = poolChestplate;
        }

        public void setPoolLeggings(EquipmentPool poolLeggings) {
            this.poolLeggings = poolLeggings;
        }

        public void setPoolBoots(EquipmentPool poolBoots) {
            this.poolBoots = poolBoots;
        }

        public void equipEntity(MobEntity entity) {
            this.equipEntity(entity, false);
        }

        public void equipEntity(MobEntity boss, boolean isBoss) {
            if (boss == null || boss.getPersistentData().func_74767_n(KEY_APPLIED) || !(boss instanceof MobEntity)) {
                return;
            }
            PlayerEntity playerClosest = boss.field_70170_p.func_217362_a((Entity)boss, -1.0);
            enchantStageEnabled = GameStagesCompat.useEnchantStage();
            if (enchantStageEnabled) {
                playerHasEnchantStage = GameStageHelper.hasAnyOf((ServerPlayerEntity)((ServerPlayerEntity)playerClosest), (String[])new String[]{"roughmobsall", "roughmobsenchant"});
            } else {
                playerHasEnchantStage = false;
            }
            EquipmentPool[] pools = new EquipmentPool[]{this.poolMainhand, this.poolOffhand, this.poolBoots, this.poolLeggings, this.poolChestplate, this.poolHelmet};
            boolean completeArmorSet = isBoss;
            for (int i = 0; i < pools.length; ++i) {
                ItemStack stack;
                int chance;
                EquipmentPool pool = pools[i];
                EquipmentSlotType slot = EquipmentSlotType.values()[i];
                int n = chance = i <= 1 ? this.chancePerWeapon : this.chancePerArmor;
                if (!EquipHelper.getChance((Entity)boss, chance) && (!completeArmorSet || i <= 1) || (stack = pool.getRandom((Entity)boss, this.enchChance, this.enchMultiplier)) == null) continue;
                boss.func_184201_a(slot, stack);
                boss.func_184642_a(slot, this.dropChance);
            }
            boss.getPersistentData().func_74757_a(KEY_APPLIED, true);
        }

        public void initConfig(boolean isBoss, boolean useDefaultValues) {
            String formatName = this.name.toLowerCase().replace(" ", "") + "Equipment";
            if (useDefaultValues) {
                this.chancePerWeapon = this.chancePerWeaponDefault;
                this.chancePerArmor = this.chancePerArmorDefault;
                this.enchChance = this.enchChanceDefault;
                this.enchMultiplier = this.enchMultiplierDefault;
                this.dropChance = this.dropChanceDefault;
            } else {
                this.chancePerWeapon = RoughConfig.chancePerWeapon;
                this.chancePerArmor = RoughConfig.chancePerArmor;
                this.enchChance = RoughConfig.chancePerEnchantment;
                this.enchMultiplier = RoughConfig.enchantMultiplier;
                this.dropChance = RoughConfig.dropChance;
            }
            this.equipMainhand = RoughConfig.equipMainhand;
            this.equipOffhand = RoughConfig.equipOffhand;
            this.equipHelmet = RoughConfig.equipHelmet;
            this.equipChestplate = RoughConfig.equipChestplate;
            this.equipLeggings = RoughConfig.equipLeggings;
            this.equipBoots = RoughConfig.equipBoots;
            this.equipWeaponEnchants = RoughConfig.equipWeaponEnchants;
            this.equipArmorEnchants = RoughConfig.equipArmorEnchants;
        }

        public void createPools() {
            this.setPoolMainhand(EquipmentPool.createEquipmentPool("mainhand", this.equipMainhand, this.equipWeaponEnchants));
            this.setPoolOffhand(EquipmentPool.createEquipmentPool("offhand", this.equipOffhand, this.equipWeaponEnchants));
            this.setPoolHelmet(EquipmentPool.createEquipmentPool("helmet", this.equipHelmet, this.equipArmorEnchants));
            this.setPoolChestplate(EquipmentPool.createEquipmentPool("chestplate", this.equipChestplate, this.equipArmorEnchants));
            this.setPoolLeggings(EquipmentPool.createEquipmentPool("leggings", this.equipLeggings, this.equipArmorEnchants));
            this.setPoolBoots(EquipmentPool.createEquipmentPool("boots", this.equipBoots, this.equipArmorEnchants));
        }
    }
}

