/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.misc;

import com.p1ut0nium.roughmobsrevamped.core.RoughMobsRevamped;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class FeatureHelper {
    public static boolean removeGoal(CreatureEntity entity, Class<? extends Goal> goalClass) {
        return FeatureHelper.tryRemoveGoal(entity, entity.field_70714_bg, goalClass) || FeatureHelper.tryRemoveGoal(entity, entity.field_70715_bh, goalClass);
    }

    private static boolean tryRemoveGoal(CreatureEntity entity, GoalSelector goalSelector, Class<? extends Goal> goalClass) {
        List<Stream> goals = Arrays.asList(goalSelector.func_220888_c());
        try {
            goals.stream().filter(g -> g.getClass().equals(goalClass)).forEach(g -> goalSelector.func_85156_a((Goal)g));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean addEffect(LivingEntity entity, Effect effect, int duration, int startAmplifier, int chance, boolean isIncreasing, int maxAmplifier) {
        EffectInstance active;
        if (entity == null || effect == null || startAmplifier < 0 || chance <= 0 || duration <= 0 || entity.func_70681_au().nextInt(chance) != 0) {
            return false;
        }
        int amplifier = startAmplifier;
        if (isIncreasing && (active = entity.func_70660_b(effect)) != null) {
            if (active.func_76459_b() == duration) {
                return false;
            }
            amplifier = Math.min(startAmplifier + active.func_76458_c() + 1, maxAmplifier);
        }
        entity.func_195064_c(new EffectInstance(effect, duration, amplifier));
        return true;
    }

    public static boolean addEffect(LivingEntity entity, Effect effect, int duration, int amplifier, int chance) {
        return FeatureHelper.addEffect(entity, effect, duration, amplifier, chance, false, 127);
    }

    public static boolean addEffect(LivingEntity entity, Effect effect, int duration, int amplifier) {
        return FeatureHelper.addEffect(entity, effect, duration, amplifier, 1);
    }

    public static boolean addEffect(LivingEntity entity, Effect effect, int duration) {
        return FeatureHelper.addEffect(entity, effect, duration, 0);
    }

    public static void spawnParticle(Entity entity, BasicParticleType type, float spread, int amount) {
        Random rnd = entity.field_70170_p.field_73012_v;
        for (int i = 0; i < amount; ++i) {
            double moveX = (rnd.nextDouble() - 0.5) * 2.0 * (double)spread;
            double moveY = -rnd.nextDouble() * (double)spread;
            double moveZ = (rnd.nextDouble() - 0.5) * 2.0 * (double)spread;
            ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)type, entity.func_226277_ct_() + (rnd.nextDouble() - 0.5) * (double)entity.func_213311_cf(), entity.func_226278_cu_() + rnd.nextDouble() * (double)entity.func_213302_cg() - 0.25, entity.func_226281_cx_() + (rnd.nextDouble() - 0.5) * (double)entity.func_213311_cf(), 1, moveX, moveY, moveZ, 0.0);
        }
    }

    public static void spawnParticle(Entity entity, BasicParticleType type, int amount) {
        FeatureHelper.spawnParticle(entity, type, 1.0f, amount);
    }

    public static void spawnParticle(Entity entity, BasicParticleType type) {
        FeatureHelper.spawnParticle(entity, type, 1);
    }

    public static void playSound(Entity entity, SoundEvent event, float volume, float pitch) {
        entity.field_70170_p.func_184148_a((PlayerEntity)null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, event, entity.func_184176_by(), volume, pitch);
        entity.func_184185_a(event, volume, pitch);
    }

    public static void playSound(Entity entity, SoundEvent event) {
        FeatureHelper.playSound(entity, event, 1.0f, 1.0f);
    }

    public static void knockback(Entity attacker, LivingEntity target, float strength, float extraLeap) {
        double xRatio = attacker.func_226277_ct_() - target.func_226277_ct_();
        double zRatio = attacker.func_226281_cx_() - target.func_226281_cx_();
        target.func_70653_a(attacker, strength, xRatio, zRatio);
        target.func_213293_j(target.func_213322_ci().func_82615_a(), target.func_213322_ci().func_82617_b() + (double)extraLeap, target.func_213322_ci().func_82616_c());
    }

    public static List<Block> getBlocksFromNames(List<? extends String> breakBlocks) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String string : breakBlocks) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string));
            if (block == null) {
                RoughMobsRevamped.LOGGER.error(string + " isn't a valid block!");
                continue;
            }
            blocks.add(block);
        }
        return blocks;
    }

    public static List<EntityType<?>> getEntitiesFromNames(List<String> entities) {
        ArrayList entityTypes = new ArrayList();
        for (String name : entities) {
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(name));
            if (entityType == null) {
                RoughMobsRevamped.LOGGER.error(name + " isn't a valid entity!");
                continue;
            }
            entityTypes.add(entityType);
        }
        return entityTypes;
    }

    public static Map<Potion, Integer> getPotionsFromNames(String[] potionNames) {
        HashMap<Potion, Integer> potions = new HashMap<Potion, Integer>();
        for (String name : potionNames) {
            String[] parts = name.split(";");
            if (parts.length < 2) continue;
            Potion potion = Potion.func_185168_a((String)parts[0]);
            if (potion == null) {
                RoughMobsRevamped.LOGGER.error(parts[0] + " isn't a valid potion effect!");
                continue;
            }
            try {
                potions.put(potion, Integer.parseInt(parts[1]));
            }
            catch (NumberFormatException e) {
                RoughMobsRevamped.LOGGER.error(parts[1] + " isn't a valid number!");
            }
        }
        return potions;
    }
}

