/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.misc;

import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.entity.ai.goal.RoughAISearchForRiderGoal;
import com.p1ut0nium.roughmobsrevamped.features.HostileHorseFeatures;
import com.p1ut0nium.roughmobsrevamped.misc.BossHelper;
import com.p1ut0nium.roughmobsrevamped.misc.FeatureHelper;
import com.p1ut0nium.roughmobsrevamped.reference.Constants;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class MountHelper {
    public static final Random RND = new Random();

    public static AbstractHorseEntity createHorse(World world, Entity owner, HorseType type) {
        AbstractHorseEntity horse = type.createInstance(world);
        horse.func_70107_b(owner.func_226277_ct_(), owner.func_226278_cu_(), owner.func_226281_cx_());
        horse.func_213386_a((IWorld)world, world.func_175649_E(owner.func_180425_c()), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, null);
        horse.field_70172_ad = 60;
        horse.func_110234_j(true);
        horse.func_70873_a(0);
        horse.getPersistentData().func_74757_a(HostileHorseFeatures.ROUGH_HORSE, true);
        world.func_217376_c((Entity)horse);
        return horse;
    }

    public static boolean tryMountHorse(MobEntity rider, HorseType type, int chance, int minY) {
        if (rider.func_226278_cu_() < (double)minY) {
            return false;
        }
        if (!BossHelper.isBoss(rider) && (chance <= 0 || RND.nextInt(chance) != 0 || rider.func_184218_aH() || rider instanceof ZombieEntity && ((ZombieEntity)rider).func_70631_g_())) {
            return false;
        }
        if (rider.getPersistentData().func_74767_n(Rider.RIDER)) {
            return false;
        }
        AbstractHorseEntity mount = MountHelper.createHorse(rider.field_70170_p, (Entity)rider, type);
        rider.func_184220_m((Entity)mount);
        return true;
    }

    public static enum HorseType {
        NORMAL,
        ZOMBIE,
        SKELETON;


        public AbstractHorseEntity createInstance(World world) {
            switch (this) {
                case ZOMBIE: {
                    return new ZombieHorseEntity(EntityType.field_200726_aE, world);
                }
                case SKELETON: {
                    return new SkeletonHorseEntity(EntityType.field_200742_ah, world);
                }
            }
            return new HorseEntity(EntityType.field_200762_B, world);
        }
    }

    public static class Rider {
        public static final String RIDER = Constants.unique("isrider");
        private final String name;
        private final List<String> defaultRiders;
        private final int defaultChance;
        private List<String> riderEntities;
        private int chance;
        private int randomRiderChance;
        private List<EntityType<?>> riderList;

        public Rider(String name, List<String> defaultRiders, int defaultChance) {
            this.name = name;
            this.defaultRiders = defaultRiders;
            this.defaultChance = defaultChance;
        }

        public void initConfigs() {
            this.chance = RoughConfig.spiderRiderChance;
            this.riderEntities = RoughConfig.spiderRiderEntities;
            this.randomRiderChance = RoughConfig.spiderRiderChanceRandom;
        }

        public void postInit() {
            this.riderList = FeatureHelper.getEntitiesFromNames(this.riderEntities);
        }

        public void addAI(LivingEntity mount) {
            if (this.randomRiderChance > 0) {
                ((MobEntity)mount).field_70714_bg.func_75776_a(1, (Goal)new RoughAISearchForRiderGoal(mount, this.getPossibleRiders(), 32, this.randomRiderChance));
            }
        }

        public void tryAddRider(LivingEntity mount) {
            if (this.chance <= 0 || mount == null || this.riderList.isEmpty() || mount.getPersistentData().func_74767_n(RIDER) || RND.nextInt(this.chance) != 0) {
                return;
            }
            EntityType<?> riderType = this.riderList.get(RND.nextInt(this.riderList.size()));
            MobEntity rider = (MobEntity)riderType.func_200721_a(mount.func_130014_f_());
            rider.func_70107_b(mount.func_226277_ct_(), mount.func_226278_cu_(), mount.func_226281_cx_());
            rider.field_70172_ad = 60;
            rider.getPersistentData().func_74757_a(RIDER, true);
            mount.func_130014_f_().func_217376_c((Entity)rider);
            if (!(rider.func_184218_aH() || rider.func_184207_aI() || mount.func_184218_aH() || mount.func_184207_aI())) {
                rider.func_184220_m((Entity)mount);
            }
        }

        public boolean isPossibleRider(MobEntity entity) {
            for (EntityType<?> entityType : this.riderList) {
                if (entityType != entity.func_200600_R()) continue;
                return true;
            }
            return false;
        }

        public List<EntityType<?>> getPossibleRiders() {
            ArrayList possibleRidersList = new ArrayList();
            for (EntityType<?> entityType : this.riderList) {
                possibleRidersList.add(entityType);
            }
            return possibleRidersList;
        }
    }
}

