/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.misc;

import com.p1ut0nium.roughmobsrevamped.compat.CompatHandler;
import com.p1ut0nium.roughmobsrevamped.compat.SereneSeasonsCompat;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.core.RoughMobsRevamped;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnHelper {
    public static final List<SpawnEntry> ENTRIES = new ArrayList<SpawnEntry>();
    private static boolean disableBabyZombies;

    public static boolean disableBabyZombies() {
        return disableBabyZombies;
    }

    public static void initSpawnOption() {
        if (!SpawnHelper.hasDefaultConfig()) {
            return;
        }
    }

    private static void fillEntries(String[] options) {
        for (String option : options) {
            String[] parts = option.split(";");
            if (parts.length >= 5) {
                String[] biomes = new String[parts.length - 5];
                for (int i = 0; i < biomes.length; ++i) {
                    biomes[i] = parts[5 + i];
                }
                SpawnEntry entry = new SpawnEntry(parts[0], parts[1], parts[2], parts[3], parts[4], biomes);
                if (entry.isValid()) {
                    ENTRIES.add(entry);
                    continue;
                }
                RoughMobsRevamped.LOGGER.error("Spawn Entries: " + entry.getError());
                continue;
            }
            RoughMobsRevamped.LOGGER.error("Spawn Entries: Entry \"" + option + "\" needs at least 5 values!");
        }
    }

    public static boolean checkSpawnConditions(EntityJoinWorldEvent event) {
        Double distanceToSpawn;
        Entity entity = event.getEntity();
        PlayerEntity playerClosest = entity.field_70170_p.func_217362_a(entity, -1.0);
        World world = entity.func_130014_f_();
        if (entity.getClass() == ZombieEntity.class && ((ZombieEntity)entity).func_70631_g_() && disableBabyZombies) {
            entity.func_70106_y();
            event.setCanceled(true);
            return false;
        }
        boolean sereneSeasonsEnabled = CompatHandler.isSereneSeasonsLoaded();
        String currentSeason = null;
        List<String> seasonWhiteList = null;
        if (sereneSeasonsEnabled) {
            currentSeason = SereneSeasonsCompat.getSeason(world);
            seasonWhiteList = SereneSeasonsCompat.getSeasonWhitelist();
        }
        return (!sereneSeasonsEnabled || seasonWhiteList.contains(currentSeason)) && (distanceToSpawn = Double.valueOf(entity.func_70092_e((double)world.func_175694_M().func_177958_n(), (double)world.func_175694_M().func_177956_o(), (double)world.func_175694_M().func_177952_p()))) >= (double)RoughConfig.minDistFromSpawn && playerClosest != null && playerClosest.field_71068_ca >= RoughConfig.minPlayerLevel && (!RoughConfig.mustBeUnderground || !world.func_175710_j(entity.func_180425_c()) && RoughConfig.mustBeUnderground) && entity.func_180425_c().func_177956_o() <= RoughConfig.maxSpawnHeight;
    }

    public static boolean hasDefaultConfig() {
        return true;
    }

    public static class SpawnEntry {
        public static final Map<String, BiomeDictionary.Type> TYPE_MAP = (Map)ObfuscationReflectionHelper.getPrivateValue(BiomeDictionary.Type.class, null, (String)"field_194044_a");
        public static final String OW_TYPE = "OVERWORLD";
        public static final String DISABLE_KEY = "!";
        private boolean valid = true;
        private String error = "";
        public EntityType<?> entityType;
        public int prob;
        public int min;
        public int max;
        public EntityClassification type;
        public Tuple<Biome[], Biome[]> biomes;

        public SpawnEntry(String entityName, String prob, String min, String max, String type, String ... biomes) {
            this.entityType = this.getEntityType(entityName);
            this.prob = this.getInteger(prob);
            this.min = this.getInteger(min);
            this.max = this.getInteger(max);
            this.type = this.getType(type);
            this.biomes = this.getBiomes(biomes);
        }

        private Tuple<Biome[], Biome[]> getBiomes(String[] biomes) {
            ArrayList<Biome> listAdd = new ArrayList<Biome>();
            ArrayList<Biome> listRemove = new ArrayList<Biome>();
            for (String biomeId : biomes) {
                ArrayList<Biome> list;
                ArrayList<Biome> arrayList = list = biomeId.startsWith(DISABLE_KEY) ? listRemove : listAdd;
                if (biomeId.startsWith(DISABLE_KEY)) {
                    biomeId = biomeId.substring(1);
                }
                BiomeDictionary.Type type = TYPE_MAP.get(biomeId);
                if (biomeId.equals(OW_TYPE)) continue;
                if (type != null) {
                    list.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
                    continue;
                }
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeId));
                if (biome != null) {
                    list.add(biome);
                    continue;
                }
                int id = this.getInteger(biomeId);
                if (id < 0) continue;
            }
            if (biomes.length == 0) {
                for (Biome biome : ForgeRegistries.BIOMES) {
                    listAdd.add(biome);
                }
            }
            Biome[] resultToAdd = new Biome[listAdd.size()];
            Biome[] resultToRemove = new Biome[listRemove.size()];
            return new Tuple((Object)listAdd.toArray(resultToAdd), (Object)listRemove.toArray(resultToRemove));
        }

        private EntityClassification getType(String type) {
            switch (type.toUpperCase()) {
                case "AMBIENT": {
                    return EntityClassification.AMBIENT;
                }
                case "CREATURE": {
                    return EntityClassification.CREATURE;
                }
                case "MONSTER": {
                    return EntityClassification.MONSTER;
                }
                case "WATER_CREATURE": {
                    return EntityClassification.WATER_CREATURE;
                }
            }
            this.valid = false;
            this.error = "Creature type " + type + " doesn't exist!";
            return null;
        }

        private int getInteger(String str) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                this.valid = false;
                this.error = this.prob + " is not a valid number!";
                return -1;
            }
        }

        public static List<String> getRegNames(List<EntityType<?>> entityType) {
            ArrayList<String> regNames = new ArrayList<String>();
            for (EntityType<?> clazz : entityType) {
                regNames.add(EntityType.func_200718_a(clazz).toString());
            }
            return regNames;
        }

        private EntityType<?> getEntityType(String entityName) {
            ResourceLocation loc = new ResourceLocation(entityName);
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(loc);
            if (entityType != null) {
                try {
                    return entityType;
                }
                catch (Exception e) {
                    this.valid = false;
                    this.error = entityName + " is not a valid living entity!";
                }
            } else {
                this.valid = false;
                this.error = entityName + " is not a valid entity!";
            }
            return null;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getError() {
            return this.error;
        }
    }
}

