/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import sereneseasons.api.SSBlocks;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.season.SeasonTime;
import sereneseasons.tileentity.SeasonSensorTileEntity;

public class SeasonSensorBlock
extends ContainerBlock {
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private final DetectorType type;

    public SeasonSensorBlock(Block.Properties properties, DetectorType type) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
        this.type = type;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext selectionContext) {
        return SHAPE;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader reader, BlockPos pos, Direction direction) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    public void updatePower(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (SeasonsConfig.isDimensionWhitelisted(world.func_201675_m().func_186058_p().func_186068_a())) {
            BlockState currentState = world.func_180495_p(pos);
            int power = 0;
            int startTicks = this.type.ordinal() * SeasonTime.ZERO.getSeasonDuration();
            int endTicks = (this.type.ordinal() + 1) * SeasonTime.ZERO.getSeasonDuration();
            int currentTicks = SeasonHelper.getSeasonState(world).getSeasonCycleTicks();
            if (currentTicks >= startTicks && currentTicks <= endTicks) {
                float delta = (float)(currentTicks - startTicks) / (float)SeasonTime.ZERO.getSeasonDuration();
                power = (int)Math.min(delta * 15.0f + 1.0f, 15.0f);
            }
            if ((Integer)currentState.func_177229_b((IProperty)POWER) != power) {
                world.func_180501_a(pos, (BlockState)currentState.func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(power)), 3);
            }
        }
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (player.func_175142_cm()) {
            if (world.field_72995_K) {
                return true;
            }
            Block nextBlock = SSBlocks.season_sensors[(this.type.ordinal() + 1) % DetectorType.values().length];
            world.func_180501_a(pos, (BlockState)nextBlock.func_176223_P().func_206870_a((IProperty)POWER, state.func_177229_b((IProperty)POWER)), 4);
            ((SeasonSensorBlock)nextBlock).updatePower(world, pos);
            return true;
        }
        return super.func_220051_a(state, world, pos, player, hand, rayTraceResult);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader reader) {
        return new SeasonSensorTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{POWER});
    }

    public static enum DetectorType implements IStringSerializable
    {
        SPRING,
        SUMMER,
        AUTUMN,
        WINTER;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

