/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import sereneseasons.api.config.SeasonsOption;
import sereneseasons.api.config.SyncedConfig;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.handler.PacketHandler;
import sereneseasons.network.message.MessageSyncSeasonCycle;
import sereneseasons.season.SeasonSavedData;
import sereneseasons.season.SeasonTime;

public class SeasonHandler
implements SeasonHelper.ISeasonDataProvider {
    private Season.SubSeason lastSeason = null;
    public static final HashMap<Integer, Integer> clientSeasonCycleTicks = new HashMap();

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (event.phase == TickEvent.Phase.END && !world.field_72995_K) {
            MinecraftServer server;
            if (!SyncedConfig.getBooleanValue(SeasonsOption.PROGRESS_SEASON_WHILE_OFFLINE) && (server = world.func_73046_m()) != null && server.func_184103_al().func_72394_k() == 0) {
                return;
            }
            SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
            if (savedData.seasonCycleTicks++ > SeasonTime.ZERO.getCycleDuration()) {
                savedData.seasonCycleTicks = 0;
            }
            if (savedData.seasonCycleTicks % 20 == 0) {
                SeasonHandler.sendSeasonUpdate(world);
            }
            savedData.func_76185_a();
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        SeasonHandler.sendSeasonUpdate(world);
    }

    public static SeasonTime getClientSeasonTime() {
        Integer i = clientSeasonCycleTicks.get(0);
        return new SeasonTime(i == null ? 0 : i);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        int dimension = Minecraft.func_71410_x().field_71439_g.field_71093_bK.func_186068_a();
        if (event.phase == TickEvent.Phase.END && SeasonsConfig.isDimensionWhitelisted(dimension)) {
            SeasonTime calendar;
            clientSeasonCycleTicks.compute(dimension, (k, v) -> v == null ? 0 : v + 1);
            if (clientSeasonCycleTicks.get(dimension) > SeasonTime.ZERO.getCycleDuration()) {
                clientSeasonCycleTicks.put(dimension, 0);
            }
            if ((calendar = new SeasonTime(clientSeasonCycleTicks.get(dimension))).getSubSeason() != this.lastSeason) {
                Minecraft.func_71410_x().field_71438_f.func_72712_a();
                this.lastSeason = calendar.getSubSeason();
            }
        }
    }

    public static void sendSeasonUpdate(World world) {
        if (!world.field_72995_K) {
            SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
            PacketHandler.HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new MessageSyncSeasonCycle(world.func_201675_m().func_186058_p().func_186068_a(), savedData.seasonCycleTicks));
        }
    }

    public static SeasonSavedData getSeasonSavedData(World w) {
        if (w.func_201670_d() || !(w instanceof ServerWorld)) {
            return null;
        }
        ServerWorld world = (ServerWorld)w;
        DimensionSavedDataManager saveDataManager = world.func_72863_F().func_217227_h();
        Supplier<SeasonSavedData> defaultSaveDataSupplier = () -> {
            SeasonSavedData savedData = new SeasonSavedData("seasons");
            int startingSeason = SyncedConfig.getIntValue(SeasonsOption.STARTING_SUB_SEASON);
            if (startingSeason == 0) {
                savedData.seasonCycleTicks = world.field_73012_v.nextInt(12) * SeasonTime.ZERO.getSubSeasonDuration();
            }
            if (startingSeason > 0) {
                savedData.seasonCycleTicks = (startingSeason - 1) * SeasonTime.ZERO.getSubSeasonDuration();
            }
            savedData.func_76185_a();
            return savedData;
        };
        return (SeasonSavedData)saveDataManager.func_215752_a(defaultSaveDataSupplier, "seasons");
    }

    @Override
    public ISeasonState getServerSeasonState(World world) {
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
        return new SeasonTime(savedData.seasonCycleTicks);
    }

    @Override
    public ISeasonState getClientSeasonState() {
        Integer i = clientSeasonCycleTicks.get(0);
        return new SeasonTime(i == null ? 0 : i);
    }
}

