/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import net.minecraft.block.Block;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sereneseasons.api.SSBlocks;
import sereneseasons.config.FertilityConfig;
import sereneseasons.init.ModFertility;

@Mod.EventBusSubscriber
public class SeasonalCropGrowthHandler {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onItemTooltipAdded(ItemTooltipEvent event) {
        ModFertility.setupTooltips(event);
    }

    @SubscribeEvent
    public void onCropGrowth(BlockEvent.CropGrowEvent event) {
        Block plant = event.getState().func_177230_c();
        World world = (World)event.getWorld();
        boolean isFertile = ModFertility.isCropFertile(plant.getRegistryName().toString(), world, event.getPos());
        if (((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && !isFertile && !this.isGreenhouseGlassAboveBlock(world, event.getPos())) {
            if (((Boolean)FertilityConfig.cropsBreak.get()).booleanValue() && !(plant instanceof GrassBlock) && !(plant instanceof SugarCaneBlock)) {
                event.getWorld().func_175655_b(event.getPos(), true);
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onApplyBonemeal(BonemealEvent event) {
        Block plant = event.getBlock().func_177230_c();
        boolean isFertile = ModFertility.isCropFertile(plant.getRegistryName().toString(), event.getWorld(), event.getPos());
        if (((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && !isFertile && !this.isGreenhouseGlassAboveBlock(event.getWorld(), event.getPos())) {
            if (((Boolean)FertilityConfig.cropsBreak.get()).booleanValue() && !(plant instanceof GrassBlock) && !(plant instanceof SugarCaneBlock)) {
                event.getWorld().func_175655_b(event.getPos(), true);
            }
            event.setCanceled(true);
        }
    }

    private boolean isGreenhouseGlassAboveBlock(World world, BlockPos cropPos) {
        for (int i = 0; i < (Integer)FertilityConfig.greenhouseGlassMaxHeight.get(); ++i) {
            if (!world.func_180495_p(cropPos.func_177982_a(0, i + 1, 0)).func_177230_c().equals(SSBlocks.greenhouse_glass)) continue;
            return true;
        }
        return false;
    }
}

