/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import sereneseasons.handler.season.SeasonHandler;

public class MessageSyncSeasonCycle {
    public int dimension;
    public int seasonCycleTicks;

    public MessageSyncSeasonCycle() {
    }

    public MessageSyncSeasonCycle(int dimension, int seasonCycleTicks) {
        this.dimension = dimension;
        this.seasonCycleTicks = seasonCycleTicks;
    }

    public static void encode(MessageSyncSeasonCycle packet, PacketBuffer buf) {
        buf.writeInt(packet.dimension);
        buf.writeInt(packet.seasonCycleTicks);
    }

    public static MessageSyncSeasonCycle decode(PacketBuffer buf) {
        return new MessageSyncSeasonCycle(buf.readInt(), buf.readInt());
    }

    public static class Handler {
        public static void handle(MessageSyncSeasonCycle packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                if (Minecraft.func_71410_x().field_71439_g == null) {
                    return;
                }
                int playerDimension = Minecraft.func_71410_x().field_71439_g.field_71093_bK.func_186068_a();
                if (playerDimension == packet.dimension) {
                    SeasonHandler.clientSeasonCycleTicks.replace(playerDimension, packet.seasonCycleTicks);
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

