/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.rohzek.dive.armor;

import com.gmail.rohzek.dive.armor.SArmor;
import com.gmail.rohzek.dive.main.Main;
import com.gmail.rohzek.dive.util.ConfigurationManager;
import com.gmail.rohzek.dive.util.LogHelper;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SDiveGear
extends ArmorItem {
    float oldFlySpeed = -1.0f;
    float newFlySpeed = 0.03f;

    public SDiveGear(String name, IArmorMaterial mat, EquipmentSlotType equipSlot) {
        super(mat, equipSlot, new Item.Properties().func_200916_a(Main.DIVE_GEAR_TAB).func_200917_a(1));
        this.setNames(name);
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)ConfigurationManager.GENERAL.minutesOfAir.get() * 60 * 1000;
    }

    void setNames(String name) {
        this.setRegistryName("simpledivegear", name);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!player.func_184812_l_() && !player.func_175149_v()) {
            Block above = world.func_180495_p(new BlockPos(player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o() + 1, player.func_180425_c().func_177952_p())).func_177230_c();
            NonNullList armorSlots = player.field_71071_by.field_70460_b;
            ItemStack head = (ItemStack)armorSlots.get(3);
            ItemStack chest = (ItemStack)armorSlots.get(2);
            ItemStack legs = (ItemStack)armorSlots.get(1);
            ItemStack feet = (ItemStack)armorSlots.get(0);
            if (player.func_70090_H()) {
                LogHelper.debug("I'm in water!");
                this.addChanges(world, player, head, chest, legs, feet, above);
                if (above == Blocks.field_150355_j || above == Blocks.field_203198_aQ) {
                    if ((head.func_77973_b() == SArmor.DIVE_HELMET || head.func_77973_b() == SArmor.DIVE_HELMET_LIGHTS) && chest.func_77973_b() == SArmor.DIVE_CHEST) {
                        LogHelper.debug("I'm underwater, damage the air tank!");
                        this.damageTank(chest, player);
                    }
                } else {
                    LogHelper.debug("I'm above water, repair the air tank!");
                    this.repairTank(chest, player);
                }
            } else {
                LogHelper.debug("I'm not in water, repair the air tank, and remove the buffs!");
                this.removeChanges(world, player, head, chest, legs, feet);
                this.repairTank(chest, player);
            }
        }
    }

    private void addChanges(World world, PlayerEntity player, ItemStack head, ItemStack chest, ItemStack legs, ItemStack feet, Block above) {
        if (head != null && head.func_77973_b().equals((Object)SArmor.DIVE_HELMET_LIGHTS) && above == Blocks.field_150355_j) {
            player.func_195064_c(new EffectInstance(Effects.field_76439_r, 2, 0, false, false));
        }
        if (head != null && (head.func_77973_b().equals((Object)SArmor.DIVE_HELMET) || head.func_77973_b().equals((Object)SArmor.DIVE_HELMET_LIGHTS)) && EnchantmentHelper.func_82781_a((ItemStack)head).get(Enchantments.field_185298_f) == null) {
            head.func_77966_a(Enchantments.field_185298_f, 1);
        }
        if (chest != null && chest.func_77973_b().equals((Object)SArmor.DIVE_CHEST) && EnchantmentHelper.func_82781_a((ItemStack)chest).get(Enchantments.field_185299_g) == null) {
            chest.func_77966_a(Enchantments.field_185299_g, 1);
        }
        if (head != null && (head.func_77973_b().equals((Object)SArmor.DIVE_HELMET) || head.func_77973_b().equals((Object)SArmor.DIVE_HELMET_LIGHTS)) && chest != null && chest.func_77973_b().equals((Object)SArmor.DIVE_CHEST) && above == Blocks.field_150355_j && chest.func_77952_i() < chest.func_77958_k() - 40) {
            player.func_195064_c(new EffectInstance(Effects.field_76427_o, 2, 0, false, false));
        }
        if (feet != null && feet.func_77973_b().equals((Object)SArmor.DIVE_BOOTS) && EnchantmentHelper.func_82781_a((ItemStack)feet).get(Enchantments.field_185300_i) == null) {
            feet.func_77966_a(Enchantments.field_185300_i, 1);
        }
        if (legs != null && legs.func_77973_b().equals((Object)SArmor.DIVE_LEGS) && feet != null && feet.func_77973_b().equals((Object)SArmor.DIVE_BOOTS)) {
            if (this.oldFlySpeed == -1.0f) {
                this.oldFlySpeed = player.field_71075_bZ.func_75093_a();
            }
            if (world.field_72995_K) {
                player.field_71075_bZ.func_195931_a(this.newFlySpeed);
            }
            player.field_71075_bZ.field_75100_b = true;
        }
    }

    private void removeChanges(World world, PlayerEntity player, ItemStack head, ItemStack chest, ItemStack legs, ItemStack feet) {
        if (head != null && head.func_77973_b().equals((Object)SArmor.DIVE_HELMET) || head.func_77973_b().equals((Object)SArmor.DIVE_HELMET_LIGHTS)) {
            this.removeEnchantments(head);
        }
        if (chest != null && chest.func_77973_b().equals((Object)SArmor.DIVE_CHEST)) {
            this.removeEnchantments(chest);
        }
        if (feet != null && feet.func_77973_b().equals((Object)SArmor.DIVE_BOOTS)) {
            this.removeEnchantments(feet);
        }
        if (head != null && head.func_77973_b().equals((Object)SArmor.DIVE_HELMET) || head != null && head.func_77973_b().equals((Object)SArmor.DIVE_HELMET_LIGHTS) || chest != null && chest.func_77973_b().equals((Object)SArmor.DIVE_CHEST) || legs != null && legs.func_77973_b().equals((Object)SArmor.DIVE_LEGS) || feet != null && feet.func_77973_b().equals((Object)SArmor.DIVE_BOOTS)) {
            player.func_195064_c(new EffectInstance(Effects.field_76421_d, 2, 0, false, false));
            player.func_195064_c(new EffectInstance(Effects.field_76419_f, 2, 0, false, false));
            if (world.field_72995_K) {
                player.field_71075_bZ.func_195931_a(this.oldFlySpeed);
            }
            if (!player.func_175149_v() && !player.func_184812_l_()) {
                player.field_71075_bZ.field_75100_b = false;
            }
        }
    }

    private void repairTank(ItemStack chest, PlayerEntity player) {
        if (((Boolean)ConfigurationManager.GENERAL.consumeAir.get()).booleanValue() && chest.func_77973_b().equals((Object)SArmor.DIVE_CHEST) && chest.func_77952_i() < chest.func_77958_k()) {
            chest.func_222118_a(-(20 * (Integer)ConfigurationManager.GENERAL.regainAirSpeed.get()), (LivingEntity)player, null);
        }
    }

    private void damageTank(ItemStack chest, PlayerEntity player) {
        if (((Boolean)ConfigurationManager.GENERAL.consumeAir.get()).booleanValue() && chest.func_77973_b().equals((Object)SArmor.DIVE_CHEST) && chest.func_77952_i() < chest.func_77958_k() - 21) {
            chest.func_222118_a(20, (LivingEntity)player, null);
            player.func_70050_g(player.func_205010_bg());
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        PlayerEntity player = (PlayerEntity)entity;
        Block above = world.func_180495_p(new BlockPos(player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o() + 1, player.func_180425_c().func_177952_p())).func_177230_c();
        this.removeEnchantments(stack);
        if (!player.func_70090_H()) {
            this.repairTank(stack, player);
        } else if (player.func_70090_H() && above != Blocks.field_150355_j) {
            this.repairTank(stack, player);
        }
        if (!player.func_184812_l_() && !player.func_175149_v() && player.field_71075_bZ.field_75100_b) {
            NonNullList armorSlots = player.field_71071_by.field_70460_b;
            ItemStack head = (ItemStack)armorSlots.get(3);
            ItemStack chest = (ItemStack)armorSlots.get(2);
            ItemStack legs = (ItemStack)armorSlots.get(1);
            ItemStack feet = (ItemStack)armorSlots.get(0);
            if (legs != null && !legs.func_77973_b().equals((Object)SArmor.DIVE_LEGS) || feet != null && !feet.func_77973_b().equals((Object)SArmor.DIVE_BOOTS)) {
                if (world.field_72995_K) {
                    player.field_71075_bZ.func_195931_a(this.oldFlySpeed);
                }
                if (!player.func_175149_v() && !player.func_184812_l_()) {
                    player.field_71075_bZ.field_75100_b = false;
                }
            }
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        this.removeEnchantments(entity.func_92059_d());
        return false;
    }

    public void removeEnchantments(ItemStack stack) {
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (stack != null) {
            if (enchants.get(Enchantments.field_185298_f) != null) {
                enchants.remove(Enchantments.field_185298_f);
                EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)stack);
            }
            if (enchants.get(Enchantments.field_185299_g) != null) {
                enchants.remove(Enchantments.field_185299_g);
                EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)stack);
            }
            if (enchants.get(Enchantments.field_185300_i) != null) {
                enchants.remove(Enchantments.field_185300_i);
                EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)stack);
            }
        }
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "simpledivegear:textures/models/armor/divegear" + (slot == EquipmentSlotType.LEGS ? "_layer_2" : "_layer_1") + ".png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77973_b() == SArmor.DIVE_CHEST) {
            // empty if block
        }
    }
}

