/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.blocks;

import enemeez.simplefarming.init.ModItems;
import enemeez.simplefarming.tiles.BrewingBarrelTile;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BrewingBarrel
extends ContainerBlock {
    public static final IntegerProperty PROGRESS = IntegerProperty.func_177719_a((String)"progress", (int)0, (int)3);
    public static final IntegerProperty LAYERS = IntegerProperty.func_177719_a((String)"layers", (int)0, (int)1);

    public BrewingBarrel(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)LAYERS, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new BrewingBarrelTile();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{LAYERS, PROGRESS});
    }

    public int getProgress(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)PROGRESS);
    }

    public int getLayers(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS);
    }

    private boolean readyToFerment(BlockState state) {
        return this.getLayers(state) == 1;
    }

    public void reset(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_175656_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)LAYERS, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof BrewingBarrelTile) {
            if (player.func_70093_af() && this.getLayers(state) == 1 && this.getProgress(state) == 0) {
                this.dropItem(worldIn, pos);
                state = (BlockState)state.func_206870_a((IProperty)LAYERS, (Comparable)Integer.valueOf(0));
                worldIn.func_175656_a(pos, state);
                return true;
            }
            if (this.isAlcoholIngredient(player.func_184614_ca().func_77973_b()) && ((BrewingBarrelTile)tileentity).getCapacity() == 0) {
                this.insertItem((IWorld)worldIn, pos, state, player.func_184614_ca().func_77973_b());
                player.func_184614_ca().func_190918_g(1);
                state = (BlockState)state.func_206870_a((IProperty)LAYERS, (Comparable)Integer.valueOf(1));
                worldIn.func_175656_a(pos, state);
                return true;
            }
            if (player.func_184614_ca().func_77973_b() == Items.field_151069_bo && this.getProgress(state) == 3) {
                player.func_191521_c(new ItemStack((IItemProvider)this.getProduct(((BrewingBarrelTile)tileentity).getItem())));
                ((BrewingBarrelTile)tileentity).func_174888_l();
                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187630_M, SoundCategory.AMBIENT, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
                player.func_184614_ca().func_190918_g(1);
                this.reset(state, worldIn, pos);
                return true;
            }
        }
        return false;
    }

    public void insertItem(IWorld worldIn, BlockPos pos, BlockState state, Item item) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof BrewingBarrelTile && ((BrewingBarrelTile)tileentity).getCapacity() == 0) {
            ((BrewingBarrelTile)tileentity).setItem(item);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)LAYERS, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    private void dropItem(World worldIn, BlockPos pos) {
        TileEntity tileentity;
        if (!worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof BrewingBarrelTile) {
            BrewingBarrelTile tile = (BrewingBarrelTile)tileentity;
            Item item = tile.getItem();
            if (tile.getCapacity() > 0) {
                worldIn.func_217379_c(1010, pos, 0);
                tile.func_174888_l();
                double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
                double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                ItemStack itemstack1 = new ItemStack((IItemProvider)item);
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemstack1);
                itementity.func_174869_p();
                worldIn.func_217376_c((Entity)itementity);
            }
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropItem(worldIn, pos);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (this.readyToFerment(state)) {
            super.func_196267_b(state, worldIn, pos, random);
            int i = (Integer)state.func_177229_b((IProperty)PROGRESS);
            if (i < 3 && random.nextInt(5) == 0) {
                worldIn.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)LAYERS, (Comparable)Integer.valueOf(1))).func_206870_a((IProperty)PROGRESS, (Comparable)Integer.valueOf(i + 1)), 2);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.getProgress(stateIn) < 3 && this.getProgress(stateIn) > 0) {
            double d0 = (double)pos.func_177958_n() + Double.valueOf(Math.random());
            double d1 = (double)pos.func_177956_o() + Double.valueOf(Math.random());
            double d2 = (double)pos.func_177952_p() + Double.valueOf(Math.random());
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197608_a, d0, d1 + 1.0, d2, 0.0, 0.0, 0.0);
        }
    }

    public Item getProduct(Item itemIn) {
        Item[] recipes = new Item[]{Items.field_151015_O, ModItems.whiskey, ModItems.barley, ModItems.beer, Items.field_151174_bG, ModItems.vodka, ModItems.rice, ModItems.sake, Items.field_151034_e, ModItems.cider, ModItems.cactus_fruit, ModItems.tiswin, ModItems.cassava, ModItems.cauim, ModItems.grapes, ModItems.wine};
        for (int i = 0; i < recipes.length; ++i) {
            if (itemIn != recipes[i]) continue;
            return recipes[i + 1];
        }
        return Items.field_190931_a;
    }

    public boolean isAlcoholIngredient(Item itemIn) {
        Item[] ingredients = new Item[]{ModItems.barley, Items.field_151174_bG, ModItems.rice, Items.field_151034_e, ModItems.cactus_fruit, ModItems.cassava, ModItems.grapes, Items.field_151015_O};
        for (int i = 0; i < ingredients.length; ++i) {
            if (!itemIn.equals(ingredients[i])) continue;
            return true;
        }
        return false;
    }
}

