/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.world.gen.feature.tree;

import com.mojang.serialization.Codec;
import enemeez.simplefarming.config.GenConfig;
import enemeez.simplefarming.init.ModBlocks;
import enemeez.simplefarming.util.WorldGenHelper;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructureManager;

public class FruitTreeFeature
extends Feature<NoFeatureConfig> {
    public FruitTreeFeature(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    private static BlockState getLeaves(int verify) {
        switch (verify) {
            case 1: {
                return ModBlocks.apple_leaves.func_176223_P();
            }
            case 2: {
                return ModBlocks.apricot_leaves.func_176223_P();
            }
            case 3: {
                return ModBlocks.banana_leaves.func_176223_P();
            }
            case 4: {
                return ModBlocks.plum_leaves.func_176223_P();
            }
            case 5: {
                return ModBlocks.orange_leaves.func_176223_P();
            }
            case 6: {
                return ModBlocks.pear_leaves.func_176223_P();
            }
            case 7: {
                return ModBlocks.cherry_leaves.func_176223_P();
            }
            case 8: {
                return ModBlocks.mango_leaves.func_176223_P();
            }
        }
        return ModBlocks.olive_leaves.func_176223_P();
    }

    public boolean func_230362_a_(ISeedReader world, StructureManager structure, ChunkGenerator chunk, Random random, BlockPos pos, NoFeatureConfig config) {
        if (random.nextInt((Integer)GenConfig.tree_chance.get()) != 0) {
            return false;
        }
        if (WorldGenHelper.isValidGround(world.func_180495_p(pos.func_177977_b()), (IBlockReader)world, pos) && world.func_180495_p(pos).func_185904_a().func_76222_j()) {
            int type = random.nextInt(9) + 1;
            FruitTreeFeature.generateTree((IWorld)world, pos, random, type);
            return true;
        }
        return false;
    }

    public static void generateTree(IWorld world, BlockPos pos, Random random, int verify) {
        int x;
        BlockState trunk = ModBlocks.fruit_log.func_176223_P();
        BlockState leaves = FruitTreeFeature.getLeaves(verify);
        for (int y = 0; y < 4; ++y) {
            if (!world.func_180495_p(pos.func_177981_b(y)).func_185904_a().func_76222_j() && y != 0) continue;
            world.func_180501_a(pos.func_177981_b(y), trunk, 3);
        }
        for (x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (!world.func_180495_p(pos.func_177981_b(3).func_177982_a(x, 0, z)).func_185904_a().func_76222_j()) continue;
                world.func_180501_a(pos.func_177981_b(3).func_177982_a(x, 0, z), leaves, 3);
            }
        }
        for (x = -1; x < 2; ++x) {
            if (x != 0) {
                if (!world.func_180495_p(pos.func_177981_b(2).func_177982_a(x, 0, 0)).func_185904_a().func_76222_j()) continue;
                world.func_180501_a(pos.func_177981_b(2).func_177982_a(x, 0, 0), leaves, 3);
                continue;
            }
            if (world.func_180495_p(pos.func_177981_b(2).func_177982_a(x, 0, 1)).func_185904_a().func_76222_j()) {
                world.func_180501_a(pos.func_177981_b(2).func_177982_a(x, 0, 1), leaves, 3);
            }
            if (!world.func_180495_p(pos.func_177981_b(2).func_177982_a(x, 0, -1)).func_185904_a().func_76222_j()) continue;
            world.func_180501_a(pos.func_177981_b(2).func_177982_a(x, 0, -1), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(4)).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(4), leaves, 3);
        }
    }
}

