/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.dynamic.StatusModelData;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStandardDrawers
extends BlockDrawers {
    public static final PropertyEnum<EnumBasicDrawer> BLOCK = PropertyEnum.func_177709_a((String)"block", EnumBasicDrawer.class);
    @SideOnly(value=Side.CLIENT)
    private StatusModelData[] statusInfo;

    public BlockStandardDrawers(String blockName) {
        super(Material.field_151575_d, blockName);
    }

    @Override
    protected void initDefaultState() {
        super.initDefaultState();
        this.func_180632_j(this.func_176223_P().func_177226_a(BLOCK, (Comparable)((Object)EnumBasicDrawer.FULL2)));
    }

    @Override
    public int getDrawerCount(IBlockState state) {
        EnumBasicDrawer info;
        if (state != null && state.func_177230_c() instanceof BlockDrawers && (info = (EnumBasicDrawer)((Object)state.func_177229_b(BLOCK))) != null) {
            return info.getDrawerCount();
        }
        return 0;
    }

    @Override
    public boolean isHalfDepth(IBlockState state) {
        EnumBasicDrawer info;
        if (state != null && state.func_177230_c() instanceof BlockDrawers && (info = (EnumBasicDrawer)((Object)state.func_177229_b(BLOCK))) != null) {
            return info.isHalfDepth();
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initDynamic() {
        this.statusInfo = new StatusModelData[EnumBasicDrawer.values().length];
        for (EnumBasicDrawer type : EnumBasicDrawer.values()) {
            ResourceLocation location = new ResourceLocation("StorageDrawers:models/dynamic/basicDrawers_" + type.func_176610_l() + ".json");
            this.statusInfo[type.getMetadata()] = new StatusModelData(type.getDrawerCount(), location);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public StatusModelData getStatusInfo(IBlockState state) {
        EnumBasicDrawer info;
        if (state != null && (info = (EnumBasicDrawer)((Object)state.func_177229_b(BLOCK))) != null) {
            return this.statusInfo[info.getMetadata()];
        }
        return null;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.func_149662_c(state);
    }

    public boolean func_149662_c(IBlockState state) {
        try {
            switch ((EnumBasicDrawer)((Object)state.func_177229_b(BLOCK))) {
                case FULL1: 
                case FULL2: 
                case FULL4: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        switch ((EnumBasicDrawer)((Object)state.func_177229_b(BLOCK))) {
            case FULL1: 
            case FULL2: 
            case FULL4: {
                return true;
            }
        }
        TileEntityDrawers tile = this.getTileEntity(world, pos);
        return tile != null && tile.getDirection() == face.func_176734_d().func_176745_a();
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        switch ((EnumBasicDrawer)((Object)blockState.func_177229_b(BLOCK))) {
            case FULL1: 
            case FULL2: 
            case FULL4: {
                return super.func_176225_a(blockState, blockAccess, pos, side);
            }
        }
        TileEntityDrawers tile = this.getTileEntity(blockAccess, pos);
        if (tile != null && tile.getDirection() == side.func_176745_a()) {
            return true;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean func_176214_u() {
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(BLOCK, (Comparable)((Object)EnumBasicDrawer.byMetadata(meta)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BLOCK, (Comparable)((Object)EnumBasicDrawer.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBasicDrawer)((Object)state.func_177229_b(BLOCK))).getMetadata();
    }

    @Override
    protected int getDrawerSlot(int drawerCount, int side, float hitX, float hitY, float hitZ) {
        if (drawerCount == 1) {
            return 0;
        }
        if (drawerCount == 2) {
            return this.hitTop(hitY) ? 0 : 1;
        }
        if (this.hitLeft(side, hitX, hitZ)) {
            return this.hitTop(hitY) ? 0 : 1;
        }
        return this.hitTop(hitY) ? 2 : 3;
    }

    public TileEntityDrawers createNewTileEntity(World world, int meta) {
        IBlockState state = this.func_176203_a(meta);
        EnumBasicDrawer type = (EnumBasicDrawer)((Object)state.func_177229_b(BLOCK));
        return new TileEntityDrawersStandard(type.getDrawerCount());
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{BLOCK, FACING}, new IUnlistedProperty[]{STATE_MODEL});
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos).func_177226_a(BLOCK, state.func_177229_b(BLOCK));
    }
}

