/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.EnumKeyType;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityKeyButton;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockKeyButton
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyEnum<EnumKeyType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumKeyType.class);
    private static final double U3 = 0.1875;
    private static final double U13 = 0.8125;
    protected static final AxisAlignedBB AABB_DOWN_OFF = new AxisAlignedBB(0.1875, 0.875, 0.1875, 0.8125, 1.0, 0.8125);
    protected static final AxisAlignedBB AABB_UP_OFF = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125);
    protected static final AxisAlignedBB AABB_NORTH_OFF = new AxisAlignedBB(0.1875, 0.1875, 0.875, 0.8125, 0.8125, 1.0);
    protected static final AxisAlignedBB AABB_SOUTH_OFF = new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 0.125);
    protected static final AxisAlignedBB AABB_WEST_OFF = new AxisAlignedBB(0.875, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);
    protected static final AxisAlignedBB AABB_EAST_OFF = new AxisAlignedBB(0.0, 0.1875, 0.1875, 0.125, 0.8125, 0.8125);
    protected static final AxisAlignedBB AABB_DOWN_ON = new AxisAlignedBB(0.1875, 0.937, 0.1875, 0.8125, 1.0, 0.8125);
    protected static final AxisAlignedBB AABB_UP_ON = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.0625, 0.8125);
    protected static final AxisAlignedBB AABB_NORTH_ON = new AxisAlignedBB(0.1875, 0.1875, 0.937, 0.8125, 0.8125, 1.0);
    protected static final AxisAlignedBB AABB_SOUTH_ON = new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 0.0625);
    protected static final AxisAlignedBB AABB_WEST_ON = new AxisAlignedBB(0.937, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);
    protected static final AxisAlignedBB AABB_EAST_ON = new AxisAlignedBB(0.0, 0.1875, 0.1875, 0.0625, 0.8125, 0.8125);

    public BlockKeyButton(String registryName, String blockName) {
        super(Material.field_151594_q);
        this.func_149711_c(5.0f);
        this.func_149663_c(blockName);
        this.setRegistryName(registryName);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(ModCreativeTabs.tabStorageDrawers);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a(VARIANT, (Comparable)((Object)EnumKeyType.DRAWER)));
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public int func_149738_a(World worldIn) {
        return 5;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return BlockKeyButton.canPlaceBlock(worldIn, pos, side.func_176734_d());
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.values()) {
            if (!BlockKeyButton.canPlaceBlock(worldIn, pos, facing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canPlaceBlock(World world, BlockPos pos, EnumFacing facing) {
        BlockPos blockPos = pos.func_177972_a(facing);
        return world.func_180495_p(blockPos).isSideSolid((IBlockAccess)world, blockPos, facing.func_176734_d());
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (BlockKeyButton.canPlaceBlock(world, pos, facing.func_176734_d())) {
            return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        TileEntityKeyButton tile = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tile != null) {
            tile.setDirection((EnumFacing)state.func_177229_b((IProperty)FACING));
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.checkForDrop(worldIn, pos, state = this.func_176221_a(state, (IBlockAccess)worldIn, pos)) && !BlockKeyButton.canPlaceBlock(worldIn, pos, ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d())) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private boolean checkForDrop(World world, BlockPos pos, IBlockState state) {
        if (this.func_176196_c(world, pos)) {
            return true;
        }
        this.func_176226_b(world, pos, state, 0);
        world.func_175698_g(pos);
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boolean powered = (Boolean)state.func_177229_b((IProperty)POWERED);
        switch (facing) {
            case EAST: {
                return powered ? AABB_EAST_ON : AABB_EAST_OFF;
            }
            case WEST: {
                return powered ? AABB_WEST_ON : AABB_WEST_OFF;
            }
            case SOUTH: {
                return powered ? AABB_SOUTH_ON : AABB_SOUTH_OFF;
            }
            case NORTH: {
                return powered ? AABB_NORTH_ON : AABB_NORTH_OFF;
            }
            case UP: {
                return powered ? AABB_UP_ON : AABB_UP_OFF;
            }
            case DOWN: {
                return powered ? AABB_DOWN_ON : AABB_DOWN_OFF;
            }
        }
        return field_185506_k;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((Boolean)(state = this.func_176221_a(state, (IBlockAccess)worldIn, pos)).func_177229_b((IProperty)POWERED)).booleanValue()) {
            return true;
        }
        TileEntityKeyButton tile = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tile != null) {
            tile.setPowered(true);
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        worldIn.func_175704_b(pos, pos);
        worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
        this.notifyNeighbors(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING));
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        BlockPos targetPos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d());
        Block target = worldIn.func_180495_p(targetPos).func_177230_c();
        if (target instanceof BlockController) {
            BlockController controller = (BlockController)target;
            controller.toggle(worldIn, targetPos, playerIn, (EnumKeyType)((Object)state.func_177229_b(VARIANT)));
        } else if (target instanceof BlockSlave) {
            BlockSlave slave = (BlockSlave)target;
            slave.toggle(worldIn, targetPos, playerIn, (EnumKeyType)((Object)state.func_177229_b(VARIANT)));
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)(state = this.func_176221_a(state, (IBlockAccess)worldIn, pos)).func_177229_b((IProperty)POWERED)).booleanValue()) {
            this.notifyNeighbors(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING));
        }
        worldIn.func_175713_t(pos);
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tile = worldIn.func_175625_s(pos);
        return tile != null && tile.func_145842_c(id, param);
    }

    @Nonnull
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityKeyButton();
    }

    public TileEntityKeyButton getTileEntity(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        return tile instanceof TileEntityKeyButton ? (TileEntityKeyButton)tile : null;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)(blockState = this.func_176221_a(blockState, blockAccess, pos)).func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)(blockState = this.func_176221_a(blockState, blockAccess, pos)).func_177229_b((IProperty)POWERED) == false ? 0 : (blockState.func_177229_b((IProperty)FACING) == side ? 15 : 0);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        if (worldIn.field_72995_K || !((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return;
        }
        TileEntityKeyButton tile = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tile != null) {
            tile.setPowered(false);
        }
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.notifyNeighbors(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING));
        worldIn.func_184133_a(null, pos, SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.3f, 0.5f);
        worldIn.func_175704_b(pos, pos);
    }

    private void notifyNeighbors(World worldIn, BlockPos pos, EnumFacing facing) {
        worldIn.func_175685_c(pos, (Block)this, false);
        worldIn.func_175685_c(pos.func_177972_a(facing.func_176734_d()), (Block)this, false);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED, VARIANT});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityKeyButton tile = this.getTileEntity(worldIn, pos);
        if (tile == null) {
            return state;
        }
        return state.func_177226_a((IProperty)FACING, (Comparable)tile.getDirection()).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(tile.isPowered()));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumKeyType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumKeyType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumKeyType type : EnumKeyType.values()) {
            list.add((Object)new ItemStack(item, 1, type.getMetadata()));
        }
    }
}

