/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.IPriorityGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.ISmartGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IItemLockable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IQuantifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IShroudable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IVoidable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntitySlave;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.inventory.DrawerItemHandler;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import com.jaquadro.minecraft.storagedrawers.util.ItemMetaCollectionRegistry;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.logging.log4j.Level;

public class TileEntityController
extends TileEntity
implements IDrawerGroup,
IPriorityGroup,
ISmartGroup {
    private static final int PRI_LOCKED = 0;
    private static final int PRI_LOCKED_VOID = 1;
    private static final int PRI_NORMAL = 2;
    private static final int PRI_VOID = 3;
    private static final int PRI_EMPTY = 4;
    private static final int PRI_LOCKED_EMPTY = 5;
    private static final int PRI_DISABLED = 6;
    private Queue<BlockPos> searchQueue = new LinkedList<BlockPos>();
    private Set<BlockPos> searchDiscovered = new HashSet<BlockPos>();
    private Comparator<SlotRecord> slotRecordComparator = new Comparator<SlotRecord>(){

        @Override
        public int compare(SlotRecord o1, SlotRecord o2) {
            return o1.priority - o2.priority;
        }
    };
    private Map<BlockPos, StorageRecord> storage = new HashMap<BlockPos, StorageRecord>();
    protected List<SlotRecord> drawerSlotList = new ArrayList<SlotRecord>();
    private ItemMetaCollectionRegistry<SlotRecord> drawerPrimaryLookup = new ItemMetaCollectionRegistry();
    protected int[] drawerSlots = new int[0];
    private int range;
    private long lastUpdateTime;
    private long lastClickTime;
    private UUID lastClickUUID;
    private DrawerItemHandler itemHandler = new DrawerItemHandler(this);

    private int getSlotPriority(SlotRecord record) {
        IDrawerGroup group = this.getGroupForSlotRecord(record);
        if (group == null) {
            return 6;
        }
        int drawerSlot = record.slot;
        IDrawer drawer = group.getDrawerIfEnabled(drawerSlot);
        if (drawer == null) {
            return 6;
        }
        if (drawer.isEmpty()) {
            if (drawer instanceof IItemLockable && ((IItemLockable)((Object)drawer)).isItemLocked(LockAttribute.LOCK_EMPTY) || group instanceof IItemLockable && ((IItemLockable)((Object)group)).isItemLocked(LockAttribute.LOCK_EMPTY)) {
                return 5;
            }
            return 4;
        }
        if (drawer instanceof IVoidable && ((IVoidable)((Object)drawer)).isVoid() || group instanceof IVoidable && ((IVoidable)((Object)group)).isVoid()) {
            if (drawer instanceof IItemLockable && ((IItemLockable)((Object)drawer)).isItemLocked(LockAttribute.LOCK_POPULATED) || group instanceof IItemLockable && ((IItemLockable)((Object)group)).isItemLocked(LockAttribute.LOCK_POPULATED)) {
                return 1;
            }
            return 3;
        }
        if (drawer instanceof IItemLockable && ((IItemLockable)((Object)drawer)).isItemLocked(LockAttribute.LOCK_POPULATED) || group instanceof IItemLockable && ((IItemLockable)((Object)group)).isItemLocked(LockAttribute.LOCK_POPULATED)) {
            return 0;
        }
        return 2;
    }

    public TileEntityController() {
        this.range = StorageDrawers.config.getControllerRange();
    }

    public void printDebugInfo() {
        FMLLog.log((String)"storagedrawers", (Level)Level.INFO, (String)("Controller at " + this.field_174879_c.toString()), (Object[])new Object[0]);
        FMLLog.log((String)"storagedrawers", (Level)Level.INFO, (String)("  Range: " + this.range + " blocks"), (Object[])new Object[0]);
        FMLLog.log((String)"storagedrawers", (Level)Level.INFO, (String)("  Stored records: " + this.storage.size() + ", slot list: " + this.drawerSlots.length), (Object[])new Object[0]);
        FMLLog.log((String)"storagedrawers", (Level)Level.INFO, (String)("  Ticks since last update: " + (this.func_145831_w().func_82737_E() - this.lastUpdateTime)), (Object[])new Object[0]);
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.func_145831_w().func_184145_b(this.func_174877_v(), (Block)ModBlocks.controller)) {
            this.func_145831_w().func_175684_a(this.func_174877_v(), (Block)ModBlocks.controller, 1);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public int interactPutItemsIntoInventory(EntityPlayer player) {
        boolean dumpInventory = this.func_145831_w().func_82737_E() - this.lastClickTime < 10L && player.getPersistentID().equals(this.lastClickUUID);
        int count = 0;
        if (!dumpInventory) {
            ItemStack currentStack = player.field_71071_by.func_70448_g();
            if (!currentStack.func_190926_b()) {
                count = this.insertItems(currentStack, player.func_146103_bH());
                if (currentStack.func_190916_E() == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
            }
        } else {
            int n = player.field_71071_by.func_70302_i_();
            for (int i = 0; i < n; ++i) {
                ItemStack subStack = player.field_71071_by.func_70301_a(i);
                if (subStack.func_190926_b()) continue;
                count += this.insertItems(subStack, player.func_146103_bH());
                if (subStack.func_190916_E() != 0) continue;
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
            if (count > 0) {
                StorageDrawers.proxy.updatePlayerInventory(player);
            }
        }
        this.lastClickTime = this.func_145831_w().func_82737_E();
        this.lastClickUUID = player.getPersistentID();
        return count;
    }

    protected int insertItems(@Nonnull ItemStack stack, GameProfile profile) {
        int itemsLeft = stack.func_190916_E();
        for (int slot : this.enumerateDrawersForInsertion(stack, false)) {
            IDrawerGroup group = this.getGroupForDrawerSlot(slot);
            if (group instanceof IProtectable && !SecurityManager.hasAccess(profile, (IProtectable)((Object)group))) continue;
            IDrawer drawer = this.getDrawer(slot);
            if (drawer.isEmpty()) break;
            itemsLeft = this.insertItemsIntoDrawer(drawer, itemsLeft);
            if (drawer instanceof IVoidable && ((IVoidable)((Object)drawer)).isVoid()) {
                itemsLeft = 0;
            }
            if (itemsLeft != 0) continue;
            break;
        }
        int count = stack.func_190916_E() - itemsLeft;
        stack.func_190920_e(itemsLeft);
        return count;
    }

    protected int insertItemsIntoDrawer(IDrawer drawer, int itemCount) {
        IFractionalDrawer fracDrawer;
        int capacity = drawer.getMaxCapacity();
        int storedItems = drawer.getStoredItemCount();
        int storableItems = capacity - storedItems;
        if (drawer instanceof IFractionalDrawer && !(fracDrawer = (IFractionalDrawer)drawer).isSmallestUnit() && fracDrawer.getStoredItemRemainder() > 0) {
            --storableItems;
        }
        if (storableItems == 0) {
            return itemCount;
        }
        int remainder = Math.max(itemCount - storableItems, 0);
        drawer.setStoredItemCount(storedItems += Math.min(itemCount, storableItems));
        return remainder;
    }

    public void toggleProtection(GameProfile profile, ISecurityProvider provider) {
        IProtectable template = null;
        UUID state = null;
        for (StorageRecord record : this.storage.values()) {
            IProtectable protectable;
            if (record.storage == null || !(record.storage instanceof IProtectable) || !SecurityManager.hasOwnership(profile, protectable = (IProtectable)((Object)record.storage))) continue;
            if (template == null) {
                template = protectable;
                if (template.getOwner() == null) {
                    state = profile.getId();
                } else {
                    state = null;
                    provider = null;
                }
            }
            protectable.setOwner(state);
            protectable.setSecurityProvider(provider);
        }
    }

    public void toggleShroud(GameProfile profile) {
        Boolean template = null;
        boolean state = false;
        for (StorageRecord record : this.storage.values()) {
            if (record.storage == null || record.storage instanceof IProtectable && !SecurityManager.hasAccess(profile, (IProtectable)((Object)record.storage))) continue;
            int n = record.storage.getDrawerCount();
            for (int i = 0; i < n; ++i) {
                IDrawer drawer = record.storage.getDrawerIfEnabled(i);
                if (!(drawer instanceof IShroudable)) continue;
                IShroudable shroudableStorage = (IShroudable)((Object)drawer);
                if (template == null) {
                    template = shroudableStorage.isShrouded();
                    state = template == false;
                }
                shroudableStorage.setIsShrouded(state);
            }
        }
    }

    public void toggleQuantified(GameProfile profile) {
        Boolean template = null;
        boolean state = false;
        for (StorageRecord record : this.storage.values()) {
            if (record.storage == null || record.storage instanceof IProtectable && !SecurityManager.hasAccess(profile, (IProtectable)((Object)record.storage))) continue;
            int n = record.storage.getDrawerCount();
            for (int i = 0; i < n; ++i) {
                IDrawer drawer = record.storage.getDrawerIfEnabled(i);
                if (!(drawer instanceof IQuantifiable)) continue;
                IQuantifiable quantifiableStorage = (IQuantifiable)((Object)drawer);
                if (template == null) {
                    template = quantifiableStorage.isShowingQuantity();
                    state = template == false;
                }
                quantifiableStorage.setIsShowingQuantity(state);
            }
        }
    }

    public void toggleLock(EnumSet<LockAttribute> attributes, LockAttribute key, GameProfile profile) {
        Boolean template = null;
        boolean state = false;
        for (StorageRecord record : this.storage.values()) {
            if (record.storage == null || record.storage instanceof IProtectable && !SecurityManager.hasAccess(profile, (IProtectable)((Object)record.storage))) continue;
            if (record.storage instanceof IItemLockable) {
                IItemLockable lockableStorage = (IItemLockable)((Object)record.storage);
                if (template == null) {
                    template = lockableStorage.isItemLocked(key);
                    state = template == false;
                }
                for (LockAttribute attr : attributes) {
                    lockableStorage.setItemLocked(attr, state);
                }
                continue;
            }
            int n = record.storage.getDrawerCount();
            for (int i = 0; i < n; ++i) {
                IDrawer drawer = record.storage.getDrawerIfEnabled(i);
                if (!(drawer instanceof IShroudable)) continue;
                IItemLockable lockableStorage = (IItemLockable)((Object)drawer);
                if (template == null) {
                    template = lockableStorage.isItemLocked(key);
                    state = template == false;
                }
                for (LockAttribute attr : attributes) {
                    lockableStorage.setItemLocked(attr, state);
                }
            }
        }
    }

    protected void resetCache() {
        this.storage.clear();
        this.drawerSlotList.clear();
    }

    public boolean isValidSlave(BlockPos coord) {
        StorageRecord record = this.storage.get(coord);
        if (record == null || !record.mark) {
            return false;
        }
        return record.storage == null;
    }

    public void updateCache() {
        this.lastUpdateTime = this.func_145831_w().func_82737_E();
        int preCount = this.drawerSlots.length;
        this.resetCache();
        this.populateNodes(this.func_174877_v());
        this.flattenLists();
        this.drawerSlots = this.sortSlotRecords(this.drawerSlotList);
        this.rebuildPrimaryLookup(this.drawerPrimaryLookup, this.drawerSlotList);
        if (!(preCount == this.drawerSlots.length || preCount != 0 && this.drawerSlots.length != 0 || this.func_145831_w().field_72995_K)) {
            this.func_70296_d();
        }
    }

    private void indexSlotRecords(List<SlotRecord> records) {
        int n = records.size();
        for (int i = 0; i < n; ++i) {
            SlotRecord record = records.get(i);
            if (record == null) continue;
            record.index = i;
            record.priority = this.getSlotPriority(record);
        }
    }

    private int[] sortSlotRecords(List<SlotRecord> records) {
        this.indexSlotRecords(records);
        ArrayList<SlotRecord> copied = new ArrayList<SlotRecord>(records);
        Collections.sort(copied, this.slotRecordComparator);
        int[] slotMap = new int[copied.size()];
        for (int i = 0; i < slotMap.length; ++i) {
            slotMap[i] = ((SlotRecord)copied.get((int)i)).index;
        }
        return slotMap;
    }

    private void rebuildPrimaryLookup(ItemMetaCollectionRegistry<SlotRecord> lookup, List<SlotRecord> records) {
        lookup.clear();
        for (SlotRecord record : records) {
            int drawerSlot;
            IDrawer drawer;
            IDrawerGroup group = this.getGroupForSlotRecord(record);
            if (group == null || (drawer = group.getDrawerIfEnabled(drawerSlot = record.slot)) == null || drawer.isEmpty()) continue;
            ItemStack item = drawer.getStoredItemPrototype();
            lookup.register(item.func_77973_b(), item.func_77952_i(), record);
        }
    }

    private boolean containsNullEntries(List<SlotRecord> list) {
        int nullCount = 0;
        for (SlotRecord aList : list) {
            if (aList != null) continue;
            ++nullCount;
        }
        return nullCount > 0;
    }

    private void flattenLists() {
        if (this.containsNullEntries(this.drawerSlotList)) {
            ArrayList<SlotRecord> newDrawerSlotList = new ArrayList<SlotRecord>();
            for (SlotRecord record : this.drawerSlotList) {
                if (record == null) continue;
                newDrawerSlotList.add(record);
            }
            this.drawerSlotList = newDrawerSlotList;
        }
    }

    private void clearRecordInfo(BlockPos coord, StorageRecord record) {
        record.clear();
        for (int i = 0; i < this.drawerSlotList.size(); ++i) {
            SlotRecord slotRecord = this.drawerSlotList.get(i);
            if (slotRecord == null || !coord.equals((Object)slotRecord.coord)) continue;
            this.drawerSlotList.set(i, null);
        }
    }

    private void updateRecordInfo(BlockPos coord, StorageRecord record, TileEntity te) {
        if (te == null) {
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            return;
        }
        if (te instanceof TileEntityController) {
            if (record.storage == null && record.invStorageSize > 0) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = null;
        } else if (te instanceof TileEntitySlave) {
            if (record.storage == null && record.invStorageSize == 0 && ((TileEntitySlave)te).getController() == this) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = null;
            ((TileEntitySlave)te).bindController(this.func_174877_v());
        } else if (te instanceof IDrawerGroup) {
            IDrawerGroup group = (IDrawerGroup)te;
            if (record.storage == group) {
                return;
            }
            if (record.storage != null && record.storage != group) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = group;
            record.drawerStorageSize = group.getDrawerCount();
            int n = record.drawerStorageSize;
            for (int i = 0; i < n; ++i) {
                this.drawerSlotList.add(new SlotRecord(group, coord, i));
            }
        } else if (record.storage != null) {
            this.clearRecordInfo(coord, record);
        }
    }

    private void populateNodes(BlockPos root) {
        this.searchQueue.clear();
        this.searchQueue.add(root);
        this.searchDiscovered.clear();
        this.searchDiscovered.add(root);
        while (!this.searchQueue.isEmpty()) {
            BlockPos[] neighbors;
            Block block;
            BlockPos coord = this.searchQueue.remove();
            int depth = Math.max(Math.max(Math.abs(coord.func_177958_n() - root.func_177958_n()), Math.abs(coord.func_177956_o() - root.func_177956_o())), Math.abs(coord.func_177952_p() - root.func_177952_p()));
            if (depth > this.range || !((block = this.func_145831_w().func_180495_p(coord).func_177230_c()) instanceof INetworked)) continue;
            StorageRecord record = this.storage.get(coord);
            if (record == null) {
                record = new StorageRecord();
                this.storage.put(coord, record);
            }
            if (block instanceof BlockSlave) {
                ((BlockSlave)block).getTileEntitySafe(this.func_145831_w(), coord);
            }
            this.updateRecordInfo(coord, record, this.func_145831_w().func_175625_s(coord));
            record.mark = true;
            record.distance = depth;
            for (BlockPos n : neighbors = new BlockPos[]{coord.func_177976_e(), coord.func_177974_f(), coord.func_177968_d(), coord.func_177978_c(), coord.func_177984_a(), coord.func_177977_b()}) {
                if (this.searchDiscovered.contains(n)) continue;
                this.searchQueue.add(n);
                this.searchDiscovered.add(n);
            }
        }
    }

    protected IDrawerGroup getGroupForDrawerSlot(int drawerSlot) {
        if (drawerSlot < 0 || drawerSlot >= this.drawerSlotList.size()) {
            return null;
        }
        SlotRecord record = this.drawerSlotList.get(drawerSlot);
        if (record == null) {
            return null;
        }
        return this.getGroupForSlotRecord(record);
    }

    protected IDrawerGroup getGroupForSlotRecord(SlotRecord record) {
        TileEntity tile;
        IDrawerGroup group = record.group;
        if (group == null) {
            return null;
        }
        if (group instanceof TileEntity && ((tile = (TileEntity)group).func_145837_r() || !tile.func_174877_v().equals((Object)record.coord))) {
            record.group = null;
            return null;
        }
        return group;
    }

    private int getLocalDrawerSlot(int drawerSlot) {
        if (drawerSlot >= this.drawerSlotList.size()) {
            return 0;
        }
        SlotRecord record = this.drawerSlotList.get(drawerSlot);
        if (record == null) {
            return 0;
        }
        return record.slot;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            this.updateCache();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        return tag;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        if (this.func_145831_w().field_72995_K) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    @Override
    public int getDrawerCount() {
        return this.drawerSlotList.size();
    }

    @Override
    public IDrawer getDrawer(int slot) {
        IDrawerGroup group = this.getGroupForDrawerSlot(slot);
        if (group == null) {
            return null;
        }
        return group.getDrawer(this.getLocalDrawerSlot(slot));
    }

    @Override
    public boolean isDrawerEnabled(int slot) {
        IDrawerGroup group = this.getGroupForDrawerSlot(slot);
        if (group == null) {
            return false;
        }
        return group.isDrawerEnabled(this.getLocalDrawerSlot(slot));
    }

    @Override
    public IDrawer getDrawerIfEnabled(int slot) {
        IDrawerGroup group = this.getGroupForDrawerSlot(slot);
        if (group == null) {
            return null;
        }
        int localSlot = this.getLocalDrawerSlot(slot);
        return group.getDrawerIfEnabled(localSlot);
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        return this.drawerSlots;
    }

    public void func_70296_d() {
        for (StorageRecord record : this.storage.values()) {
            IDrawerGroup group = record.storage;
            if (group == null) continue;
            group.markDirtyIfNeeded();
        }
        super.func_70296_d();
    }

    @Override
    public boolean markDirtyIfNeeded() {
        boolean synced = false;
        for (StorageRecord record : this.storage.values()) {
            IDrawerGroup group = record.storage;
            if (group == null) continue;
            synced |= group.markDirtyIfNeeded();
        }
        if (synced) {
            super.func_70296_d();
        }
        return synced;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public Iterable<Integer> enumerateDrawersForInsertion(@Nonnull ItemStack stack, boolean strict) {
        return new DrawerStackIterator(stack, strict, true);
    }

    @Override
    public Iterable<Integer> enumerateDrawersForExtraction(@Nonnull ItemStack stack, boolean strict) {
        return new DrawerStackIterator(stack, strict, false);
    }

    private class DrawerStackIterator
    implements Iterable<Integer> {
        @Nonnull
        private ItemStack stack;
        private boolean strict;
        private boolean insert;

        public DrawerStackIterator(ItemStack stack, boolean strict, boolean insert) {
            this.stack = stack;
            this.strict = strict;
            this.insert = insert;
        }

        @Override
        public Iterator<Integer> iterator() {
            if (this.stack == null) {
                return new ArrayList(0).iterator();
            }
            return new Iterator<Integer>(){
                Collection<SlotRecord> primaryRecords;
                Iterator<SlotRecord> iter1;
                int index2;
                Integer nextSlot;
                {
                    this.primaryRecords = TileEntityController.this.drawerPrimaryLookup.getEntries(DrawerStackIterator.this.stack.func_77973_b(), DrawerStackIterator.this.stack.func_77952_i());
                    this.nextSlot = null;
                }

                @Override
                public boolean hasNext() {
                    if (this.nextSlot == null) {
                        this.advance();
                    }
                    return this.nextSlot != null;
                }

                @Override
                public Integer next() {
                    if (this.nextSlot == null) {
                        this.advance();
                    }
                    Integer slot = this.nextSlot;
                    this.nextSlot = null;
                    return slot;
                }

                private void advance() {
                    if (this.iter1 == null && this.primaryRecords != null && this.primaryRecords.size() > 0) {
                        this.iter1 = this.primaryRecords.iterator();
                    }
                    if (this.iter1 != null) {
                        while (this.iter1.hasNext()) {
                            int slot;
                            SlotRecord candidate = this.iter1.next();
                            IDrawerGroup candidateGroup = TileEntityController.this.getGroupForSlotRecord(candidate);
                            if (candidateGroup == null) continue;
                            IDrawer drawer = candidateGroup.getDrawer(candidate.slot);
                            if (DrawerStackIterator.this.insert) {
                                boolean voiding;
                                boolean bl = voiding = drawer instanceof IVoidable ? ((IVoidable)((Object)drawer)).isVoid() : false;
                                if (!drawer.canItemBeStored(DrawerStackIterator.this.stack) || !drawer.isEmpty() && drawer.getRemainingCapacity() <= 0 && !voiding) {
                                    continue;
                                }
                            } else if (!drawer.canItemBeExtracted(DrawerStackIterator.this.stack) || drawer.getStoredItemCount() <= 0) continue;
                            if ((slot = TileEntityController.this.drawerSlotList.indexOf(candidate)) <= -1) continue;
                            this.nextSlot = slot;
                            return;
                        }
                    }
                    while (this.index2 < TileEntityController.this.drawerSlots.length) {
                        block12: {
                            int slot;
                            block14: {
                                IDrawer drawer;
                                block13: {
                                    boolean voiding;
                                    ItemStack proto;
                                    slot = TileEntityController.this.drawerSlots[this.index2];
                                    drawer = TileEntityController.this.getDrawerIfEnabled(slot);
                                    if (drawer == null || DrawerStackIterator.this.strict && !(proto = drawer.getStoredItemPrototype()).func_77969_a(DrawerStackIterator.this.stack)) break block12;
                                    if (!DrawerStackIterator.this.insert) break block13;
                                    boolean bl = voiding = drawer instanceof IVoidable ? ((IVoidable)((Object)drawer)).isVoid() : false;
                                    if (drawer.canItemBeStored(DrawerStackIterator.this.stack) && (drawer.isEmpty() || drawer.getRemainingCapacity() > 0 || voiding)) break block14;
                                    break block12;
                                }
                                if (!drawer.canItemBeExtracted(DrawerStackIterator.this.stack) || drawer.getStoredItemCount() <= 0) break block12;
                            }
                            SlotRecord record = TileEntityController.this.drawerSlotList.get(slot);
                            if (this.primaryRecords == null || !this.primaryRecords.contains(record)) {
                                this.nextSlot = slot;
                                ++this.index2;
                                return;
                            }
                        }
                        ++this.index2;
                    }
                }
            };
        }
    }

    protected static class SlotRecord
    implements Comparable<SlotRecord> {
        public BlockPos coord;
        public IDrawerGroup group;
        public int slot;
        public int index;
        public int priority;

        public SlotRecord(IDrawerGroup group, BlockPos coord, int slot) {
            this.group = group;
            this.coord = coord;
            this.slot = slot;
        }

        @Override
        public int compareTo(SlotRecord other) {
            int diff = this.priority - other.priority;
            if (diff == 0) {
                diff = this.coord.compareTo((Vec3i)other.coord);
                if (diff == 0) {
                    return this.index - other.index;
                }
                return diff;
            }
            return diff;
        }
    }

    private static class StorageRecord {
        public IDrawerGroup storage;
        public boolean mark;
        public int invStorageSize;
        public int drawerStorageSize;
        public int distance = Integer.MAX_VALUE;

        private StorageRecord() {
        }

        public void clear() {
            this.storage = null;
            this.mark = false;
            this.invStorageSize = 0;
            this.drawerStorageSize = 0;
            this.distance = Integer.MAX_VALUE;
        }
    }
}

