/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrimCustom;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.item.ItemCustomDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemCustomTrim;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityFramingRenderer
extends TileEntitySpecialRenderer<TileEntityFramingTable> {
    public void renderTileEntityAt(TileEntityFramingTable tile, double x, double y, double z, float partialTickTime, int destroyStage) {
        if (tile == null) {
            return;
        }
        IBlockState state = this.func_178459_a().func_180495_p(tile.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockFramingTable)) {
            return;
        }
        if (!((Boolean)state.func_177229_b((IProperty)BlockFramingTable.RIGHT_SIDE)).booleanValue()) {
            return;
        }
        ItemStack target = tile.func_70301_a(0);
        if (!target.func_190926_b()) {
            Block block = Block.func_149634_a((Item)target.func_77973_b());
            IBlockState blockState = block.func_176203_a(target.func_77960_j());
            if (block instanceof BlockDrawersCustom) {
                ItemStack result = ItemCustomDrawers.makeItemStack(blockState, 1, tile.func_70301_a(1), tile.func_70301_a(2), tile.func_70301_a(3));
                this.renderSlot(tile, x, y, z, result, 1.0f, 0.5f, 0.25f, -0.5f);
            } else if (block instanceof BlockTrimCustom) {
                ItemStack result = ItemCustomTrim.makeItemStack(block, 1, tile.func_70301_a(1), tile.func_70301_a(2));
                this.renderSlot(tile, x, y, z, result, 1.0f, 0.5f, 0.25f, -0.5f);
            }
        }
        this.renderSlot(tile, x, y, z, tile.func_70301_a(1), 0.575f, 1.15f, 0.15f, -0.275f);
        this.renderSlot(tile, x, y, z, tile.func_70301_a(2), 0.575f, -0.14999998f, 0.15f, -0.275f);
        this.renderSlot(tile, x, y, z, tile.func_70301_a(3), 0.575f, 1.15f, 0.15f, -0.725f);
    }

    private void renderSlot(TileEntityFramingTable tileTable, double x, double y, double z, ItemStack item, float scale, float tx, float ty, float tz) {
        if (item == null) {
            return;
        }
        Block itemBlock = Block.func_149634_a((Item)item.func_77973_b());
        if (itemBlock == null) {
            return;
        }
        IBlockState state = this.func_178459_a().func_180495_p(tileTable.func_174877_v());
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)BlockFramingTable.FACING);
        int side = dir.func_176745_a();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 1.0), (double)(z + 0.5));
        if (side == 3) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (side == 4) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (side == 5) {
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.5f);
        GL11.glTranslatef((float)tx, (float)ty, (float)tz);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        try {
            Minecraft.func_71410_x().func_175599_af().func_181564_a(item, ItemCameraTransforms.TransformType.FIXED);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glPopMatrix();
    }
}

