/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.renderer.StorageRenderItem;
import com.jaquadro.minecraft.storagedrawers.inventory.InventoryUpgrade;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotDrawer;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerDrawers
extends Container {
    private static final int InventoryX = 8;
    private static final int InventoryY = 117;
    private static final int HotbarY = 175;
    private static final int UpgradeX = 44;
    private static final int UpgradeY = 86;
    private IInventory upgradeInventory;
    private List<Slot> storageSlots;
    private List<Slot> upgradeSlots;
    private List<Slot> playerSlots;
    private List<Slot> hotbarSlots;
    @SideOnly(value=Side.CLIENT)
    public StorageRenderItem activeRenderItem;
    private boolean isRemote;

    public ContainerDrawers(InventoryPlayer playerInventory, TileEntityDrawers tileEntity) {
        int i;
        this.upgradeInventory = new InventoryUpgrade(tileEntity);
        this.storageSlots = new ArrayList<Slot>();
        for (i = 0; i < tileEntity.getDrawerCount(); ++i) {
            this.storageSlots.add(this.func_75146_a(new SlotDrawer(this, tileEntity, i, this.getStorageSlotX(i), this.getStorageSlotY(i))));
        }
        this.upgradeSlots = new ArrayList<Slot>();
        for (i = 0; i < 5; ++i) {
            this.upgradeSlots.add(this.func_75146_a(new SlotUpgrade(this.upgradeInventory, i, 44 + i * 18, 86)));
        }
        this.playerSlots = new ArrayList<Slot>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 117 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.func_75146_a(new Slot((IInventory)playerInventory, i, 8 + i * 18, 175)));
        }
        this.isRemote = tileEntity.func_145831_w().field_72995_K;
    }

    public void setLastAccessedItem(ItemStack stack) {
        if (this.isRemote && this.activeRenderItem != null) {
            this.activeRenderItem.overrideStack = stack;
        }
    }

    protected int getStorageSlotX(int slot) {
        return 0;
    }

    protected int getStorageSlotY(int slot) {
        return 0;
    }

    public List<Slot> getStorageSlots() {
        return this.storageSlots;
    }

    public List<Slot> getUpgradeSlots() {
        return this.upgradeSlots;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.upgradeInventory.func_70300_a(player);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int storageStart = this.storageSlots.get((int)0).field_75222_d;
        int storageEnd = this.storageSlots.get((int)(this.storageSlots.size() - 1)).field_75222_d + 1;
        int upgradeStart = this.upgradeSlots.get((int)0).field_75222_d;
        int upgradeEnd = this.upgradeSlots.get((int)(this.upgradeSlots.size() - 1)).field_75222_d + 1;
        int inventoryStart = this.playerSlots.get((int)0).field_75222_d;
        int hotbarStart = this.hotbarSlots.get((int)0).field_75222_d;
        int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).field_75222_d + 1;
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack;
            block17: {
                slotStack = slot.func_75211_c();
                itemStack = slotStack.func_77946_l();
                if (slotIndex >= upgradeStart && slotIndex < upgradeEnd) {
                    if (!this.func_75135_a(slotStack, inventoryStart, hotbarEnd, true)) {
                        return ItemStack.field_190927_a;
                    }
                    slot.func_75220_a(slotStack, itemStack);
                } else if (slotIndex >= inventoryStart && slotIndex < hotbarEnd && !slotStack.func_190926_b()) {
                    if (slotStack.func_77973_b() instanceof ItemUpgrade) {
                        ItemStack slotStack1 = slotStack.func_77946_l();
                        slotStack1.func_190920_e(1);
                        if (!this.func_75135_a(slotStack1, upgradeStart, upgradeEnd, false)) {
                            if (slotIndex >= inventoryStart && slotIndex < hotbarStart ? !this.func_75135_a(slotStack, hotbarStart, hotbarEnd, false) : slotIndex >= hotbarStart && slotIndex < hotbarEnd && !this.func_75135_a(slotStack, inventoryStart, hotbarStart, false)) {
                                return ItemStack.field_190927_a;
                            }
                            break block17;
                        } else {
                            slotStack.func_190918_g(1);
                            if (slotStack.func_190916_E() == 0) {
                                slot.func_75215_d(ItemStack.field_190927_a);
                            } else {
                                slot.func_75218_e();
                            }
                            slot.func_190901_a(player, slotStack);
                            return ItemStack.field_190927_a;
                        }
                    }
                    if (slotIndex >= inventoryStart && slotIndex < hotbarStart ? !this.func_75135_a(slotStack, hotbarStart, hotbarEnd, false) : slotIndex >= hotbarStart && slotIndex < hotbarEnd && !this.func_75135_a(slotStack, inventoryStart, hotbarStart, false)) {
                        return ItemStack.field_190927_a;
                    }
                } else if (!this.func_75135_a(slotStack, inventoryStart, hotbarEnd, false)) {
                    return ItemStack.field_190927_a;
                }
            }
            int slotStackSize = slotStack.func_190916_E();
            if (slotStackSize == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStackSize == itemStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotStack);
        }
        return itemStack;
    }
}

