/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IPriorityGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.ISmartGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IVoidable;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class DrawerItemHandler
implements IItemHandler {
    private IDrawerGroup group;

    public DrawerItemHandler(IDrawerGroup group) {
        this.group = group;
    }

    public int getSlots() {
        return this.group.getDrawerCount() + 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        IDrawer drawer;
        if (this.slotIsVirtual(slot)) {
            return ItemStack.field_190927_a;
        }
        --slot;
        if (this.group instanceof IPriorityGroup) {
            int[] order = ((IPriorityGroup)((Object)this.group)).getAccessibleDrawerSlots();
            int n = slot = slot >= 0 && slot < order.length ? order[slot] : -1;
        }
        if ((drawer = this.group.getDrawerIfEnabled(slot)) == null || drawer.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = drawer.getStoredItemPrototype().func_77946_l();
        stack.func_190920_e(drawer.getStoredItemCount());
        return stack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        IDrawer drawer;
        if (this.slotIsVirtual(slot)) {
            if (StorageDrawers.config.cache.enableItemConversion) {
                return this.insertItemFullScan(stack, simulate);
            }
            return stack;
        }
        int orderedSlot = --slot;
        int prevSlot = slot - 1;
        if (this.group instanceof IPriorityGroup) {
            int[] order = ((IPriorityGroup)((Object)this.group)).getAccessibleDrawerSlots();
            orderedSlot = slot >= 0 && slot < order.length ? order[slot] : -1;
            int n = prevSlot = slot >= 1 && slot < order.length ? order[slot - 1] : -1;
        }
        if (StorageDrawers.config.cache.enableItemConversion && orderedSlot > 0 && (drawer = this.group.getDrawerIfEnabled(orderedSlot)) != null && drawer.isEmpty()) {
            if (prevSlot == -1 || !this.group.isDrawerEnabled(prevSlot)) {
                return this.insertItemFullScan(stack, simulate);
            }
            IDrawer prevDrawer = this.group.getDrawer(prevSlot);
            if (!prevDrawer.isEmpty()) {
                return this.insertItemFullScan(stack, simulate);
            }
        }
        return this.insertItemInternal(orderedSlot, stack, simulate);
    }

    @Nonnull
    private ItemStack insertItemFullScan(@Nonnull ItemStack stack, boolean simulate) {
        if (this.group instanceof ISmartGroup) {
            int i;
            Iterator<Integer> iterator = ((ISmartGroup)((Object)this.group)).enumerateDrawersForInsertion(stack, false).iterator();
            while (iterator.hasNext() && !(stack = this.insertItemInternal(i = iterator.next().intValue(), stack, simulate)).func_190926_b()) {
            }
        } else if (this.group instanceof IPriorityGroup) {
            int[] order = ((IPriorityGroup)((Object)this.group)).getAccessibleDrawerSlots();
            for (int i = 0; i < order.length && !(stack = this.insertItemInternal(i, stack, simulate)).func_190926_b(); ++i) {
            }
        } else {
            for (int i = 0; i < this.group.getDrawerCount() && !(stack = this.insertItemInternal(i, stack, simulate)).func_190926_b(); ++i) {
            }
        }
        return stack;
    }

    @Nonnull
    private ItemStack insertItemInternal(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int insertCount;
        int stackSize;
        int remainder;
        int availableCount;
        IDrawer drawer = this.group.getDrawerIfEnabled(slot);
        if (drawer == null || !drawer.canItemBeStored(stack)) {
            return stack;
        }
        int n = availableCount = drawer.isEmpty() ? drawer.getMaxCapacity(stack) : drawer.getRemainingCapacity();
        if (drawer instanceof IVoidable && ((IVoidable)((Object)drawer)).isVoid()) {
            availableCount = Integer.MAX_VALUE;
        }
        if ((remainder = (stackSize = stack.func_190916_E()) - (insertCount = Math.min(stackSize, availableCount))) == stackSize) {
            return stack;
        }
        if (!simulate) {
            if (drawer.isEmpty()) {
                drawer.setStoredItem(stack, insertCount);
            } else {
                drawer.setStoredItemCount(drawer.getStoredItemCount() + insertCount);
            }
        }
        if (remainder == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack returnStack = stack.func_77946_l();
        returnStack.func_190920_e(remainder);
        return returnStack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        IDrawer drawer;
        if (this.slotIsVirtual(slot)) {
            return ItemStack.field_190927_a;
        }
        --slot;
        if (this.group instanceof IPriorityGroup) {
            int[] order = ((IPriorityGroup)((Object)this.group)).getAccessibleDrawerSlots();
            int n = slot = slot >= 0 && slot < order.length ? order[slot] : -1;
        }
        if ((drawer = this.group.getDrawerIfEnabled(slot)) == null || drawer.isEmpty() || drawer.getStoredItemCount() == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack returnStack = drawer.getStoredItemPrototype().func_77946_l();
        int stackSize = Math.min(drawer.getStoredItemCount(), amount);
        stackSize = Math.min(stackSize, returnStack.func_77976_d());
        returnStack.func_190920_e(stackSize);
        if (!simulate) {
            drawer.setStoredItemCount(drawer.getStoredItemCount() - stackSize);
        }
        return returnStack;
    }

    public int getSlotLimit(int slot) {
        if (this.slotIsVirtual(slot)) {
            return Integer.MAX_VALUE;
        }
        IDrawer drawer = this.group.getDrawerIfEnabled(slot);
        if (drawer == null) {
            return 0;
        }
        if (drawer.isEmpty()) {
            return drawer.getDefaultMaxCapacity();
        }
        return drawer.getMaxCapacity();
    }

    private boolean slotIsVirtual(int slot) {
        return slot == 0;
    }
}

