/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDrawers
extends ItemBlock {
    public ItemDrawers(Block block) {
        super(block);
        this.func_77656_e(0);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            return false;
        }
        TileEntityDrawers tile = (TileEntityDrawers)world.func_175625_s(pos);
        if (tile != null) {
            if (side != EnumFacing.UP && side != EnumFacing.DOWN) {
                tile.setDirection(side.ordinal());
            }
            if (tile instanceof TileEntityDrawersStandard) {
                EnumBasicDrawer info = EnumBasicDrawer.byMetadata(stack.func_77960_j());
                ((TileEntityDrawersStandard)tile).setDrawerCount(info.getDrawerCount());
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tile")) {
                    tile.readFromPortableNBT(stack.func_77978_p().func_74775_l("tile"));
                }
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("material")) {
                    tile.setMaterial(stack.func_77978_p().func_74779_i("material"));
                }
                tile.setIsSealed(false);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemStack, EntityPlayer player, List<String> list, boolean par4) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("material")) {
            String key = itemStack.func_77978_p().func_74779_i("material");
            list.add(I18n.func_135052_a((String)"storagedrawers.material", (Object[])new Object[]{I18n.func_135052_a((String)("storagedrawers.material." + key), (Object[])new Object[0])}));
        }
        list.add(I18n.func_135052_a((String)"storagedrawers.drawers.description", (Object[])new Object[]{this.getCapacityForBlock(itemStack)}));
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("tile")) {
            list.add(ChatFormatting.YELLOW + I18n.func_135052_a((String)"storagedrawers.drawers.sealed", (Object[])new Object[0]));
        }
    }

    private int getCapacityForBlock(@Nonnull ItemStack itemStack) {
        ConfigManager config = StorageDrawers.config;
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (block instanceof BlockStandardDrawers) {
            EnumBasicDrawer info = EnumBasicDrawer.byMetadata(itemStack.func_77960_j());
            switch (info) {
                case FULL1: {
                    return config.getBlockBaseStorage("fulldrawers1");
                }
                case FULL2: {
                    return config.getBlockBaseStorage("fulldrawers2");
                }
                case FULL4: {
                    return config.getBlockBaseStorage("fulldrawers4");
                }
                case HALF2: {
                    return config.getBlockBaseStorage("halfdrawers2");
                }
                case HALF4: {
                    return config.getBlockBaseStorage("halfdrawers4");
                }
            }
            return 0;
        }
        if (block == ModBlocks.compDrawers) {
            return config.getBlockBaseStorage("compDrawers");
        }
        return 0;
    }
}

