/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.chameleon.resources.IItemMeshMapper;
import com.jaquadro.minecraft.chameleon.resources.IItemVariantProvider;
import com.jaquadro.minecraft.storagedrawers.block.BlockKeyButton;
import com.jaquadro.minecraft.storagedrawers.block.EnumKeyType;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class ItemKeyButton
extends ItemMultiTexture
implements IItemMeshMapper,
IItemVariantProvider {
    public ItemKeyButton(Block block) {
        super(block, block, new ItemMultiTexture.Mapper(){

            @Nonnull
            public String apply(@Nonnull ItemStack input) {
                return EnumKeyType.byMetadata(input.func_77960_j()).func_176610_l();
            }
        });
        this.func_77627_a(true);
    }

    public String func_77667_c(@Nonnull ItemStack itemStack) {
        return super.func_77658_a() + "." + EnumKeyType.byMetadata(itemStack.func_77960_j()).func_176610_l();
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public List<Pair<ItemStack, ModelResourceLocation>> getMeshMappings() {
        ArrayList<Pair<ItemStack, ModelResourceLocation>> mappings = new ArrayList<Pair<ItemStack, ModelResourceLocation>>();
        for (EnumKeyType keyType : EnumKeyType.values()) {
            IBlockState state = this.field_150939_a.func_176223_P().func_177226_a(BlockKeyButton.VARIANT, (Comparable)((Object)keyType));
            ModelResourceLocation location = new ModelResourceLocation(ModBlocks.keyButton.getRegistryName().toString() + '_' + keyType.func_176610_l(), "inventory");
            mappings.add((Pair<ItemStack, ModelResourceLocation>)Pair.of((Object)new ItemStack((Item)this, 1, this.field_150939_a.func_176201_c(state)), (Object)location));
        }
        return mappings;
    }

    public List<ResourceLocation> getItemVariants() {
        ResourceLocation location = GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)this);
        ArrayList<ResourceLocation> variants = new ArrayList<ResourceLocation>();
        for (EnumKeyType keyType : EnumKeyType.values()) {
            variants.add(new ResourceLocation(location.func_110624_b(), location.func_110623_a() + '_' + keyType.func_176610_l()));
        }
        return variants;
    }
}

