/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.ISealable;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTape
extends Item {
    public ItemTape(String registryName, String unlocalizedName) {
        this.setRegistryName(registryName);
        this.func_77655_b(unlocalizedName);
        this.func_77625_d(1);
        this.func_77656_e(8);
        this.func_77637_a(ModCreativeTabs.tabStorageDrawers);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemStack, EntityPlayer player, List<String> list, boolean par4) {
        String name = this.func_77667_c(itemStack);
        list.add(I18n.func_135052_a((String)(name + ".description"), (Object[])new Object[0]));
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos, side, stack)) {
            return EnumActionResult.FAIL;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IProtectable && !SecurityManager.hasOwnership(player.func_146103_bH(), (IProtectable)tile)) {
            return EnumActionResult.FAIL;
        }
        if (tile instanceof ISealable) {
            ISealable tileseal = (ISealable)tile;
            if (tileseal.isSealed()) {
                return EnumActionResult.FAIL;
            }
            tileseal.setIsSealed(true);
            stack.func_77972_a(1, (EntityLivingBase)player);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }
}

