/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.chameleon.resources.IItemMeshMapper;
import com.jaquadro.minecraft.chameleon.resources.IItemVariantProvider;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class ItemTrim
extends ItemMultiTexture
implements IItemMeshMapper,
IItemVariantProvider {
    public ItemTrim(Block block) {
        super(block, block, new ItemMultiTexture.Mapper(){

            @Nonnull
            public String apply(@Nonnull ItemStack input) {
                return BlockPlanks.EnumType.func_176837_a((int)input.func_77960_j()).func_176840_c();
            }
        });
    }

    protected ItemTrim(Block block, ItemMultiTexture.Mapper mapper) {
        super(block, block, mapper);
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        return block instanceof BlockDrawers && ((BlockDrawers)block).retrimType() != null;
    }

    public List<ResourceLocation> getItemVariants() {
        ResourceLocation location = GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)this);
        ArrayList<ResourceLocation> variants = new ArrayList<ResourceLocation>();
        for (BlockPlanks.EnumType woodType : BlockPlanks.EnumType.values()) {
            variants.add(new ResourceLocation(location.func_110624_b(), location.func_110623_a() + '_' + woodType.func_176610_l()));
        }
        return variants;
    }

    public List<Pair<ItemStack, ModelResourceLocation>> getMeshMappings() {
        ArrayList<Pair<ItemStack, ModelResourceLocation>> mappings = new ArrayList<Pair<ItemStack, ModelResourceLocation>>();
        for (BlockPlanks.EnumType woodType : BlockPlanks.EnumType.values()) {
            IBlockState state = this.field_150939_a.func_176223_P().func_177226_a((IProperty)BlockTrim.VARIANT, (Comparable)woodType);
            ModelResourceLocation location = new ModelResourceLocation(ModBlocks.trim.getRegistryName().toString() + '_' + woodType.func_176610_l(), "inventory");
            mappings.add((Pair<ItemStack, ModelResourceLocation>)Pair.of((Object)new ItemStack((Item)this, 1, this.field_150939_a.func_176201_c(state)), (Object)location));
        }
        return mappings;
    }
}

