/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.network;

import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class CountUpdateMessage
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int slot;
    private int count;
    private boolean failed;

    public CountUpdateMessage() {
    }

    public CountUpdateMessage(BlockPos pos, int slot, int count) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.slot = slot;
        this.count = count;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.x = buf.readInt();
            this.y = buf.readShort();
            this.z = buf.readInt();
            this.slot = buf.readByte();
            this.count = buf.readInt();
        }
        catch (IndexOutOfBoundsException e) {
            this.failed = true;
            FMLLog.log((String)"storagedrawers", (Level)Level.ERROR, (Throwable)e, (String)"CountUpdateMessage: Unexpected end of packet.\nMessage: %s", (Object[])new Object[]{ByteBufUtil.hexDump((ByteBuf)buf, (int)0, (int)buf.writerIndex())});
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeShort(this.y);
        buf.writeInt(this.z);
        buf.writeByte(this.slot);
        buf.writeInt(this.count);
    }

    public static class HandlerStub
    implements IMessageHandler<CountUpdateMessage, IMessage> {
        public IMessage onMessage(CountUpdateMessage message, MessageContext ctx) {
            FMLLog.log((String)"storagedrawers", (Level)Level.WARN, (String)"CountUpdateMessage stub handler called.", (Object[])new Object[0]);
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IMessageHandler<CountUpdateMessage, IMessage> {
        public IMessage onMessage(CountUpdateMessage message, MessageContext ctx) {
            BlockPos pos;
            TileEntity tileEntity;
            WorldClient world;
            if (!message.failed && ctx.side == Side.CLIENT && (world = Minecraft.func_71410_x().field_71441_e) != null && (tileEntity = world.func_175625_s(pos = new BlockPos(message.x, message.y, message.z))) instanceof TileEntityDrawers) {
                ((TileEntityDrawers)tileEntity).clientUpdateCount(message.slot, message.count);
            }
            return null;
        }
    }
}

