/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.storage;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public abstract class BaseDrawerData
implements IDrawer {
    private List<ItemStack> oreDictMatches;
    private Map<String, Object> auxData;

    protected BaseDrawerData() {
    }

    protected void postInit() {
    }

    protected void reset() {
        this.oreDictMatches = null;
    }

    protected void refreshOreDictMatches() {
        ItemStack protoStack = this.getStoredItemPrototype();
        if (protoStack.func_190926_b()) {
            this.oreDictMatches = null;
            return;
        }
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)protoStack);
        if (oreIDs.length == 0) {
            this.oreDictMatches = null;
        } else {
            this.oreDictMatches = new ArrayList<ItemStack>();
            for (int id : oreIDs) {
                String oreName = OreDictionary.getOreName((int)id);
                if (!StorageDrawers.oreDictRegistry.isEntryValid(oreName)) continue;
                NonNullList list = OreDictionary.getOres((String)oreName);
                for (ItemStack aList : list) {
                    if (aList.func_77952_i() == Short.MAX_VALUE) continue;
                    this.oreDictMatches.add(aList);
                }
            }
            if (this.oreDictMatches.size() == 0) {
                this.oreDictMatches = null;
            }
        }
    }

    @Override
    public Object getExtendedData(String key) {
        if (this.auxData == null || !this.auxData.containsKey(key)) {
            return null;
        }
        return this.auxData.get(key);
    }

    @Override
    public void setExtendedData(String key, Object data) {
        if (this.auxData == null) {
            this.auxData = new HashMap<String, Object>();
        }
        this.auxData.put(key, data);
    }

    @Override
    public void attributeChanged() {
    }

    protected int getItemCapacityForInventoryStack() {
        return this.getMaxCapacity();
    }

    public boolean areItemsEqual(@Nonnull ItemStack item) {
        ItemStack protoStack = this.getStoredItemPrototype();
        if (!protoStack.func_190926_b() && !protoStack.func_77969_a(item)) {
            if (!StorageDrawers.config.cache.enableItemConversion) {
                return false;
            }
            if (this.oreDictMatches == null) {
                return false;
            }
            if (protoStack.func_77973_b() == item.func_77973_b()) {
                return false;
            }
            boolean oreMatch = false;
            for (ItemStack oreDictMatche : this.oreDictMatches) {
                if (!item.func_77969_a(oreDictMatche)) continue;
                oreMatch = true;
                break;
            }
            if (!oreMatch) {
                return false;
            }
        }
        return ItemStack.func_77970_a((ItemStack)protoStack, (ItemStack)item);
    }

    public static boolean areItemsEqual(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        return BaseDrawerData.areItemsEqual(stack1, stack2, true);
    }

    public static boolean areItemsEqual(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2, boolean oreDictStrictMode) {
        if (!(stack1.func_190926_b() || stack2.func_190926_b() || stack1.func_77969_a(stack2))) {
            if (!StorageDrawers.config.cache.enableItemConversion) {
                return false;
            }
            if (stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE) {
                return false;
            }
            if (stack1.func_77973_b() == stack2.func_77973_b()) {
                return false;
            }
            int[] ids1 = OreDictionary.getOreIDs((ItemStack)stack1);
            int[] ids2 = OreDictionary.getOreIDs((ItemStack)stack2);
            if (ids1.length == 0 || ids2.length == 0) {
                return false;
            }
            boolean oreMatch = false;
            for (int id1 : ids1) {
                for (int id2 : ids2) {
                    if (id1 != id2) continue;
                    String name = OreDictionary.getOreName((int)id1);
                    if (oreDictStrictMode && !StorageDrawers.oreDictRegistry.isEntryValid(name)) continue;
                    oreMatch = true;
                    break;
                }
                if (oreMatch) break;
            }
            if (!oreMatch) {
                return false;
            }
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }
}

