/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.google.common.base.Predicate;
import com.jaquadro.minecraft.chameleon.block.properties.UnlistedTileEntity;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.IExtendedBlockClickHandler;
import com.jaquadro.minecraft.storagedrawers.block.dynamic.StatusModelData;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.handlers.GuiHandler;
import com.jaquadro.minecraft.storagedrawers.inventory.DrawerInventoryHelper;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeStorage;
import com.jaquadro.minecraft.storagedrawers.item.ItemPersonalKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemTrim;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeCreative;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import com.jaquadro.minecraft.storagedrawers.network.BlockClickMessage;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class BlockDrawers
extends BlockContainer
implements IExtendedBlockClickHandler,
INetworked {
    public static final PropertyEnum BLOCK = PropertyEnum.func_177709_a((String)"block", EnumBasicDrawer.class);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockPlanks.EnumType.class);
    public static final IUnlistedProperty<TileEntityDrawers> TILE = UnlistedTileEntity.create(TileEntityDrawers.class);
    @SideOnly(value=Side.CLIENT)
    private StatusModelData[] statusInfo;
    private long ignoreEventTime;

    public BlockDrawers(String blockName) {
        this(Material.field_151575_d, blockName);
    }

    protected BlockDrawers(Material material, String blockName) {
        super(material);
        this.field_149783_u = true;
        this.func_149647_a(ModCreativeTabs.tabStorageDrawers);
        this.func_149711_c(5.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149663_c(blockName);
        this.func_149713_g(255);
        this.initDefaultState();
    }

    protected void initDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BLOCK, (Comparable)((Object)EnumBasicDrawer.FULL2)));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)BlockPlanks.EnumType.OAK));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public boolean retrimBlock(World world, BlockPos pos, ItemStack prototype) {
        BlockPlanks.EnumType newVariant;
        int protoMeta;
        if (this.retrimType() == null) {
            return false;
        }
        IBlockState curState = this.func_176221_a(world.func_180495_p(pos), (IBlockAccess)world, pos);
        if (curState == null || !(curState.func_177230_c() instanceof BlockDrawers)) {
            return false;
        }
        Block protoBlock = Block.func_149634_a((Item)prototype.func_77973_b());
        IBlockState newState = protoBlock.func_176203_a(protoMeta = prototype.func_77952_i());
        if (newState == null || !(newState.func_177230_c() instanceof BlockTrim)) {
            return false;
        }
        BlockPlanks.EnumType curVariant = (BlockPlanks.EnumType)curState.func_177229_b((IProperty)VARIANT);
        if (curVariant == (newVariant = (BlockPlanks.EnumType)newState.func_177229_b((IProperty)VARIANT))) {
            return false;
        }
        TileEntityDrawers tile = this.getTileEntity((IBlockAccess)world, pos);
        tile.setMaterial(newVariant.func_176610_l());
        world.func_175656_a(pos, curState.func_177226_a((IProperty)VARIANT, (Comparable)newVariant));
        return true;
    }

    public BlockType retrimType() {
        return BlockType.Drawers;
    }

    public int getDrawerCount(IBlockState state) {
        EnumBasicDrawer info;
        if (state != null && state.func_177230_c() instanceof BlockDrawers && (info = (EnumBasicDrawer)((Object)state.func_177229_b((IProperty)BLOCK))) != null) {
            return info.getDrawerCount();
        }
        return 0;
    }

    public boolean isHalfDepth(IBlockState state) {
        EnumBasicDrawer info;
        if (state != null && state.func_177230_c() instanceof BlockDrawers && (info = (EnumBasicDrawer)((Object)state.func_177229_b((IProperty)BLOCK))) != null) {
            return info.isHalfDepth();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void initDynamic() {
        this.statusInfo = new StatusModelData[EnumBasicDrawer.values().length];
        for (EnumBasicDrawer type : EnumBasicDrawer.values()) {
            ResourceLocation location = new ResourceLocation("StorageDrawers:models/dynamic/basicDrawers_" + type.func_176610_l() + ".json");
            this.statusInfo[type.getMetadata()] = new StatusModelData(type.getDrawerCount(), location);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public StatusModelData getStatusInfo(IBlockState state) {
        EnumBasicDrawer info;
        if (state != null && (info = (EnumBasicDrawer)((Object)state.func_177229_b((IProperty)BLOCK))) != null) {
            return this.statusInfo[info.getMetadata()];
        }
        return null;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return 3;
    }

    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT_MIPPED;
    }

    public void func_180654_a(IBlockAccess blockAccess, BlockPos pos) {
        TileEntityDrawers tile = this.getTileEntity(blockAccess, pos);
        if (tile == null) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        float depth = this.isHalfDepth(blockAccess.func_180495_p(pos)) ? 0.5f : 1.0f;
        switch (tile.getDirection()) {
            case 2: {
                this.func_149676_a(0.0f, 0.0f, 1.0f - depth, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, depth);
                break;
            }
            case 4: {
                this.func_149676_a(1.0f - depth, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, depth, 1.0f, 1.0f);
            }
        }
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_180638_a(World world, BlockPos pos, IBlockState state, AxisAlignedBB aabb, List<AxisAlignedBB> list, Entity entity) {
        this.func_180654_a((IBlockAccess)world, pos);
        super.func_180638_a(world, pos, state, aabb, list, entity);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            Block blockNorth = world.func_180495_p(pos.func_177978_c()).func_177230_c();
            Block blockSouth = world.func_180495_p(pos.func_177968_d()).func_177230_c();
            Block blockWest = world.func_180495_p(pos.func_177976_e()).func_177230_c();
            Block blockEast = world.func_180495_p(pos.func_177974_f()).func_177230_c();
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (facing == EnumFacing.NORTH && blockNorth.func_149730_j() && !blockSouth.func_149730_j()) {
                facing = EnumFacing.SOUTH;
            }
            if (facing == EnumFacing.SOUTH && blockSouth.func_149730_j() && !blockNorth.func_149730_j()) {
                facing = EnumFacing.NORTH;
            }
            if (facing == EnumFacing.WEST && blockWest.func_149730_j() && !blockEast.func_149730_j()) {
                facing = EnumFacing.EAST;
            }
            if (facing == EnumFacing.EAST && blockEast.func_149730_j() && !blockWest.func_149730_j()) {
                facing = EnumFacing.WEST;
            }
            TileEntityDrawers tile = this.getTileEntitySafe(world, pos);
            tile.setDirection(facing.ordinal());
            tile.func_70296_d();
        }
        super.func_176213_c(world, pos, state);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)BLOCK, (Comparable)((Object)EnumBasicDrawer.byMetadata(meta)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack itemStack) {
        EnumFacing facing = entity.func_174811_aO().func_176734_d();
        TileEntityDrawers tile = this.getTileEntitySafe(world, pos);
        tile.setDirection(facing.ordinal());
        tile.func_70296_d();
        if (itemStack.func_82837_s()) {
            tile.setInventoryName(itemStack.func_82833_r());
        }
        world.func_180501_a(pos, state, 3);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K && Minecraft.func_71386_F() == this.ignoreEventTime) {
            this.ignoreEventTime = 0L;
            return false;
        }
        TileEntityDrawers tileDrawers = this.getTileEntitySafe(world, pos);
        ItemStack item = player.field_71071_by.func_70448_g();
        if (!SecurityManager.hasAccess(player.func_146103_bH(), tileDrawers)) {
            return false;
        }
        if (StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)"BlockDrawers.onBlockActivated", (Object[])new Object[0]);
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)(item == null ? "  null item" : "  " + item.toString()), (Object[])new Object[0]);
        }
        if (item != null && item.func_77973_b() != null) {
            if (item.func_77973_b() instanceof ItemTrim && player.func_70093_af()) {
                if (!this.retrimBlock(world, pos, item)) {
                    return false;
                }
                if (!player.field_71075_bZ.field_75098_d && --item.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                return true;
            }
            if (item.func_77973_b() == ModItems.upgradeStorage || item.func_77973_b() == ModItems.upgradeStatus || item.func_77973_b() == ModItems.upgradeVoid || item.func_77973_b() == ModItems.upgradeCreative || item.func_77973_b() == ModItems.upgradeRedstone) {
                if (!tileDrawers.addUpgrade(item) && !world.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("storagedrawers.msg.maxUpgrades", new Object[0]));
                    return false;
                }
                world.func_175689_h(pos);
                if (!player.field_71075_bZ.field_75098_d && --item.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                return true;
            }
            if (item.func_77973_b() == ModItems.drawerKey) {
                boolean locked = tileDrawers.isItemLocked(LockAttribute.LOCK_POPULATED);
                tileDrawers.setItemLocked(LockAttribute.LOCK_POPULATED, !locked);
                tileDrawers.setItemLocked(LockAttribute.LOCK_EMPTY, !locked);
                return true;
            }
            if (item.func_77973_b() == ModItems.shroudKey) {
                tileDrawers.setIsShrouded(!tileDrawers.isShrouded());
                return true;
            }
            if (item.func_77973_b() instanceof ItemPersonalKey) {
                String securityKey = ((ItemPersonalKey)item.func_77973_b()).getSecurityProviderKey(item.func_77952_i());
                ISecurityProvider provider = StorageDrawers.securityRegistry.getProvider(securityKey);
                if (tileDrawers.getOwner() == null) {
                    tileDrawers.setOwner(player.getPersistentID());
                    tileDrawers.setSecurityProvider(provider);
                } else if (SecurityManager.hasOwnership(player.func_146103_bH(), tileDrawers)) {
                    tileDrawers.setOwner(null);
                    tileDrawers.setSecurityProvider(null);
                } else {
                    return false;
                }
                return true;
            }
            if (item.func_77973_b() == ModItems.tape) {
                return false;
            }
        } else if (item == null && player.func_70093_af()) {
            if (tileDrawers.isSealed()) {
                tileDrawers.setIsSealed(false);
                return true;
            }
            if (StorageDrawers.config.cache.enableDrawerUI) {
                player.openGui((Object)StorageDrawers.instance, GuiHandler.drawersGuiID, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return true;
            }
        }
        if (tileDrawers.getDirection() != side.ordinal()) {
            return false;
        }
        if (tileDrawers.isSealed()) {
            return false;
        }
        int slot = this.getDrawerSlot(this.getDrawerCount(state), side.ordinal(), hitX, hitY, hitZ);
        int countAdded = tileDrawers.interactPutItemsIntoSlot(slot, player);
        if (countAdded > 0) {
            world.func_175689_h(pos);
        }
        return true;
    }

    protected int getDrawerSlot(int drawerCount, int side, float hitX, float hitY, float hitZ) {
        if (drawerCount == 1) {
            return 0;
        }
        if (drawerCount == 2) {
            return this.hitTop(hitY) ? 0 : 1;
        }
        if (this.hitLeft(side, hitX, hitZ)) {
            return this.hitTop(hitY) ? 0 : 1;
        }
        return this.hitTop(hitY) ? 2 : 3;
    }

    protected boolean hitTop(float hitY) {
        return (double)hitY > 0.5;
    }

    protected boolean hitLeft(int side, float hitX, float hitZ) {
        switch (side) {
            case 2: {
                return (double)hitX > 0.5;
            }
            case 3: {
                return (double)hitX < 0.5;
            }
            case 4: {
                return (double)hitZ < 0.5;
            }
            case 5: {
                return (double)hitZ > 0.5;
            }
        }
        return true;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            MovingObjectPosition posn = Minecraft.func_71410_x().field_71476_x;
            BlockPos posb = posn.func_178782_a();
            float hitX = (float)(posn.field_72307_f.field_72450_a - (double)posb.func_177958_n());
            float hitY = (float)(posn.field_72307_f.field_72448_b - (double)posb.func_177956_o());
            float hitZ = (float)(posn.field_72307_f.field_72449_c - (double)posb.func_177952_p());
            StorageDrawers.network.sendToServer((IMessage)new BlockClickMessage(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), posn.field_178784_b.ordinal(), hitX, hitY, hitZ, StorageDrawers.config.cache.invertShift));
            if (StorageDrawers.config.cache.debugTrace) {
                FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("BlockDrawers.onBlockClicked with " + posn.toString()), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void onBlockClicked(final World world, final BlockPos pos, final EntityPlayer player, final EnumFacing side, final float hitX, final float hitY, final float hitZ, final boolean invertShift) {
        if (world.field_72995_K) {
            return;
        }
        ((WorldServer)world).func_152344_a(new Runnable(){

            @Override
            public void run() {
                BlockDrawers.this.onBlockClickedAsync(world, pos, player, side, hitX, hitY, hitZ, invertShift);
            }
        });
    }

    private void onBlockClickedAsync(World world, BlockPos pos, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ, boolean invertShift) {
        PlayerInteractEvent event;
        if (StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)"IExtendedBlockClickHandler.onBlockClicked", (Object[])new Object[0]);
        }
        if (!player.field_71075_bZ.field_75098_d && (event = ForgeEventFactory.onPlayerInteract((EntityPlayer)player, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK, (World)world, (BlockPos)pos, (EnumFacing)side, (Vec3)new Vec3((double)hitX, (double)hitY, (double)hitZ))).isCanceled()) {
            return;
        }
        TileEntityDrawers tileDrawers = this.getTileEntitySafe(world, pos);
        if (tileDrawers.getDirection() != side.ordinal()) {
            return;
        }
        if (tileDrawers.isSealed()) {
            return;
        }
        if (!SecurityManager.hasAccess(player.func_146103_bH(), tileDrawers)) {
            return;
        }
        int slot = this.getDrawerSlot(this.getDrawerCount(world.func_180495_p(pos)), side.ordinal(), hitX, hitY, hitZ);
        IDrawer drawer = tileDrawers.getDrawer(slot);
        ItemStack item = player.func_70093_af() != invertShift ? tileDrawers.takeItemsFromSlot(slot, drawer.getStoredItemStackSize()) : tileDrawers.takeItemsFromSlot(slot, 1);
        if (StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)(item == null ? "  null item" : "  " + item.toString()), (Object[])new Object[0]);
        }
        if (item != null && item.field_77994_a > 0) {
            if (!player.field_71071_by.func_70441_a(item)) {
                this.dropItemStack(world, pos.func_177972_a(side), player, item);
                world.func_175689_h(pos);
            } else {
                world.func_72908_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), "random.pop", 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntityDrawers tile = this.getTileEntitySafe(world, pos);
        if (tile.isSealed()) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
            return true;
        }
        return super.rotateBlock(world, pos, axis);
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        Block blockUnder;
        if (this.isHalfDepth(world.func_180495_p(pos))) {
            return false;
        }
        if (side == EnumFacing.DOWN && ((blockUnder = world.func_180495_p(pos.func_177977_b()).func_177230_c()) instanceof BlockChest || blockUnder instanceof BlockEnderChest)) {
            return false;
        }
        return side.ordinal() != this.getTileEntity(world, pos).getDirection();
    }

    private void dropItemStack(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        EntityItem entity = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.5f), stack);
        entity.func_70024_g(-entity.field_70159_w, -entity.field_70181_x, -entity.field_70179_y);
        world.func_72838_d((Entity)entity);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K && player.field_71075_bZ.field_75098_d) {
            TileEntityDrawers tile = this.getTileEntity((IBlockAccess)world, pos);
            MovingObjectPosition posn = Minecraft.func_71410_x().field_71476_x;
            if (tile.getDirection() == posn.field_178784_b.ordinal()) {
                this.func_180649_a(world, pos, player);
                return false;
            }
        }
        return willHarvest || super.removedByPlayer(world, pos, player, false);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityDrawers tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile != null && !tile.isSealed()) {
            for (int i = 0; i < tile.getUpgradeSlotCount(); ++i) {
                ItemStack stack = tile.getUpgrade(i);
                if (stack == null || stack.func_77973_b() instanceof ItemUpgradeCreative) continue;
                BlockDrawers.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            if (!tile.isVending()) {
                DrawerInventoryHelper.dropInventoryItems(world, pos, tile);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack dropStack = this.getMainDrop(world, pos, state);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(dropStack);
        TileEntityDrawers tile = this.getTileEntity(world, pos);
        if (tile == null) {
            return drops;
        }
        NBTTagCompound data = dropStack.func_77978_p();
        if (data == null) {
            data = new NBTTagCompound();
        }
        BlockPlanks.EnumType material = this.translateMaterial(tile.getMaterialOrDefault());
        data.func_74778_a("material", material.func_176610_l());
        if (tile.isSealed()) {
            NBTTagCompound tiledata = new NBTTagCompound();
            tile.func_145841_b(tiledata);
            data.func_74782_a("tile", (NBTBase)tiledata);
        }
        dropStack.func_77982_d(data);
        return drops;
    }

    protected ItemStack getMainDrop(IBlockAccess world, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, state.func_177230_c().func_176201_c(state));
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        super.func_180657_a(world, player, pos, state, te);
        world.func_175698_g(pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileEntityDrawers tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile != null) {
            for (int slot = 0; slot < 5; ++slot) {
                ItemStack stack = tile.getUpgrade(slot);
                if (stack == null || !(stack.func_77973_b() instanceof ItemUpgradeStorage) || EnumUpgradeStorage.byMetadata(stack.func_77960_j()) != EnumUpgradeStorage.OBSIDIAN) continue;
                return 1000.0f;
            }
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public TileEntityDrawers createNewTileEntity(World world, int meta) {
        return new TileEntityDrawersStandard();
    }

    public TileEntityDrawers getTileEntity(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        return tile instanceof TileEntityDrawers ? (TileEntityDrawers)tile : null;
    }

    public TileEntityDrawers getTileEntitySafe(World world, BlockPos pos) {
        TileEntityDrawers tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile == null) {
            tile = this.createNewTileEntity(world, 0);
            world.func_175690_a(pos, (TileEntity)tile);
        }
        return tile;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        TileEntity tile = worldObj.func_175625_s(target.func_178782_a());
        if (tile instanceof TileEntityDrawers && ((TileEntityDrawers)tile).getDirection() == target.field_178784_b.ordinal()) {
            return true;
        }
        return super.addHitEffects(worldObj, target, effectRenderer);
    }

    public IBlockState func_176217_b(IBlockState state) {
        return this.func_176223_P();
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        for (EnumBasicDrawer type : EnumBasicDrawer.values()) {
            for (BlockPlanks.EnumType material : BlockPlanks.EnumType.values()) {
                ItemStack stack = new ItemStack(item, 1, type.getMetadata());
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("material", material.func_176610_l());
                stack.func_77982_d(data);
                if (!StorageDrawers.config.cache.creativeTabVanillaWoods && material != BlockPlanks.EnumType.OAK) continue;
                list.add(stack);
            }
        }
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_180656_a(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        if (!this.func_149744_f()) {
            return 0;
        }
        TileEntityDrawers tile = this.getTileEntity(worldIn, pos);
        if (tile == null || !tile.isRedstone()) {
            return 0;
        }
        return tile.getRedstoneLevel();
    }

    public int func_176211_b(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        return side == EnumFacing.UP ? this.func_180656_a(worldIn, pos, state, side) : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BLOCK, (Comparable)((Object)EnumBasicDrawer.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBasicDrawer)((Object)state.func_177229_b((IProperty)BLOCK))).getMetadata();
    }

    protected BlockState func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{BLOCK, VARIANT, FACING}, new IUnlistedProperty[]{TILE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityDrawers tile = this.getTileEntity(worldIn, pos);
        if (tile == null) {
            return state;
        }
        EnumFacing facing = EnumFacing.func_82600_a((int)tile.getDirection());
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        BlockPlanks.EnumType woodType = this.translateMaterial(tile.getMaterialOrDefault());
        return state.func_177226_a((IProperty)BLOCK, state.func_177229_b((IProperty)BLOCK)).func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)VARIANT, (Comparable)woodType);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!((state = this.func_176221_a(state, world, pos)) instanceof IExtendedBlockState)) {
            return state;
        }
        TileEntityDrawers tile = this.getTileEntity(world, pos);
        if (tile == null) {
            return state;
        }
        return ((IExtendedBlockState)state).withProperty(TILE, (Object)tile);
    }

    private BlockPlanks.EnumType translateMaterial(String materal) {
        for (BlockPlanks.EnumType type : BlockPlanks.EnumType.values()) {
            if (!materal.equals(type.func_176610_l())) continue;
            return type;
        }
        return BlockPlanks.EnumType.OAK;
    }
}

