/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemCustomDrawers;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockDrawersCustom
extends BlockDrawers {
    public BlockDrawersCustom(String blockName) {
        super(blockName);
    }

    @Override
    protected void initDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BLOCK, (Comparable)((Object)EnumBasicDrawer.FULL2)));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return layer == EnumWorldBlockLayer.CUTOUT_MIPPED || layer == EnumWorldBlockLayer.TRANSLUCENT;
    }

    @Override
    public BlockType retrimType() {
        return null;
    }

    @Override
    protected ItemStack getMainDrop(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntityDrawers tile = this.getTileEntity(world, pos);
        if (tile == null) {
            return ItemCustomDrawers.makeItemStack(state, 1, null, null, null);
        }
        return ItemCustomDrawers.makeItemStack(state, 1, tile.getMaterialSide(), tile.getMaterialTrim(), tile.getMaterialFront());
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        for (EnumBasicDrawer type : EnumBasicDrawer.values()) {
            list.add(new ItemStack(item, 1, type.getMetadata()));
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityDrawers tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile != null && tile.getMaterialSide() == null) {
            return false;
        }
        return super.func_180639_a(world, pos, state, player, side, hitX, hitY, hitZ);
    }

    @Override
    protected BlockState func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{BLOCK, FACING}, new IUnlistedProperty[]{TILE});
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityDrawers tile = this.getTileEntity(worldIn, pos);
        if (tile == null) {
            return state;
        }
        EnumFacing facing = EnumFacing.func_82600_a((int)tile.getDirection());
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return state.func_177226_a((IProperty)BLOCK, state.func_177229_b((IProperty)BLOCK)).func_177226_a((IProperty)FACING, (Comparable)facing);
    }
}

