/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.google.common.base.Predicate;
import com.jaquadro.minecraft.chameleon.block.properties.UnlistedTileEntity;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.core.handlers.GuiHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockFramingTable
extends BlockContainer {
    public static final int[][] leftOffset = new int[][]{{0, 0}, {0, 0}, {1, 0}, {-1, 0}, {0, -1}, {0, 1}};
    public static final int[][] rightOffset = new int[][]{{0, 0}, {0, 0}, {-1, 0}, {1, 0}, {0, 1}, {0, -1}};
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool RIGHT_SIDE = PropertyBool.func_177716_a((String)"right");
    public static final IUnlistedProperty<TileEntityFramingTable> TILE = UnlistedTileEntity.create(TileEntityFramingTable.class);

    public BlockFramingTable(String blockName) {
        super(Material.field_151575_d);
        this.func_149647_a(ModCreativeTabs.tabStorageDrawers);
        this.func_149711_c(2.5f);
        this.func_149672_a(field_149766_f);
        this.func_149663_c(blockName);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)RIGHT_SIDE, (Comparable)Boolean.valueOf(true)));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFramingTable();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float vx, float vy, float vz) {
        int priX = pos.func_177958_n() + this.getXOff(state);
        int priZ = pos.func_177952_p() + this.getZOff(state);
        IBlockState targetState = world.func_180495_p(new BlockPos(priX, pos.func_177956_o(), priZ));
        if (targetState.func_177230_c() != this || !BlockFramingTable.isRightBlock(targetState)) {
            return false;
        }
        player.openGui((Object)StorageDrawers.instance, GuiHandler.framingGuiID, world, priX, pos.func_177956_o(), priZ);
        return true;
    }

    private int getXOff(IBlockState state) {
        if (BlockFramingTable.isRightBlock(state)) {
            return 0;
        }
        return rightOffset[BlockFramingTable.getDirection(state).func_176745_a()][0];
    }

    private int getZOff(IBlockState state) {
        if (BlockFramingTable.isRightBlock(state)) {
            return 0;
        }
        return rightOffset[BlockFramingTable.getDirection(state).func_176745_a()][1];
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_176225_a(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int func_149645_b() {
        return 3;
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return layer == EnumWorldBlockLayer.SOLID || layer == EnumWorldBlockLayer.TRANSLUCENT;
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block block) {
        EnumFacing side = BlockFramingTable.getDirection(state);
        if (BlockFramingTable.isRightBlock(state)) {
            BlockPos otherPos = pos.func_177982_a(leftOffset[side.func_176745_a()][0], 0, leftOffset[side.func_176745_a()][1]);
            if (world.func_180495_p(otherPos).func_177230_c() != this) {
                world.func_175698_g(pos);
                if (!world.field_72995_K) {
                    this.func_176226_b(world, pos, state, 0);
                }
            }
        } else {
            BlockPos otherPos = pos.func_177982_a(rightOffset[side.func_176745_a()][0], 0, rightOffset[side.func_176745_a()][1]);
            if (world.func_180495_p(otherPos).func_177230_c() != this) {
                world.func_175698_g(pos);
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return BlockFramingTable.isPrimaryBlock(state) ? Item.func_150898_a((Block)ModBlocks.framingTable) : Item.func_150899_d((int)0);
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (BlockFramingTable.isPrimaryBlock(state)) {
            super.func_180653_a(world, pos, state, chance, fortune);
        }
    }

    public int func_149656_h() {
        return 1;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        EnumFacing side;
        if (player.field_71075_bZ.field_75098_d && !BlockFramingTable.isPrimaryBlock(state) && world.func_180495_p(pos = pos.func_177982_a(rightOffset[(side = BlockFramingTable.getDirection(state)).func_176745_a()][0], 0, rightOffset[side.func_176745_a()][1])).func_177230_c() == this) {
            world.func_175698_g(pos);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityFramingTable tile = (TileEntityFramingTable)world.func_175625_s(pos);
        if (tile != null && BlockFramingTable.isPrimaryBlock(state)) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tile);
        }
        super.func_180663_b(world, pos, state);
    }

    public static EnumFacing getDirection(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)FACING);
    }

    public static boolean isRightBlock(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)RIGHT_SIDE);
    }

    public static boolean isPrimaryBlock(IBlockState state) {
        return BlockFramingTable.isRightBlock(state);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing side = EnumFacing.func_82600_a((int)(meta & 7));
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            side = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)RIGHT_SIDE, (Comparable)Boolean.valueOf((meta & 8) == 0)).func_177226_a((IProperty)FACING, (Comparable)side);
    }

    public int func_176201_c(IBlockState state) {
        return (BlockFramingTable.isRightBlock(state) ? 8 : 0) | BlockFramingTable.getDirection(state).func_176745_a();
    }

    protected BlockState func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{RIGHT_SIDE, FACING}, new IUnlistedProperty[]{TILE});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!((state = this.func_176221_a(state, world, pos)) instanceof IExtendedBlockState)) {
            return state;
        }
        TileEntityFramingTable tile = (TileEntityFramingTable)world.func_175625_s(pos);
        if (tile == null) {
            return state;
        }
        return ((IExtendedBlockState)state).withProperty(TILE, (Object)tile);
    }
}

