/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public abstract class BaseTileEntity
extends TileEntityLockable {
    private NBTTagCompound failureSnapshot;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.failureSnapshot = null;
        try {
            this.readFromFixedNBT(tag);
            this.readFromPortableNBT(tag);
        }
        catch (Throwable t) {
            this.trapLoadFailure(t, tag);
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.failureSnapshot != null) {
            this.restoreLoadFailure(tag);
            return;
        }
        try {
            this.writeToFixedNBT(tag);
            this.writeToPortableNBT(tag);
        }
        catch (Throwable t) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.ERROR, (Throwable)t, (String)"Tile Save Failure.", (Object[])new Object[0]);
        }
    }

    public void readFromPortableNBT(NBTTagCompound tag) {
    }

    public void writeToPortableNBT(NBTTagCompound tag) {
    }

    protected void readFromFixedNBT(NBTTagCompound tag) {
    }

    protected void writeToFixedNBT(NBTTagCompound tag) {
    }

    protected void trapLoadFailure(Throwable t, NBTTagCompound tag) {
        this.failureSnapshot = (NBTTagCompound)tag.func_74737_b();
        FMLLog.log((String)"StorageDrawers", (Level)Level.ERROR, (Throwable)t, (String)"Tile Load Failure.", (Object[])new Object[0]);
    }

    protected void restoreLoadFailure(NBTTagCompound tag) {
        for (String key : this.failureSnapshot.func_150296_c()) {
            if (tag.func_74764_b(key)) continue;
            tag.func_74782_a(key, this.failureSnapshot.func_74781_a(key).func_74737_b());
        }
    }

    protected boolean loadDidFail() {
        return this.failureSnapshot != null;
    }
}

